/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.lib.attributes;

import com.sap.security.saml2.lib.attributes.AttributeValuePair;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AttributeValues {
    private Map<String, AttributeValuePair> values = new HashMap<String, AttributeValuePair>();

    public AttributeValues() {
    }

    public AttributeValues(List<AttributeValuePair> pairs) {
        if (pairs != null) {
            for (AttributeValuePair pair : pairs) {
                if (pair == null) continue;
                this.values.put(pair.getName(), pair);
            }
        }
    }

    public AttributeValuePair get(String attributeName) {
        return this.values.get(attributeName);
    }

    public Set<String> keySet() {
        return this.values.keySet();
    }

    public void put(AttributeValuePair pair) {
        if (pair != null) {
            this.values.put(pair.getName(), pair);
        }
    }

    public String toString() {
        Collection<AttributeValuePair> attributes = this.values.values();
        StringBuilder builder = new StringBuilder(128);
        builder.append("Attributes \n");
        for (AttributeValuePair attr : attributes) {
            builder.append(attr.toString());
        }
        return builder.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.values == null ? 0 : this.values.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AttributeValues other = (AttributeValues)obj;
        return !(this.values == null ? other.values != null : !this.values.equals(other.values));
    }
}

