/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.lib.bindings;

import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.common.SAML2Utils;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2Artifact;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2RequestBase;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2ResponseBase;
import com.sap.security.saml2.lib.resources.SAML2ResourceBundle;
import com.sap.tc.logging.Location;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HTTPPostBinding {
    private static final Location LOCATION = Location.getLocation(HTTPPostBinding.class);
    private static final String HTML_BEGINNING = "<!DOCTYPE html PUBLIC \"-//WAPFORUM//DTD XHTML Mobile 1.0//EN\" \"http://www.wapforum.org/DTD/xhtml-mobile10.dtd\"><html xmlns=\"http://www.w3.org/1999/xhtml\"><head><meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no, shrink-to-fit=no\"><meta http-equiv=\"pragma\" content=\"no-cache\" /></head>";
    private static final String HTML_BODY_AUTO_SUBMIT = "<body onload=\"document.forms[0].submit()\"><p><script language=\"javascript\">document.write(\"";
    private static final String HTML_BODY_ANCHOR_COOKIE_PART1 = "<body style=\"background-color:#FFFFFF\" onload=\"var url=window.location.hash;if(url&&0!==url.length){var anchorCookie='";
    private static final String HTML_BODY_ANCHOR_COOKIE_PART2 = "=&quot;'+encodeURIComponent(url)+'&quot;';document.cookie=anchorCookie}document.forms[0].submit()\"><p><script language=\"javascript\">document.write(\"";
    public static final String ANCHOR_COOKIE_NAME_SUFFIX = "_anchor";
    private static final String HTML_CONTINUATION = "\");</script></p><noscript><p>";
    private static final String FORM_BEGINNING = "</p></noscript><form method=\"post\" action=\"";
    private static final String FORM_BEGINNING_CLOSE = "\">";
    private static final String INPUT_RESPONSE = "<input type=\"hidden\" name=\"SAMLResponse\" value=\"";
    private static final String INPUT_REQUEST = "<input type=\"hidden\" name=\"SAMLRequest\" value=\"";
    private static final String INPUT_ARTIFACT = "<input type=\"hidden\" name=\"SAMLart\" value=\"";
    private static final String INPUT_R_STATE = "<input type=\"hidden\" name=\"RelayState\" value=\"";
    private static final String INPUT_ENDING = "\"/>";
    private static final String SUBMIT_BUTTON = "<noscript><input type=\"submit\" value=\"";
    private static final String FORM_AND_HTML_ENDING = "\"/></noscript></form></body></html>";
    private static final int EMPTY_FORM_LENGTH = 400;
    private static final int BUFFER = 50;
    private static final String CONTENT_TYPE_VALUE = "text/html";
    private static final String CHARSET_ENCODING_VALUE = "utf-8";
    public static final String HTTP_HEADER_CONTENT_TYPE = "Content-Type";
    public static final String HTTP_HEADER_CONTENT_TYPE_VALUE = "text/html; charset=utf-8";
    private static final String HTTP_HEADER_CACHE_CONTROL = "Cache-Control";
    private static final String HTTP_HEADER_PRAGMA = "Pragma";
    private static final String HTTP_HEADER_VALUE_NO_CACHE = "no-cache";
    private static final String HTTP_HEADER_VALUE_NO_CACHE_NO_STORE_MUST_REVALIDATE = "no-cache, no-store, must-revalidate";
    private static final Map<String, String> CACHE_CONTROL_HEADERS;
    public static final String SAML_REQUEST = "SAMLRequest";
    public static final String SAML_ARTIFACT = "SAMLart";
    public static final String SAML_RESPONSE = "SAMLResponse";
    public static final String SAML_RELAY_STATE = "RelayState";
    public static final String PROXY_SAML_RELAY_STATE = "ProxyRelayState";
    public static final String PROXY_SAML_ARTIFACT = "ProxySAMLart";
    public static final String PROXY_SAML_RESPONSE = "ProxySAMLResponse";

    static {
        HashMap<String, String> tempMap = new HashMap<String, String>(2);
        tempMap.put(HTTP_HEADER_CACHE_CONTROL, HTTP_HEADER_VALUE_NO_CACHE_NO_STORE_MUST_REVALIDATE);
        tempMap.put(HTTP_HEADER_PRAGMA, HTTP_HEADER_VALUE_NO_CACHE);
        CACHE_CONTROL_HEADERS = Collections.unmodifiableMap(tempMap);
    }

    public static String generateRequestForm(String xmlRequest, String relayState, String destination, Locale locale) throws SAML2Exception {
        return HTTPPostBinding.generateRequestForm(xmlRequest, relayState, destination, locale, false);
    }

    public static String generateRequestForm(String xmlRequest, String relayState, String destination, Locale locale, boolean enableCookieGeneration) throws SAML2Exception {
        if (xmlRequest == null || xmlRequest.length() < 1) {
            throw new SAML2Exception("Could not generate autosubmitted form - xml request is empty: " + xmlRequest);
        }
        if (destination == null || destination.length() < 1) {
            throw new SAML2Exception("Could not generate autosubmitted form - action destination is empty: " + destination);
        }
        String encRequest = SAML2Utils.encodeBase64AsString(xmlRequest);
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Generate auto-submitted html form:\n destination: {0}\n SAML2 request: {1}\n Relay State: {2}", new Object[]{destination, encRequest, relayState});
        }
        int length = 450 + encRequest.length() + destination.length();
        StringBuilder builder = new StringBuilder(length);
        if (enableCookieGeneration && relayState != null) {
            builder.append(HTTPPostBinding.getFormBeginning(destination, locale, enableCookieGeneration, String.valueOf(HTTPPostBinding.encodeHTML(relayState)) + ANCHOR_COOKIE_NAME_SUFFIX));
        } else {
            builder.append(HTTPPostBinding.getFormBeginning(destination, locale));
        }
        builder.append(INPUT_REQUEST).append(encRequest).append(INPUT_ENDING);
        if (relayState != null) {
            builder.append(INPUT_R_STATE).append(HTTPPostBinding.encodeHTML(relayState)).append(INPUT_ENDING);
        }
        builder.append(HTTPPostBinding.getFormEnding(locale));
        String requestForm = builder.toString();
        return requestForm;
    }

    public static void sendSAML2Request(HttpServletRequest httpRequest, HttpServletResponse httpResponse, SAML2RequestBase saml2Request, String relayState) throws SAML2Exception, IOException {
        if (saml2Request == null) {
            throw new SAML2Exception("SAML2 request could not be null");
        }
        String destination = saml2Request.getDestination();
        if (destination == null) {
            throw new SAML2Exception("SAML2 request with empty destination could not be send over POST binding");
        }
        String saml2RequestXML = saml2Request.generate();
        String htmlForm = HTTPPostBinding.generateRequestForm(saml2RequestXML, relayState, destination, httpRequest.getLocale());
        HTTPPostBinding.sendHTMLForm(httpResponse, htmlForm);
    }

    public static String generateArtifactForm(String artifact, String relayState, String destination, Locale locale) throws SAML2Exception {
        if (artifact == null || artifact.length() < 1) {
            throw new SAML2Exception("Could not generate auto-submitted form - artifact value is empty: " + artifact);
        }
        if (destination == null || destination.length() < 1) {
            throw new SAML2Exception("Could not generate auto-submitted form - action destination is empty: " + destination);
        }
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Generate auto-submitted html form:\n destination: {0}\n SAML2 Artifact: {1}\n Relay State: {2}", new Object[]{destination, artifact, relayState});
        }
        int length = 450 + artifact.length() + destination.length();
        StringBuilder builder = new StringBuilder(length);
        builder.append(HTTPPostBinding.getFormBeginning(destination, locale));
        builder.append(INPUT_ARTIFACT).append(HTTPPostBinding.encodeHTML(artifact)).append(INPUT_ENDING);
        if (relayState != null) {
            builder.append(INPUT_R_STATE).append(HTTPPostBinding.encodeHTML(relayState)).append(INPUT_ENDING);
        }
        builder.append(HTTPPostBinding.getFormEnding(locale));
        String requestForm = builder.toString();
        return requestForm;
    }

    public static void sendSAML2Artifact(HttpServletRequest httpRequest, HttpServletResponse httpResponse, SAML2Artifact saml2Artifact, String relayState, String destination) throws SAML2Exception, IOException {
        if (saml2Artifact == null) {
            throw new SAML2Exception("SAML2 artifact could not be null");
        }
        if (destination == null) {
            throw new SAML2Exception("SAML2 artifact could not be send to empty destination over POST binding");
        }
        String htmlForm = HTTPPostBinding.generateArtifactForm(saml2Artifact.getValue(), relayState, destination, httpRequest.getLocale());
        HTTPPostBinding.sendHTMLForm(httpResponse, htmlForm);
    }

    public static String generateResponseForm(String xmlResponse, String relayState, String destination, Locale locale) throws SAML2Exception {
        if (xmlResponse == null || xmlResponse.length() < 1) {
            throw new SAML2Exception("Could not generate auto-submitted form - xml response is empty: " + xmlResponse);
        }
        if (destination == null || destination.length() < 1) {
            throw new SAML2Exception("Could not generate auto-submitted form - action destination is empty: " + destination);
        }
        String encResponse = SAML2Utils.encodeBase64AsString(xmlResponse);
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Generate auto-submitted html form:\n destination: {0}\n SAML2 response: {1}\n Relay State: {2}", new Object[]{destination, encResponse, relayState});
        }
        int length = 450 + encResponse.length() + destination.length();
        StringBuilder builder = new StringBuilder(length);
        builder.append(HTTPPostBinding.getFormBeginning(destination, locale));
        builder.append(INPUT_RESPONSE).append(encResponse).append(INPUT_ENDING);
        if (relayState != null) {
            builder.append(INPUT_R_STATE).append(HTTPPostBinding.encodeHTML(relayState)).append(INPUT_ENDING);
        }
        builder.append(HTTPPostBinding.getFormEnding(locale));
        String responseForm = builder.toString();
        return responseForm;
    }

    public static void sendSAML2Response(HttpServletRequest httpRequest, HttpServletResponse httpResponse, SAML2ResponseBase saml2Response, String relayState) throws SAML2Exception, IOException {
        if (saml2Response == null) {
            throw new SAML2Exception("SAML2 response could not be null");
        }
        String destination = saml2Response.getDestination();
        if (destination == null) {
            throw new SAML2Exception("SAML2 response with empty destination could not be send over POST binding");
        }
        String saml2ResponseXML = saml2Response.generate();
        String htmlForm = HTTPPostBinding.generateResponseForm(saml2ResponseXML, relayState, destination, httpRequest.getLocale());
        HTTPPostBinding.sendHTMLForm(httpResponse, htmlForm);
    }

    public static String generateEmptyForm(String destination, Locale locale) {
        StringBuilder sb = new StringBuilder(500);
        sb.append(HTTPPostBinding.getFormBeginning(destination, locale));
        sb.append(HTTPPostBinding.getFormEnding(locale));
        return sb.toString();
    }

    public static void sendEmptyForm(HttpServletRequest httpRequest, HttpServletResponse httpResponse, String destination) throws IOException {
        String htmlForm = HTTPPostBinding.generateEmptyForm(destination, httpRequest.getLocale());
        HTTPPostBinding.sendHTMLForm(httpResponse, htmlForm);
    }

    public static String extractSAMLRequest(HttpServletRequest request) throws SAML2Exception {
        SAML2Utils.checkRequestContentLengthHeader(request.getContentLength());
        String encSAMLRequest = request.getParameter(SAML_REQUEST);
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Extracted SAMLRequest parameter is: " + encSAMLRequest);
        }
        encSAMLRequest = HTTPPostBinding.decodeHTML(encSAMLRequest);
        if (LOCATION.beDebug()) {
            LOCATION.debugT("HTML Decoded SAMLRequest parameter is: " + encSAMLRequest);
        }
        SAML2Utils.checkRequestParameterLength(encSAMLRequest);
        String decSAMLRequest = null;
        if (encSAMLRequest != null && encSAMLRequest.length() > 0) {
            decSAMLRequest = SAML2Utils.decodeBase64AsString(encSAMLRequest);
        }
        return decSAMLRequest;
    }

    public static String extractSAMLart(HttpServletRequest request) throws SAML2Exception {
        SAML2Utils.checkRequestContentLengthHeader(request.getContentLength());
        String samlArt = request.getParameter(SAML_ARTIFACT);
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Extracted SAMLart parameter is: " + samlArt);
        }
        SAML2Utils.checkRequestParameterLength(samlArt);
        return samlArt;
    }

    public static String extractSAMLResponse(HttpServletRequest request) throws SAML2Exception {
        SAML2Utils.checkRequestContentLengthHeader(request.getContentLength());
        String encSAMLResponse = request.getParameter(SAML_RESPONSE);
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Extracted SAMLResponse parameter is: " + encSAMLResponse);
        }
        encSAMLResponse = HTTPPostBinding.decodeHTML(encSAMLResponse);
        if (LOCATION.beDebug()) {
            LOCATION.debugT("HTML Decoded SAMLResponse parameter is: " + encSAMLResponse);
        }
        SAML2Utils.checkRequestParameterLength(encSAMLResponse);
        String decSAMLResponse = null;
        if (encSAMLResponse != null && encSAMLResponse.length() > 0) {
            decSAMLResponse = SAML2Utils.decodeBase64AsString(encSAMLResponse);
        }
        return decSAMLResponse;
    }

    public static String extractSAMLRelayState(HttpServletRequest request) {
        String samlRelayState = request.getParameter(SAML_RELAY_STATE);
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Extracted RelayState parameter is: " + samlRelayState);
        }
        return samlRelayState;
    }

    public static String getFormBeginning(String destination, Locale locale) {
        return HTTPPostBinding.getFormBeginning(destination, locale, false, null);
    }

    public static String getFormBeginning(String destination, Locale locale, boolean enableCookieGeneration, String cookieName) {
        SAML2ResourceBundle resourceBundle = SAML2ResourceBundle.getInstance();
        StringBuilder builder = new StringBuilder(500);
        builder.append(HTML_BEGINNING);
        if (enableCookieGeneration) {
            builder.append(HTML_BODY_ANCHOR_COOKIE_PART1);
            builder.append(cookieName);
            builder.append(HTML_BODY_ANCHOR_COOKIE_PART2);
        } else {
            builder.append(HTML_BODY_AUTO_SUBMIT);
        }
        builder.append(resourceBundle.getResource("POST_MSG", locale));
        builder.append(HTML_CONTINUATION);
        builder.append(resourceBundle.getResource("POST_MSG_NO_SCRIPT", locale));
        builder.append(FORM_BEGINNING);
        builder.append(destination);
        builder.append(FORM_BEGINNING_CLOSE);
        return builder.toString();
    }

    public static String getFormEnding(Locale locale) {
        StringBuilder builder = new StringBuilder();
        builder.append(SUBMIT_BUTTON);
        builder.append(SAML2ResourceBundle.getInstance().getResource("POST_BUTTON_CONTINUE", locale));
        builder.append(FORM_AND_HTML_ENDING);
        return builder.toString();
    }

    public static void sendHTMLForm(HttpServletResponse httpResponse, String htmlForm) throws IOException {
        httpResponse.setContentType(CONTENT_TYPE_VALUE);
        httpResponse.setCharacterEncoding(CHARSET_ENCODING_VALUE);
        for (String headerName : HTTPPostBinding.getCacheControlHeaders().keySet()) {
            httpResponse.setHeader(headerName, HTTPPostBinding.getCacheControlHeaders().get(headerName));
        }
        PrintWriter responseWriter = httpResponse.getWriter();
        responseWriter.write(htmlForm);
        responseWriter.flush();
    }

    public static final Map<String, String> getCacheControlHeaders() {
        return CACHE_CONTROL_HEADERS;
    }

    public static String encodeHTML(String orig) {
        if (orig == null) {
            return null;
        }
        Pattern pattern = Pattern.compile("[><\"&\n\t ]");
        Matcher matcher = pattern.matcher(orig);
        if (matcher.find()) {
            int length = orig.length();
            StringBuffer result = new StringBuffer(Math.round((float)length * 1.1f));
            int i = 0;
            while (i < length) {
                char c = orig.charAt(i);
                switch (c) {
                    case '<': {
                        result.append("&lt;");
                        break;
                    }
                    case '>': {
                        result.append("&gt;");
                        break;
                    }
                    case '&': {
                        result.append("&amp;");
                        break;
                    }
                    case '\n': {
                        result.append("<BR>");
                        break;
                    }
                    case ' ': {
                        result.append("&#32;");
                        break;
                    }
                    case '\t': {
                        result.append("&nbsp;&nbsp;");
                        break;
                    }
                    case '\"': {
                        result.append("&quot;");
                        break;
                    }
                    default: {
                        result.append(c);
                    }
                }
                ++i;
            }
            return result.toString();
        }
        return orig;
    }

    public static String decodeHTML(String orig) {
        if (orig == null) {
            return null;
        }
        int index = 0;
        StringBuilder result = new StringBuilder(orig.length());
        while (index < orig.length()) {
            char c = orig.charAt(index);
            if (c == '<' && HTTPPostBinding.regionMatches(orig, index, "<BR>")) {
                index += 4;
                result.append('\n');
                continue;
            }
            if (c == '&') {
                if (HTTPPostBinding.regionMatches(orig, index, "&lt;")) {
                    result.append('<');
                    index += 4;
                    continue;
                }
                if (HTTPPostBinding.regionMatches(orig, index, "&gt;")) {
                    result.append('>');
                    index += 4;
                    continue;
                }
                if (HTTPPostBinding.regionMatches(orig, index, "&amp;")) {
                    result.append('&');
                    index += 5;
                    continue;
                }
                if (HTTPPostBinding.regionMatches(orig, index, "&#32;")) {
                    result.append(' ');
                    index += 5;
                    continue;
                }
                if (HTTPPostBinding.regionMatches(orig, index, "&nbsp;&nbsp;")) {
                    result.append('\t');
                    index += 12;
                    continue;
                }
                if (HTTPPostBinding.regionMatches(orig, index, "&quot;")) {
                    result.append('\"');
                    index += 6;
                    continue;
                }
                result.append(c);
                ++index;
                continue;
            }
            result.append(c);
            ++index;
        }
        return result.toString();
    }

    private static boolean regionMatches(String orig, int index, String otherString) {
        return orig.regionMatches(true, index, otherString, 0, otherString.length());
    }
}

