/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.lib.bindings;

import com.sap.security.saml2.lib.bindings.RedirectPayloadDeflateImpl;
import com.sap.security.saml2.lib.common.SAML2DataFactory;
import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.interfaces.bindings.RedirectPayloadDeflate;
import com.sap.tc.logging.Location;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HTTPRedirectBindingDeflate {
    private static final Location LOCATION = Location.getLocation(HTTPRedirectBindingDeflate.class);

    public static String generateRedirectLocationURL(String destination, RedirectPayloadDeflate payload) throws SAML2Exception {
        if (destination == null || destination.length() < 1) {
            throw new SAML2Exception("Invalid destination argument: " + destination);
        }
        if (payload == null) {
            throw new SAML2Exception("Payload argument cannot be null");
        }
        String queryString = payload.getQueryString();
        StringBuilder builder = new StringBuilder(destination.length() + queryString.length() + 1);
        builder.append(destination);
        if (destination.indexOf(63) < 0) {
            builder.append('?');
        } else {
            builder.append('&');
        }
        builder.append(queryString);
        String locationURL = builder.toString();
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Generated redirect location URL is: " + locationURL);
        }
        if (locationURL.length() > 2048 && LOCATION.beWarning()) {
            LOCATION.warningT("Generated redirect location URL has length: " + locationURL.length() + " that may exceed the maximum length supported by some browsers. " + "This may cause browser unability to redirect or corrupted binding parameters.");
        }
        return locationURL;
    }

    public static void redirect(HttpServletResponse response, String destination, RedirectPayloadDeflate payload) throws SAML2Exception {
        if (response == null) {
            throw new SAML2Exception("Response parameter cannot be null");
        }
        String locationURL = HTTPRedirectBindingDeflate.generateRedirectLocationURL(destination, payload);
        try {
            response.sendRedirect(locationURL);
        }
        catch (Exception e) {
            throw new SAML2Exception("Failed to redirect with location URL: " + locationURL, e);
        }
    }

    public static RedirectPayloadDeflate extractRedirectPayload(String queryString) throws SAML2Exception {
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Query string: {0}", new Object[]{queryString});
        }
        if (HTTPRedirectBindingDeflate.isQueryStringContainsSAML2Payload(queryString)) {
            return SAML2DataFactory.getInstance().createRedirectPayloadDeflate(queryString);
        }
        if (LOCATION.beDebug()) {
            LOCATION.debugT("This query string does not contain any SAML2 payload");
        }
        return null;
    }

    public static RedirectPayloadDeflate extractRedirectPayload(HttpServletRequest request) throws SAML2Exception {
        if (request == null) {
            throw new SAML2Exception("Request argument cannot be null");
        }
        String queryString = request.getQueryString();
        RedirectPayloadDeflate redirectPayload = HTTPRedirectBindingDeflate.extractRedirectPayload(queryString);
        return redirectPayload;
    }

    private static boolean isQueryStringContainsSAML2Payload(String queryString) {
        boolean result = false;
        if (queryString != null && (queryString.contains(RedirectPayloadDeflateImpl.SAML_REQUEST_PARAMETER) || queryString.contains(RedirectPayloadDeflateImpl.SAML_RESPONSE_PARAMETER) || queryString.contains(RedirectPayloadDeflateImpl.SAML_ARTIFACT_PARAMETER))) {
            result = true;
        }
        return result;
    }
}

