/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.lib.bindings;

import com.sap.security.saml2.lib.assertions.SAML2IDPEntryJxbImpl;
import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.common.SAML2JAXBUtils;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2IDPEntry;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2NameID;
import com.sap.security.saml2.lib.interfaces.bindings.SOAPHeaderECPRequest;
import com.sap.security.saml2.lib.interfaces.bindings.SOAPHeaderECPResponse;
import com.sap.security.saml2.lib.interfaces.bindings.SOAPHeaderEntry;
import com.sap.security.saml2.lib.interfaces.bindings.SOAPHeaderPAOSRequest;
import com.sap.security.saml2.lib.interfaces.bindings.SOAPHeaderPAOSResponse;
import com.sap.security.saml2.lib.interfaces.bindings.SOAPHeaderRelayState;
import com.sap.security.saml2.lib.jaxb.liberty.paos.ResponseType;
import com.sap.security.saml2.lib.jaxb.profiles.sso.ecp.ObjectFactory;
import com.sap.security.saml2.lib.jaxb.profiles.sso.ecp.RelayStateType;
import com.sap.security.saml2.lib.jaxb.profiles.sso.ecp.RequestType;
import com.sap.security.saml2.lib.jaxb.protocol.IDPListType;
import java.util.List;
import javax.xml.bind.JAXBElement;

public final class PAOSDataFactory {
    private static final PAOSDataFactory instance = new PAOSDataFactory();

    private PAOSDataFactory() {
    }

    public static PAOSDataFactory getInstance() {
        return instance;
    }

    public SOAPHeaderPAOSRequest createPAOSRequest(String responseConsumerURL) {
        return new SOAPHeaderPAOSRequestImpl(responseConsumerURL);
    }

    public SOAPHeaderPAOSResponse createPAOSResponse() {
        return new SOAPHeaderPAOSResponseImpl();
    }

    public SOAPHeaderECPRequest createECPRequest() {
        return new SOAPHeaderECPRequestImpl();
    }

    public SOAPHeaderECPResponse createECPResponse(String assertionConsumerServiceURL) {
        return new SOAPHeaderECPResponseImpl(assertionConsumerServiceURL);
    }

    public SOAPHeaderRelayState createRelayState(String relayState) {
        return new SOAPHeaderRelayStateImpl(relayState);
    }

    class SOAPHeaderECPRequestImpl
    extends SOAPHeaderEntryImpl
    implements SOAPHeaderECPRequest {
        private List<SAML2IDPEntry> idpList;
        private SAML2NameID issuer;
        private String providerName;
        private Boolean passive;

        SOAPHeaderECPRequestImpl() {
        }

        @Override
        public String generate() throws SAML2Exception {
            ObjectFactory factory = new ObjectFactory();
            RequestType ecpRequest = factory.createRequestType();
            if (this.issuer == null) {
                throw new SAML2Exception("Issuer cannot be null");
            }
            ecpRequest.setIssuer(this.issuer.convertToSAMLGenerator());
            if (this.passive != null) {
                ecpRequest.setIsPassive(this.passive);
            }
            ecpRequest.setProviderName(this.providerName);
            if (this.idpList != null) {
                IDPListType jaxbIdPList = new com.sap.security.saml2.lib.jaxb.protocol.ObjectFactory().createIDPListType();
                for (SAML2IDPEntry idpEntry : this.idpList) {
                    if (idpEntry == null) continue;
                    jaxbIdPList.getIDPEntry().add(((SAML2IDPEntryJxbImpl)idpEntry).convertToSAMLGenerator());
                }
                ecpRequest.setIDPList(jaxbIdPList);
            }
            ecpRequest.setActor(this.getActor());
            ecpRequest.setMustUnderstand(this.isMustUnderstand());
            JAXBElement<RequestType> ecpRequestEl = factory.createRequest(ecpRequest);
            String result = SAML2JAXBUtils.marshalPAOSorECPTokenToText(ecpRequestEl);
            return result;
        }

        @Override
        public List<SAML2IDPEntry> getIDPList() {
            return this.idpList;
        }

        @Override
        public SAML2NameID getIssuer() {
            return this.issuer;
        }

        @Override
        public String getProviderName() {
            return this.providerName;
        }

        @Override
        public boolean isPassive() {
            return this.passive;
        }

        @Override
        public void setIDPList(List<SAML2IDPEntry> idps) {
            this.idpList = idps;
        }

        @Override
        public void setIssuer(SAML2NameID issuer) {
            this.issuer = issuer;
        }

        @Override
        public void setPassive(boolean isPassive) {
            this.passive = isPassive;
        }

        @Override
        public void setProviderName(String humanReadableName) {
            this.providerName = humanReadableName;
        }
    }

    class SOAPHeaderECPResponseImpl
    extends SOAPHeaderEntryImpl
    implements SOAPHeaderECPResponse {
        private String assertionConsumerServiceURL;

        public SOAPHeaderECPResponseImpl(String assertionConsumerServiceURL) {
            this.assertionConsumerServiceURL = assertionConsumerServiceURL;
        }

        @Override
        public String generate() throws SAML2Exception {
            ObjectFactory factory = new ObjectFactory();
            com.sap.security.saml2.lib.jaxb.profiles.sso.ecp.ResponseType ecpResponse = factory.createResponseType();
            ecpResponse.setAssertionConsumerServiceURL(this.assertionConsumerServiceURL);
            ecpResponse.setActor(super.getActor());
            ecpResponse.setMustUnderstand(super.isMustUnderstand());
            JAXBElement<com.sap.security.saml2.lib.jaxb.profiles.sso.ecp.ResponseType> ecpResponseEl = factory.createResponse(ecpResponse);
            String result = SAML2JAXBUtils.marshalPAOSorECPTokenToText(ecpResponseEl);
            return result;
        }

        @Override
        public String getAssertionConsumerServiceURL() {
            return this.assertionConsumerServiceURL;
        }
    }

    abstract class SOAPHeaderEntryImpl
    implements SOAPHeaderEntry {
        private String actor = "http://schemas.xmlsoap.org/soap/actor/next";
        private boolean mustUnderstand = true;

        @Override
        public String getActor() {
            return this.actor;
        }

        @Override
        public boolean isMustUnderstand() {
            return this.mustUnderstand;
        }
    }

    class SOAPHeaderPAOSRequestImpl
    extends SOAPHeaderEntryImpl
    implements SOAPHeaderPAOSRequest {
        private String messageID;
        private String responseConsumerURL;
        private String service;

        public SOAPHeaderPAOSRequestImpl(String responseConsumerURL) {
            this.responseConsumerURL = responseConsumerURL;
            this.service = "urn:oasis:names:tc:SAML:2.0:profiles:SSO:ecp";
        }

        @Override
        public String generate() throws SAML2Exception {
            com.sap.security.saml2.lib.jaxb.liberty.paos.ObjectFactory factory = new com.sap.security.saml2.lib.jaxb.liberty.paos.ObjectFactory();
            com.sap.security.saml2.lib.jaxb.liberty.paos.RequestType ecpRequest = factory.createRequestType();
            ecpRequest.setMessageID(this.messageID);
            ecpRequest.setResponseConsumerURL(this.responseConsumerURL);
            ecpRequest.setService(this.service);
            ecpRequest.setActor(super.getActor());
            ecpRequest.setMustUnderstand(super.isMustUnderstand());
            JAXBElement<com.sap.security.saml2.lib.jaxb.liberty.paos.RequestType> ecpRequestEl = factory.createRequest(ecpRequest);
            String result = SAML2JAXBUtils.marshalPAOSorECPTokenToText(ecpRequestEl);
            return result;
        }

        @Override
        public String getMessageID() {
            return this.messageID;
        }

        @Override
        public String getResponseConsumerURL() {
            return this.responseConsumerURL;
        }

        @Override
        public String getService() {
            return this.service;
        }

        @Override
        public void setMessageID(String messageID) {
            this.messageID = messageID;
        }
    }

    class SOAPHeaderPAOSResponseImpl
    extends SOAPHeaderEntryImpl
    implements SOAPHeaderPAOSResponse {
        private String refToMessageID;

        SOAPHeaderPAOSResponseImpl() {
        }

        @Override
        public String generate() throws SAML2Exception {
            com.sap.security.saml2.lib.jaxb.liberty.paos.ObjectFactory factory = new com.sap.security.saml2.lib.jaxb.liberty.paos.ObjectFactory();
            ResponseType ecpResponse = factory.createResponseType();
            ecpResponse.setRefToMessageID(this.refToMessageID);
            ecpResponse.setActor(super.getActor());
            ecpResponse.setMustUnderstand(super.isMustUnderstand());
            JAXBElement<ResponseType> ecpResponseEl = factory.createResponse(ecpResponse);
            String result = SAML2JAXBUtils.marshalPAOSorECPTokenToText(ecpResponseEl);
            return result;
        }

        @Override
        public String getRefToMessageID() {
            return this.refToMessageID;
        }

        @Override
        public void setRefToMessageID(String id) {
            this.refToMessageID = id;
        }
    }

    class SOAPHeaderRelayStateImpl
    extends SOAPHeaderEntryImpl
    implements SOAPHeaderRelayState {
        private String relayState;

        public SOAPHeaderRelayStateImpl(String relayState) {
            this.relayState = relayState;
        }

        @Override
        public String getRelayState() {
            return this.relayState;
        }

        @Override
        public String generate() throws SAML2Exception {
            ObjectFactory factory = new ObjectFactory();
            RelayStateType ecpRelayState = factory.createRelayStateType();
            ecpRelayState.setValue(this.relayState);
            ecpRelayState.setActor(super.getActor());
            ecpRelayState.setMustUnderstand(super.isMustUnderstand());
            JAXBElement<RelayStateType> ecpRelayStateEl = factory.createRelayState(ecpRelayState);
            String result = SAML2JAXBUtils.marshalPAOSorECPTokenToText(ecpRelayStateEl);
            return result;
        }
    }
}

