/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.lib.bindings;

import com.sap.security.saml2.lib.bindings.PAOSDataFactory;
import com.sap.security.saml2.lib.bindings.SOAPHTTPBinding;
import com.sap.security.saml2.lib.callbacks.SAML2GetterCallbacksPAOSHeaders;
import com.sap.security.saml2.lib.callbacks.SAML2GetterCallbacksPAOSMessage;
import com.sap.security.saml2.lib.callbacks.SAML2SetterCallbacksPAOSMessage;
import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2NameID;
import com.sap.security.saml2.lib.interfaces.bindings.ECPResponseMessage;
import com.sap.security.saml2.lib.interfaces.bindings.SOAPHeaderECPRequest;
import com.sap.security.saml2.lib.interfaces.bindings.SOAPHeaderECPResponse;
import com.sap.security.saml2.lib.interfaces.bindings.SOAPHeaderPAOSRequest;
import com.sap.security.saml2.lib.interfaces.bindings.SOAPHeaderRelayState;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2AuthRequest;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2ProtocolToken;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2Response;
import com.sap.tc.logging.Location;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;

public class PAOSHTTPBinding {
    public static final String HTTP_ACCEPT_HEADER = "Accept";
    public static final String HTTP_PAOS_HEADER = "PAOS";
    public static final String PAOS_MIME_TYPE = "application/vnd.paos+xml";
    public static final String ECP_RESPONSE_MESSAGE = "ECP Response";
    private static final String PAOS_VERSION = "urn:liberty:paos:2003-08";
    private static final String PAOS_SERVICE_SSO_ECP = "urn:oasis:names:tc:SAML:2.0:profiles:SSO:ecp";
    private static final String PAOS_SOAP_HEADER_RELAY_STATE_NAME = "RelayState";
    private static final String PAOS_SOAP_HEADER_RELAY_STATE_NAMESPACE = "urn:oasis:names:tc:SAML:2.0:profiles:SSO:ecp";
    private static final Pattern PAOS_HEADER_PATTERN = Pattern.compile("ver=[\"'](.+)[\"'].*;\\s*[\"'](.+)[\"'].*");
    private static final Location LOCATION = Location.getLocation(PAOSHTTPBinding.class);

    public static boolean isUserAgentSupportECP(HttpServletRequest request) {
        String acceptHeader = request.getHeader(HTTP_ACCEPT_HEADER);
        String paosHeader = request.getHeader(HTTP_PAOS_HEADER);
        return PAOSHTTPBinding.isUserAgentSupportECP(acceptHeader, paosHeader);
    }

    public static boolean isUserAgentSupportECP(SAML2GetterCallbacksPAOSHeaders paosCallbacks) {
        if (paosCallbacks.isHandled()) {
            String acceptHeader = paosCallbacks.getAcceptHeaderValue();
            String paosHeader = paosCallbacks.getPAOSHeaderValue();
            return PAOSHTTPBinding.isUserAgentSupportECP(acceptHeader, paosHeader);
        }
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Received PAOS header callbacks are not handled");
        }
        return false;
    }

    public static boolean isPAOSMessage(HttpServletRequest request) {
        String contentType = request.getContentType();
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Content type of the received HTTP request is: " + contentType);
        }
        boolean isPAOSMessage = PAOS_MIME_TYPE.equals(contentType);
        return isPAOSMessage;
    }

    public static boolean isPAOSMessage(SAML2GetterCallbacksPAOSHeaders paosCallbacks) {
        if (paosCallbacks.isHandled()) {
            String contentType = paosCallbacks.getContentTypeHeaderValue();
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Content type of the received HTTP request is: " + contentType);
            }
            boolean isPAOSMessage = PAOS_MIME_TYPE.equals(contentType);
            return isPAOSMessage;
        }
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Received PAOS header callbacks are not handled");
        }
        return false;
    }

    public static void sendSAML2AuthnRequest(HttpServletResponse httpResponse, SOAPHeaderPAOSRequest paosRequest, SOAPHeaderECPRequest ecpRequest, String relayState, SAML2AuthRequest saml2Request) throws SAML2Exception {
        try {
            String soapEnvelope = PAOSHTTPBinding.createOutboundPAOSMessage(paosRequest, ecpRequest, relayState, saml2Request);
            httpResponse.setStatus(200);
            httpResponse.setContentType(PAOS_MIME_TYPE);
            httpResponse.setHeader("Cache-Control", "no-cache, no-store, must-revalidate, private");
            httpResponse.setHeader("Pragma", "no-cache");
            httpResponse.setContentLength(soapEnvelope.length());
            PrintWriter writer = httpResponse.getWriter();
            writer.write(soapEnvelope);
            writer.flush();
        }
        catch (Exception e) {
            throw new SAML2Exception("Failed to write SOAP envelope", e);
        }
    }

    public static SAML2SetterCallbacksPAOSMessage sendSAML2AuthnRequest(SOAPHeaderPAOSRequest paosRequest, SOAPHeaderECPRequest ecpRequest, String relayState, SAML2AuthRequest saml2Request) throws SAML2Exception {
        String soapEnvelope = PAOSHTTPBinding.createOutboundPAOSMessage(paosRequest, ecpRequest, relayState, saml2Request);
        SAML2SetterCallbacksPAOSMessage paosMessage = new SAML2SetterCallbacksPAOSMessage(soapEnvelope);
        return paosMessage;
    }

    public static void sendSAML2Response(HttpServletResponse httpResponse, SOAPHeaderECPResponse ecpResponse, String relayState, SAML2Response saml2Response) throws SAML2Exception {
        StringBuilder builder = new StringBuilder(500);
        builder.append(ecpResponse.generate());
        if (relayState != null && relayState.length() > 0) {
            SOAPHeaderRelayState soapHeaderRelayState = PAOSDataFactory.getInstance().createRelayState(relayState);
            builder.append("\n");
            builder.append(soapHeaderRelayState.generate());
        }
        String soapHeaderXML = builder.toString();
        String saml2ResponseXML = saml2Response.generate();
        try {
            String soapEnvelope = SOAPHTTPBinding.createSOAPEnvelope(saml2ResponseXML, soapHeaderXML);
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Created SOAP envelope: " + soapEnvelope);
            }
            httpResponse.setStatus(200);
            httpResponse.setContentType("text/xml");
            httpResponse.setHeader("Cache-Control", "no-cache, no-store, must-revalidate, private");
            httpResponse.setHeader("Pragma", "no-cache");
            httpResponse.setContentLength(soapEnvelope.length());
            PrintWriter writer = httpResponse.getWriter();
            writer.write(soapEnvelope);
        }
        catch (Exception e) {
            throw new SAML2Exception("Failed to write SOAP envelope", e);
        }
    }

    public static SAML2AuthRequest extractSAML2AuthnRequest(HttpServletRequest request) throws SAML2Exception {
        SAML2ProtocolToken samlToken;
        try {
            MimeHeaders mimeHeaders = SOAPHTTPBinding.extractMimeHeaders(request);
            ServletInputStream input = request.getInputStream();
            SOAPEnvelope envelope = SOAPHTTPBinding.extractSOAPEnvelope((InputStream)input, mimeHeaders);
            samlToken = SOAPHTTPBinding.extractSOAPBodyAsSAMLProtocolToken(envelope, false);
        }
        catch (Exception e) {
            throw new SAML2Exception("Could not extract SAML2 AuthnRequest", e);
        }
        if (samlToken instanceof SAML2AuthRequest) {
            return (SAML2AuthRequest)samlToken;
        }
        throw new SAML2Exception("Received invalid SAML2 AuthnRequest: " + samlToken);
    }

    public static ECPResponseMessage extractECPResponseMessage(HttpServletRequest request) throws SAML2Exception {
        ServletInputStream input;
        MimeHeaders mimeHeaders;
        try {
            mimeHeaders = SOAPHTTPBinding.extractMimeHeaders(request);
            input = request.getInputStream();
        }
        catch (Exception e) {
            throw new SAML2Exception("Could not extract PAOS message", e);
        }
        return PAOSHTTPBinding.extractECPResponseMessage((InputStream)input, mimeHeaders);
    }

    public static ECPResponseMessage extractECPResponseMessage(SAML2GetterCallbacksPAOSMessage paosCallbacks) throws SAML2Exception {
        InputStream input;
        if (!paosCallbacks.isHandled()) {
            throw new SAML2Exception("Received PAOS message callbacks are not handled");
        }
        MimeHeaders mimeHeaders = new MimeHeaders();
        try {
            input = paosCallbacks.getBodyInputStream();
        }
        catch (Exception e) {
            throw new SAML2Exception("Could not extract PAOS message", e);
        }
        return PAOSHTTPBinding.extractECPResponseMessage(input, mimeHeaders);
    }

    private static boolean isUserAgentSupportECP(String acceptHeader, String paosHeader) {
        Matcher matcher;
        if (acceptHeader == null || !acceptHeader.contains(PAOS_MIME_TYPE)) {
            if (LOCATION.beDebug()) {
                LOCATION.debugT("User agent does not support ECP because there isn't \"application/vnd.paos+xml\" in the HTTP request header: Accept=" + acceptHeader);
            }
            return false;
        }
        if (paosHeader == null) {
            if (LOCATION.beDebug()) {
                LOCATION.debugT("User agent does not support ECP because there isn't \"PAOS\" HTTP request header");
            }
            return false;
        }
        if (LOCATION.beDebug()) {
            LOCATION.debugT("PAOS HTTP header has value: " + paosHeader);
        }
        if (!(matcher = PAOS_HEADER_PATTERN.matcher(paosHeader)).matches()) {
            if (LOCATION.beDebug()) {
                LOCATION.debugT("PAOS HTTP header does not match SAML2 ECP profile pattern: \"" + PAOS_HEADER_PATTERN.pattern() + "\"");
            }
            return false;
        }
        String paosVersion = matcher.group(1);
        String paosService = matcher.group(2);
        if (!PAOS_VERSION.equals(paosVersion)) {
            if (LOCATION.beDebug()) {
                LOCATION.debugT("PAOS version is: {0} , the ECP profile require version to be: {1}", new Object[]{paosVersion, PAOS_VERSION});
            }
            return false;
        }
        if (!"urn:oasis:names:tc:SAML:2.0:profiles:SSO:ecp".equals(paosService)) {
            if (LOCATION.beDebug()) {
                LOCATION.debugT("PAOS service is: {0} , the ECP profile require service to be: {1}", new Object[]{paosService, "urn:oasis:names:tc:SAML:2.0:profiles:SSO:ecp"});
            }
            return false;
        }
        if (LOCATION.beDebug()) {
            LOCATION.debugT("User agent supports SAML2 ECP profile");
        }
        return true;
    }

    private static String createOutboundPAOSMessage(SOAPHeaderPAOSRequest paosRequest, SOAPHeaderECPRequest ecpRequest, String relayState, SAML2AuthRequest saml2Request) throws SAML2Exception {
        if (paosRequest == null) {
            throw new SAML2Exception("PAOSRequest cannot be null");
        }
        if (ecpRequest == null) {
            throw new SAML2Exception("ECPRequest cannot be null");
        }
        if (saml2Request == null) {
            throw new SAML2Exception("SAML2AuthnRequest cannot be null");
        }
        SAML2NameID issuer = saml2Request.getIssuer();
        ecpRequest.setIssuer(issuer);
        StringBuilder builder = new StringBuilder(500);
        builder.append(paosRequest.generate());
        builder.append("\n");
        builder.append(ecpRequest.generate());
        if (relayState != null && relayState.length() > 0) {
            SOAPHeaderRelayState soapHeaderRelayState = PAOSDataFactory.getInstance().createRelayState(relayState);
            builder.append("\n");
            builder.append(soapHeaderRelayState.generate());
        }
        String soapHeaderXML = builder.toString();
        String saml2RequestXML = saml2Request.generate();
        String soapEnvelope = SOAPHTTPBinding.createSOAPEnvelope(saml2RequestXML, soapHeaderXML);
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Created outbound PAOS message: " + soapEnvelope);
        }
        return soapEnvelope;
    }

    public static ECPResponseMessage extractECPResponseMessage(InputStream input, MimeHeaders mimeHeaders) throws SAML2Exception {
        SOAPEnvelope envelope;
        try {
            envelope = SOAPHTTPBinding.extractSOAPEnvelope(input, mimeHeaders);
        }
        catch (IOException e) {
            throw new SAML2Exception("Could not read the ECP response message", e);
        }
        SAML2ProtocolToken samlToken = SOAPHTTPBinding.extractSOAPBodyAsSAMLProtocolToken(envelope, false);
        if (samlToken instanceof SAML2Response) {
            String relayState = PAOSHTTPBinding.extractRelayState(envelope);
            ECPResponseMessageImpl result = new ECPResponseMessageImpl((SAML2Response)samlToken, relayState);
            return result;
        }
        throw new SAML2Exception("Received invalid SAML2 Response: " + samlToken);
    }

    private static String extractRelayState(SOAPEnvelope envelope) {
        String result;
        block4: {
            result = null;
            try {
                SOAPHeader soapHeader = envelope.getHeader();
                Iterator soapHeaderElements = soapHeader.extractAllHeaderElements();
                while (soapHeaderElements.hasNext()) {
                    SOAPHeaderElement elem = (SOAPHeaderElement)soapHeaderElements.next();
                    if (!PAOS_SOAP_HEADER_RELAY_STATE_NAME.equals(elem.getLocalName()) || !"urn:oasis:names:tc:SAML:2.0:profiles:SSO:ecp".equals(elem.getNamespaceURI())) continue;
                    result = elem.getValue();
                    if (LOCATION.beDebug()) {
                        LOCATION.debugT("Extracted relay state: " + result);
                    }
                    break;
                }
            }
            catch (Exception e) {
                if (!LOCATION.beDebug()) break block4;
                LOCATION.debugT("Could not extract RelayState header. Reason: " + e);
            }
        }
        return result;
    }

    private static class ECPResponseMessageImpl
    implements ECPResponseMessage {
        private String relayState;
        private SAML2Response saml2Response;

        public ECPResponseMessageImpl(SAML2Response response, String relayState) {
            this.saml2Response = response;
            this.relayState = relayState;
        }

        @Override
        public String getRelayState() {
            return this.relayState;
        }

        @Override
        public SAML2Response getSAML2Response() {
            return this.saml2Response;
        }
    }
}

