/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.lib.bindings;

import com.sap.engine.lib.xml.signature.crypto.CustomSignature;
import com.sap.engine.lib.xml.signature.crypto.Reusable;
import com.sap.security.saml2.lib.common.SAML2DataFactory;
import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.common.SAML2ProtocolFactory;
import com.sap.security.saml2.lib.common.SAML2Utils;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2Artifact;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2SignatureKeyInfo;
import com.sap.security.saml2.lib.interfaces.bindings.RedirectPayloadDeflate;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2ProtocolToken;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2RequestBase;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2ResponseBase;
import com.sap.security.saml2.lib.protocols.SAML2ProtocolTokenBase;
import com.sap.security.saml2.lib.xmlsecurity.CertificateVerifier;
import com.sap.security.saml2.lib.xmlsecurity.XMLSignatureDOM;
import com.sap.tc.logging.Location;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.Key;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class RedirectPayloadDeflateImpl
implements RedirectPayloadDeflate {
    private static final Location LOCATION = Location.getLocation(RedirectPayloadDeflateImpl.class);
    private static final String ENCODING = "UTF-8";
    static String SAML_REQUEST_PARAMETER = "SAMLRequest";
    static String SAML_ARTIFACT_PARAMETER = "SAMLart";
    static String SAML_RESPONSE_PARAMETER = "SAMLResponse";
    private static String SAML_RELAY_STATE_PARAMETER = "RelayState";
    private static String SIG_ALG_PARAMETER = "SigAlg";
    private static String SIGNATURE_PARAMETER = "Signature";
    private static final int MODE_CREATED = 8;
    private static final int MODE_PARSED = 16;
    private int mode;
    private Object samlPayload;
    private String relayState;
    private boolean isSigned = false;
    private StringBuffer queryString = new StringBuffer(600);
    private StringBuffer queryStringForSigVerifying = new StringBuffer(600);
    private String digestAlgorithm;
    private String signatureAlgorithm;
    private byte[] signature;

    public RedirectPayloadDeflateImpl(SAML2ProtocolToken samlPayload, String relayState) throws SAML2Exception {
        if (samlPayload == null) {
            throw new SAML2Exception("SAML2ProtocolToken argument cannot be null");
        }
        this.samlPayload = samlPayload;
        this.relayState = relayState;
        this.create(samlPayload, relayState);
    }

    public RedirectPayloadDeflateImpl(SAML2Artifact samlPayload, String relayState) throws SAML2Exception {
        if (samlPayload == null) {
            throw new SAML2Exception("SAML2Artifact argument cannot be null");
        }
        this.samlPayload = samlPayload;
        this.create(samlPayload, relayState);
    }

    public RedirectPayloadDeflateImpl(String queryString) throws SAML2Exception {
        if (queryString == null || queryString.length() < 1) {
            throw new SAML2Exception("Query string is empty - queryString: " + queryString);
        }
        this.parse(queryString);
    }

    private void create(SAML2ProtocolToken samlPayload, String relayState) throws SAML2Exception {
        try {
            String samlPayloadAsString = samlPayload.generate();
            if (samlPayload.isSigned()) {
                throw new SAML2Exception("The SAML protocol message for HTTP redirect binding with DEFLATE encoding must not be signed.");
            }
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Redirect payload will be constructed from:\n SAML2 message: {0}\n Relay State: {1}", new Object[]{samlPayloadAsString, relayState});
            }
            byte[] payloadBytes = samlPayloadAsString.getBytes(ENCODING);
            Deflater deflater = new Deflater(-1, true);
            deflater.setInput(payloadBytes);
            deflater.finish();
            byte[] buffer = new byte[payloadBytes.length];
            int count = deflater.deflate(buffer);
            byte[] compresedPayload = new byte[count];
            System.arraycopy(buffer, 0, compresedPayload, 0, count);
            String base64compresedPayload = SAML2Utils.encodeBase64(compresedPayload);
            base64compresedPayload = base64compresedPayload.replaceAll("\\s", "");
            String preparedPayload = URLEncoder.encode(base64compresedPayload, ENCODING);
            if (samlPayload instanceof SAML2RequestBase) {
                this.queryString.append(SAML_REQUEST_PARAMETER).append("=").append(preparedPayload);
            } else if (samlPayload instanceof SAML2ResponseBase) {
                this.queryString.append(SAML_RESPONSE_PARAMETER).append("=").append(preparedPayload);
            }
            if (relayState != null && relayState.length() > 0) {
                String preparedRelayState = URLEncoder.encode(relayState, ENCODING);
                this.queryString.append("&").append(SAML_RELAY_STATE_PARAMETER).append("=").append(preparedRelayState);
            }
        }
        catch (Exception e) {
            throw new SAML2Exception("Failed to prepare the query string for the Location URL", e);
        }
        this.mode = 8;
    }

    private void create(SAML2Artifact samlPayload, String relayState) throws SAML2Exception {
        try {
            String samlPayloadAsString = samlPayload.getValue();
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Redirect payload will be constructed from:\n SAML2 artifact: {0}\n Relay State: {1}", new Object[]{samlPayloadAsString, relayState});
            }
            samlPayloadAsString = samlPayloadAsString.replaceAll("\\s", "");
            String preparedPayload = URLEncoder.encode(samlPayloadAsString, ENCODING);
            this.queryString.append(SAML_ARTIFACT_PARAMETER).append("=").append(preparedPayload);
            if (relayState != null && relayState.length() > 0) {
                String preparedRelayState = URLEncoder.encode(relayState, ENCODING);
                this.queryString.append("&").append(SAML_RELAY_STATE_PARAMETER).append("=").append(preparedRelayState);
            }
        }
        catch (Exception e) {
            throw new SAML2Exception("Failed to prepare the query string for the Location URL", e);
        }
        this.mode = 8;
    }

    private void parse(String queryString) throws SAML2Exception {
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Redirect payload will be parsed from query string: {0}", new Object[]{queryString});
        }
        this.queryString.append(queryString);
        String samlValue = this.extractQueryParameterValue(queryString, SAML_REQUEST_PARAMETER);
        if (samlValue != null && samlValue.length() > 0) {
            this.queryStringForSigVerifying.append(SAML_REQUEST_PARAMETER).append("=").append(samlValue);
        } else {
            samlValue = this.extractQueryParameterValue(queryString, SAML_RESPONSE_PARAMETER);
            if (samlValue != null && samlValue.length() > 0) {
                this.queryStringForSigVerifying.append(SAML_RESPONSE_PARAMETER).append("=").append(samlValue);
            }
        }
        if (samlValue != null && samlValue.length() > 0) {
            String samlProtocolToken;
            try {
                String samlValueBase64encoded = URLDecoder.decode(samlValue, ENCODING);
                byte[] samlValueCompresed = SAML2Utils.decodeBase64(samlValueBase64encoded);
                Inflater inflater = new Inflater(true);
                inflater.setInput(samlValueCompresed);
                byte[] buffer = new byte[4092];
                int resultLength = inflater.inflate(buffer);
                inflater.end();
                samlProtocolToken = new String(buffer, 0, resultLength, ENCODING);
            }
            catch (Exception e) {
                throw new SAML2Exception("Failed to decode SAML payload", e);
            }
            this.samlPayload = this.createSAML2ProtocolToken(samlProtocolToken);
        } else {
            String samlArt = this.extractQueryParameterValue(queryString, SAML_ARTIFACT_PARAMETER);
            if (samlArt != null && samlArt.length() > 0) {
                String base64EncodedArtifact;
                this.queryStringForSigVerifying.append(SAML_ARTIFACT_PARAMETER).append("=").append(samlArt);
                try {
                    base64EncodedArtifact = URLDecoder.decode(samlArt, ENCODING);
                }
                catch (UnsupportedEncodingException e) {
                    throw new SAML2Exception("Failed to decode SAML artifact: " + samlArt, e);
                }
                this.samlPayload = SAML2DataFactory.getInstance().createSAML2Artifact(base64EncodedArtifact);
            } else {
                throw new SAML2Exception("There isn't any SAML payload (" + SAML_REQUEST_PARAMETER + " , " + SAML_RESPONSE_PARAMETER + " or " + SAML_ARTIFACT_PARAMETER + " parameter) " + "in the query string: " + queryString);
            }
        }
        String relayStateEncoded = this.extractQueryParameterValue(queryString, SAML_RELAY_STATE_PARAMETER);
        if (relayStateEncoded != null && relayStateEncoded.length() > 0) {
            this.queryStringForSigVerifying.append("&").append(SAML_RELAY_STATE_PARAMETER).append("=").append(relayStateEncoded);
            try {
                this.relayState = URLDecoder.decode(relayStateEncoded, ENCODING);
            }
            catch (Exception e) {
                throw new SAML2Exception("Failed to decode the relay state value", e);
            }
        }
        String sigAlgEncoded = this.extractQueryParameterValue(queryString, SIG_ALG_PARAMETER);
        String sigValue = this.extractQueryParameterValue(queryString, SIGNATURE_PARAMETER);
        if (sigValue != null && sigValue.length() > 0) {
            try {
                sigValue = URLDecoder.decode(sigValue, ENCODING);
                byte[] sigValueDecoded = SAML2Utils.decodeBase64(sigValue);
                this.signature = sigValueDecoded;
            }
            catch (Exception e) {
                throw new SAML2Exception("Failed to decode signature value", e);
            }
            if (sigAlgEncoded != null && sigAlgEncoded.length() > 0) {
                this.isSigned = true;
                this.queryStringForSigVerifying.append("&").append(SIG_ALG_PARAMETER).append("=").append(sigAlgEncoded);
                try {
                    this.signatureAlgorithm = URLDecoder.decode(sigAlgEncoded, ENCODING);
                    this.digestAlgorithm = XMLSignatureDOM.extractDigestAlgorithm(this.signatureAlgorithm);
                }
                catch (Exception e) {
                    throw new SAML2Exception("Failed to decode the signature algorithm", e);
                }
            }
        }
        if (this.samlPayload instanceof SAML2ProtocolTokenBase) {
            ((SAML2ProtocolTokenBase)this.samlPayload).setSignedOnBindingLevel(this.isSigned);
        }
        if (LOCATION.beDebug()) {
            if (this.isSigned) {
                LOCATION.debugT("Received redirect payload is signed.");
            } else {
                LOCATION.debugT("Received redirect payload is not signed!");
            }
        }
        this.mode = 16;
    }

    @Override
    public String getQueryString() {
        return this.queryString.toString();
    }

    @Override
    public String getRelayState() {
        return this.relayState;
    }

    @Override
    public Object getSAMLPayload() {
        return this.samlPayload;
    }

    @Override
    public boolean isSigned() {
        return this.isSigned;
    }

    @Override
    public void sign(PrivateKey key) throws SAML2Exception {
        if (this.mode != 8 || this.isSigned) {
            return;
        }
        if (key == null) {
            throw new SAML2Exception("Private key for signing cannot be null");
        }
        if (this.digestAlgorithm == null) {
            this.digestAlgorithm = "http://www.w3.org/2000/09/xmldsig#sha1";
        }
        String sigAlg = XMLSignatureDOM.extractSignatureAlgorithm(key, this.digestAlgorithm);
        try {
            String preparedSigAlg = URLEncoder.encode(sigAlg, ENCODING);
            this.queryString.append("&").append(SIG_ALG_PARAMETER).append("=").append(preparedSigAlg);
        }
        catch (UnsupportedEncodingException e) {
            throw new SAML2Exception("Failed to encode the signature algorithm", e);
        }
        byte[] signatureValue = this.calculateSignature(this.queryString.toString(), key, sigAlg);
        String base64EncodedSignatureValue = SAML2Utils.encodeBase64(signatureValue);
        base64EncodedSignatureValue = base64EncodedSignatureValue.replaceAll("\\s", "");
        try {
            String preparedSignatureValue = URLEncoder.encode(base64EncodedSignatureValue, ENCODING);
            this.queryString.append("&").append(SIGNATURE_PARAMETER).append("=").append(preparedSignatureValue);
        }
        catch (UnsupportedEncodingException e) {
            throw new SAML2Exception("Failed to encode the signature value", e);
        }
        this.isSigned = true;
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Redirect payload was signed.");
        }
    }

    @Override
    public void sign(PrivateKey key, Certificate cert) throws SAML2Exception {
        this.sign(key);
    }

    @Override
    public SAML2SignatureKeyInfo getSignatureKeyInfo() {
        return null;
    }

    @Override
    public void validateSignature(Certificate senderCert) throws SAML2Exception {
        if (this.mode != 16) {
            return;
        }
        if (!this.isSigned) {
            throw new SAML2Exception("This payload is not signed.");
        }
        if (senderCert == null) {
            throw new SAML2Exception("Certificate used to validate the signature cannot be null");
        }
        if (!this.verifySignature(this.queryStringForSigVerifying.toString(), senderCert, this.signatureAlgorithm, this.signature)) {
            if (LOCATION.beWarning()) {
                LOCATION.warningT("Redirect payload signature verification failed.");
            }
            throw new SAML2Exception("Signature not valid!");
        }
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Redirect payload signature verified successfuly.");
        }
    }

    private byte[] calculateSignature(String dataForSign, PrivateKey key, String signatureAlgorithmURI) throws SAML2Exception {
        Reusable reusable = null;
        try {
            byte[] signedValue;
            reusable = Reusable.getInstance((String)signatureAlgorithmURI);
            CustomSignature sig = (CustomSignature)reusable;
            sig.initSign((Key)key);
            sig.update(dataForSign.getBytes(ENCODING));
            byte[] byArray = signedValue = sig.sign();
            return byArray;
        }
        catch (Exception e) {
            throw new SAML2Exception("Failed to calculate " + signatureAlgorithmURI + " signature for: " + dataForSign, e);
        }
        finally {
            if (reusable != null) {
                reusable.release();
            }
        }
    }

    private boolean verifySignature(String dataForVerify, Certificate cert, String sigAlg, byte[] sigValue) throws SAML2Exception {
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Certificate used to validate the signature: " + cert);
        }
        CertificateVerifier.getInstance().verifyCertificate(cert);
        Reusable reusable = null;
        try {
            reusable = Reusable.getInstance((String)sigAlg);
            CustomSignature sig = (CustomSignature)reusable;
            byte[] toCheck = sigValue;
            sig.initVerify((Key)cert.getPublicKey());
            sig.update(dataForVerify.getBytes(ENCODING));
            boolean bl = sig.verify(toCheck);
            return bl;
        }
        catch (Exception e) {
            throw new SAML2Exception("Unable to validate signature", e);
        }
        finally {
            if (reusable != null) {
                reusable.release();
            }
        }
    }

    private String extractQueryParameterValue(String queryString, String parameterName) {
        String label = String.valueOf(parameterName) + "=";
        int index = queryString.indexOf(label);
        if (index < 0) {
            return null;
        }
        int beginIndex = index + label.length();
        int endIndex = queryString.indexOf("&", index);
        String result = endIndex < 0 ? queryString.substring(beginIndex) : queryString.substring(beginIndex, endIndex);
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Extracted parameter with name: {0} is: {1}", new Object[]{parameterName, result});
        }
        return result;
    }

    private SAML2ProtocolToken createSAML2ProtocolToken(String saml) throws SAML2Exception {
        int protocolType = SAML2Utils.resolveSAMLProtocolTokenType(saml);
        SAML2ProtocolToken token = null;
        switch (protocolType) {
            case 2: {
                token = SAML2ProtocolFactory.getInstance().createAuthnRequest(saml);
                break;
            }
            case 4: {
                token = SAML2ProtocolFactory.getInstance().createLogoutRequest(saml);
                break;
            }
            case 32: {
                token = SAML2ProtocolFactory.getInstance().createArtifactResolve(saml);
                break;
            }
            case 64: {
                token = SAML2ProtocolFactory.getInstance().createArtifactResponse(saml);
                break;
            }
            case 16: {
                token = SAML2ProtocolFactory.getInstance().createLogoutResponse(saml);
                break;
            }
            case 8: {
                token = SAML2ProtocolFactory.getInstance().createResponse(saml);
                break;
            }
            case 128: {
                token = SAML2ProtocolFactory.getInstance().createManageNameIDRequest(saml);
                break;
            }
            case 256: {
                token = SAML2ProtocolFactory.getInstance().createManageNameIDResponse(saml);
                break;
            }
            case 0: {
                throw new SAML2Exception("Received unknown SAML protocol type: " + saml);
            }
        }
        if (token != null) {
            token.parse();
        }
        return token;
    }

    @Override
    public void setDigestAlgorithm(String digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
    }
}

