/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.lib.bindings;

import com.sap.security.saml2.lib.common.SAML2Configuration;
import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.common.SAML2ProtocolFactory;
import com.sap.security.saml2.lib.common.SAML2Utils;
import com.sap.security.saml2.lib.common.exceptions.SAML2SOAPFaultException;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2ProtocolToken;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2RequestBase;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2ResponseBase;
import com.sap.tc.logging.Location;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SOAPHTTPBinding {
    public static final String HTTP_HEADER_CONTENT_TYPE = "Content-Type";
    public static final String HTTP_HEADER_CACHE_CONTROL = "Cache-Control";
    public static final String HTTP_HEADER_PRAGMA = "Pragma";
    public static final String HTTP_HEADER_VALUE_NO_CACHE = "no-cache";
    public static final String HTTP_HEADER_VALUE_NO_CACHE_NO_STORE = "no-cache, no-store";
    public static final String HTTP_HEADER_VALUE_NO_CACHE_NO_STORE_MUST_REVALIDATE_PRIVATE = "no-cache, no-store, must-revalidate, private";
    public static final String HTTP_HEADER_CONNECTION = "Connection";
    public static final String HTTP_HEADER_VALUE_KEEP_ALIVE = "Keep-Alive";
    public static final String SOAP_MIME_TYPE = "text/xml";
    public static final String SOAP_MIME_TYPE_WITH_CHARSET_PARAMETER = "text/xml; charset=utf-8";
    public static final String SOAP_CHARSET_PARAMETER = "utf-8";
    public static final String SOAP_FAULT_CODE_CLIENT = "Client";
    public static final String SOAP_FAULT_CODE_SERVER = "Server";
    private static final String SOAP_ACTION_HEADER = "SOAPAction";
    private static final String SOAP_ACTION_VALUE = "http://www.oasis-open.org/committees/security";
    private static final String LOCAL_NAME_ENVELOPE = "Envelope";
    private static final String LOCAL_NAME_BODY = "Body";
    private static final String LOCAL_NAME_FAULT = "Fault";
    private static final String LOCAL_NAME_FAULT_CODE = "faultcode";
    private static final String LOCAL_NAME_FAULT_STRING = "faultstring";
    private static final String NAMESPACE_SOAP_ENVELOPE = "http://schemas.xmlsoap.org/soap/envelope/";
    private static final String SOAP_ENVELOPE_BEGINING = "<soap-env:Envelope xmlns:soap-env=\"http://schemas.xmlsoap.org/soap/envelope/\">\n";
    private static final String SOAP_ENVELOPE_ENDING = "</soap-env:Envelope>";
    private static final String SOAP_HEADER_BEGINING = "<soap-env:Header>\n";
    private static final String SOAP_HEADER_ENDING = "\n</soap-env:Header>\n";
    private static final String SOAP_BODY_BEGINING = "<soap-env:Body>\n";
    private static final String SOAP_BODY_ENDING = "\n</soap-env:Body>\n";
    private static final String SOAP_FAULT_AND_FAULTCODE_BEGINING = "<soap-env:Fault><soap-env:faultcode>soap-env:";
    private static final String SOAP_FAULTCODE_ENDING_AND_FAULTSTRING_BEGINNING = "</soap-env:faultcode><soap-env:faultstring>";
    private static final String SOAP_FAULTSTRING_AND_FAULT_ENDING = "</soap-env:faultstring></soap-env:Fault>";
    private static final String ENCODING = "UTF-8";
    private static final Location LOCATION = Location.getLocation(SOAPHTTPBinding.class);

    public static SAML2RequestBase extractSAMLRequest(HttpServletRequest request) throws SAML2Exception {
        SAML2ProtocolToken samlToken;
        try {
            ServletInputStream input = request.getInputStream();
            samlToken = SOAPHTTPBinding.extractSAML2ProtocolToken((InputStream)input, false);
        }
        catch (Exception e) {
            throw new SAML2Exception("Failed to extract SAML request", e);
        }
        if (samlToken instanceof SAML2RequestBase) {
            return (SAML2RequestBase)samlToken;
        }
        throw new SAML2Exception("Received invalid request: " + samlToken);
    }

    public static SAML2ResponseBase sendSOAPRequest(HttpURLConnection connection, String samlRequest) throws SAML2SOAPFaultException, SAML2Exception {
        SAML2ProtocolToken samlToken;
        try {
            connection.setAllowUserInteraction(false);
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setDefaultUseCaches(false);
            connection.setRequestMethod("POST");
            connection.setRequestProperty(HTTP_HEADER_CONTENT_TYPE, SOAP_MIME_TYPE_WITH_CHARSET_PARAMETER);
            connection.setRequestProperty(SOAP_ACTION_HEADER, SOAP_ACTION_VALUE);
            connection.setRequestProperty(HTTP_HEADER_CONNECTION, HTTP_HEADER_VALUE_KEEP_ALIVE);
            connection.setConnectTimeout(SAML2Configuration.getInstance().getConnectTimeoutForBackChannelsInMillis());
            connection.setReadTimeout(SAML2Configuration.getInstance().getReadTimeoutForBackChannelsInMillis());
            String soapEnvelope = SOAPHTTPBinding.createSOAPEnvelope(samlRequest);
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Created SOAP envelope: " + soapEnvelope);
            }
            BufferedOutputStream out = new BufferedOutputStream(connection.getOutputStream());
            out.write(soapEnvelope.getBytes(ENCODING));
            out.flush();
            out.close();
        }
        catch (Exception e) {
            throw new SAML2Exception("Failed to send SOAP envelope", e);
        }
        InputStream input = null;
        try {
            try {
                input = connection.getInputStream();
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("Headers of the received HTTP response: {0}", new Object[]{connection.getHeaderFields()});
                }
                samlToken = SOAPHTTPBinding.extractSAML2ProtocolToken(input, true);
            }
            catch (IOException e) {
                String errorDetails = SOAPHTTPBinding.readErrorDetails(connection);
                throw new SAML2Exception("Could not read the SOAP message. Error details: " + errorDetails, e);
            }
            catch (SAML2SOAPFaultException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SAML2Exception("Could not handle the response as SOAP message", e);
            }
        }
        finally {
            SOAPHTTPBinding.closeInputStream(input);
        }
        if (samlToken instanceof SAML2ResponseBase) {
            return (SAML2ResponseBase)samlToken;
        }
        throw new SAML2Exception("Received invalid response: " + samlToken);
    }

    private static String readErrorDetails(HttpURLConnection connection) {
        ByteArrayOutputStream errorResponse;
        int responseCode;
        block10: {
            responseCode = -1;
            errorResponse = new ByteArrayOutputStream();
            InputStream errorStream = null;
            try {
                try {
                    responseCode = connection.getResponseCode();
                    errorStream = connection.getErrorStream();
                    if (errorStream != null) {
                        int ret = 0;
                        byte[] buf = new byte[1024];
                        while ((ret = errorStream.read(buf)) != -1) {
                            errorResponse.write(buf, 0, ret);
                        }
                    }
                }
                catch (IOException ex) {
                    if (LOCATION.beWarning()) {
                        LOCATION.traceThrowableT(400, "Could not read the http connection error stream", (Throwable)ex);
                    }
                    SOAPHTTPBinding.closeInputStream(errorStream);
                    break block10;
                }
            }
            catch (Throwable throwable) {
                SOAPHTTPBinding.closeInputStream(errorStream);
                throw throwable;
            }
            SOAPHTTPBinding.closeInputStream(errorStream);
        }
        StringBuilder result = new StringBuilder();
        result.append("response code: ").append(responseCode);
        result.append("; response: ");
        try {
            result.append(errorResponse.toString(ENCODING));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return result.toString();
    }

    private static void closeInputStream(InputStream input) {
        block3: {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (Exception e) {
                if (!LOCATION.beWarning()) break block3;
                LOCATION.traceThrowableT(400, "Could not close the response stream", (Throwable)e);
            }
        }
    }

    public static void writeSuccessfulSOAPResponse(HttpServletResponse httpResponse, String samlResponse) throws SAML2Exception {
        try {
            String soapEnvelope = SOAPHTTPBinding.createSOAPEnvelope(samlResponse);
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Created successful SOAP envelope: " + soapEnvelope);
            }
            httpResponse.setStatus(200);
            httpResponse.setContentType(SOAP_MIME_TYPE);
            httpResponse.setCharacterEncoding(SOAP_CHARSET_PARAMETER);
            httpResponse.setHeader(HTTP_HEADER_CACHE_CONTROL, HTTP_HEADER_VALUE_NO_CACHE_NO_STORE_MUST_REVALIDATE_PRIVATE);
            httpResponse.setHeader(HTTP_HEADER_PRAGMA, HTTP_HEADER_VALUE_NO_CACHE);
            httpResponse.setContentLength(soapEnvelope.length());
            PrintWriter writer = httpResponse.getWriter();
            writer.write(soapEnvelope);
        }
        catch (Exception e) {
            throw new SAML2Exception("Failed to write SOAP envelope", e);
        }
    }

    public static void writeFaultSOAPResponse(HttpServletResponse httpResponse, String faultCode, String faultDescription) throws SAML2Exception {
        try {
            StringBuilder builder = new StringBuilder(100);
            builder.append(SOAP_FAULT_AND_FAULTCODE_BEGINING);
            if (faultCode == null || faultCode.length() < 1) {
                faultCode = SOAP_FAULT_CODE_SERVER;
            }
            if (faultDescription == null || faultDescription.length() < 1) {
                faultDescription = "Unexcpected error";
            }
            builder.append(faultCode);
            builder.append(SOAP_FAULTCODE_ENDING_AND_FAULTSTRING_BEGINNING);
            builder.append(faultDescription);
            builder.append(SOAP_FAULTSTRING_AND_FAULT_ENDING);
            String fault = builder.toString();
            String soapEnvelope = SOAPHTTPBinding.createSOAPEnvelope(fault);
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Created fault SOAP envelope: " + soapEnvelope);
            }
            httpResponse.setStatus(500);
            httpResponse.setContentType(SOAP_MIME_TYPE);
            httpResponse.setCharacterEncoding(SOAP_CHARSET_PARAMETER);
            httpResponse.setHeader(HTTP_HEADER_CACHE_CONTROL, HTTP_HEADER_VALUE_NO_CACHE_NO_STORE_MUST_REVALIDATE_PRIVATE);
            httpResponse.setHeader(HTTP_HEADER_PRAGMA, HTTP_HEADER_VALUE_NO_CACHE);
            httpResponse.setContentLength(soapEnvelope.length());
            PrintWriter writer = httpResponse.getWriter();
            writer.write(soapEnvelope);
        }
        catch (Exception e) {
            throw new SAML2Exception("Failed to write SOAP fault envelope", e);
        }
    }

    private static SAML2ProtocolToken extractSAML2ProtocolToken(InputStream soapEnvelope, boolean checkForFault) throws SAML2Exception, IOException {
        Element fault;
        Document doc;
        Element rootElement;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int n = 0;
        int overallLength = 0;
        int maxContentLength = SAML2Configuration.getInstance().getMaxHTTPContentLength();
        byte[] buffer = new byte[1024];
        while ((n = soapEnvelope.read(buffer)) != -1) {
            out.write(buffer, 0, n);
            if ((overallLength += n) <= maxContentLength) continue;
            throw new SAML2Exception("The SOAP message lenght exceed the maximum allowed content length (" + maxContentLength + ")");
        }
        if (out.size() < 1) {
            LOCATION.warningT("Received empty message");
            throw new SAML2Exception("Received empty message instead of SOAP envelope");
        }
        String soapMessage = out.toString(ENCODING);
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Received message: " + soapMessage);
        }
        if (!LOCAL_NAME_ENVELOPE.equals((rootElement = (doc = SAML2Utils.transformXMLtoDOM(soapMessage)).getDocumentElement()).getLocalName()) || !NAMESPACE_SOAP_ENVELOPE.equals(rootElement.getNamespaceURI())) {
            throw new SAML2Exception("Received message is not SOAP envelope. Expected root element name: Envelopeand namespace: http://schemas.xmlsoap.org/soap/envelope/ but found element with name: " + rootElement.getLocalName() + " and namespace: " + rootElement.getNamespaceURI());
        }
        Element soapBody = SAML2Utils.getFirstChildElementByTagNameNS(rootElement, NAMESPACE_SOAP_ENVELOPE, LOCAL_NAME_BODY);
        if (soapBody == null) {
            throw new SAML2Exception("Received SOAP envelope does not have a \"Body\" element");
        }
        if (checkForFault && (fault = SAML2Utils.getFirstChildElementByTagNameNS(soapBody, NAMESPACE_SOAP_ENVELOPE, LOCAL_NAME_FAULT)) != null) {
            String faultCode = null;
            Element faultCodeElement = SAML2Utils.getFirstChildElementByTagNameNS(fault, NAMESPACE_SOAP_ENVELOPE, LOCAL_NAME_FAULT_CODE);
            if (faultCodeElement == null) {
                faultCodeElement = SAML2Utils.getFirstChildElementByTagName(fault, LOCAL_NAME_FAULT_CODE);
            }
            if (faultCodeElement != null) {
                faultCode = SAML2Utils.getElementValueAsChildText(faultCodeElement);
            }
            String faultString = null;
            Element faultStringElement = SAML2Utils.getFirstChildElementByTagNameNS(fault, NAMESPACE_SOAP_ENVELOPE, LOCAL_NAME_FAULT_STRING);
            if (faultStringElement == null) {
                faultStringElement = SAML2Utils.getFirstChildElementByTagName(fault, LOCAL_NAME_FAULT_STRING);
            }
            if (faultStringElement != null) {
                faultString = SAML2Utils.getElementValueAsChildText(faultStringElement);
            }
            if (LOCATION.beWarning()) {
                LOCATION.warningT("Received SOAP fault with faultcode: " + faultCode + "; faultstring: " + faultString + ";");
            }
            throw new SAML2SOAPFaultException("Received SOAP fault with faultcode: " + faultCode + "; faultstring: " + faultString);
        }
        NodeList bodyChildNodes = soapBody.getChildNodes();
        if (bodyChildNodes.getLength() < 1) {
            throw new SAML2Exception("Received SOAP envelope with empty \"Body\" element");
        }
        int i = 0;
        while (i < bodyChildNodes.getLength()) {
            SAML2ProtocolToken token;
            Node node = bodyChildNodes.item(i);
            if (node instanceof Element && (token = SOAPHTTPBinding.extractSAML2ProtocolToken((Element)node)) != null) {
                return token;
            }
            ++i;
        }
        throw new SAML2Exception("SAML2 protocol message was not found in the SOAP body");
    }

    static SAML2ProtocolToken extractSOAPBodyAsSAMLProtocolToken(SOAPEnvelope envelope, boolean checkForFault) throws SAML2Exception {
        SOAPFault fault;
        SOAPBody body;
        try {
            body = envelope.getBody();
        }
        catch (SOAPException e) {
            throw new SAML2Exception("Could not extract SOAP Body from the received SOAP envelope", e);
        }
        if (checkForFault && (fault = body.getFault()) != null) {
            String faultCode = fault.getFaultCode();
            String faultString = fault.getFaultString();
            String faultActor = fault.getFaultActor();
            if (LOCATION.beWarning()) {
                LOCATION.warningT("Received SOAP fault with faultcode: " + faultCode + "; faultstring: " + faultString + "; " + (faultActor != null ? faultActor : ""));
            }
            throw new SAML2SOAPFaultException("Received SOAP fault with faultcode: " + faultCode + "; faultstring: " + faultString);
        }
        Iterator soapBodyElements = body.getChildElements();
        while (soapBodyElements.hasNext()) {
            SAML2ProtocolToken token;
            Object obj = soapBodyElements.next();
            if (!(obj instanceof Element) || (token = SOAPHTTPBinding.extractSAML2ProtocolToken((Element)obj)) == null) continue;
            return token;
        }
        throw new SAML2Exception("SAML2 protocol message was not found in the SOAP body");
    }

    private static SAML2ProtocolToken extractSAML2ProtocolToken(Element element) throws SAML2Exception {
        SAML2ProtocolToken samlToken = null;
        try {
            String namespace = element.getNamespaceURI();
            if ("urn:oasis:names:tc:SAML:2.0:protocol".equals(namespace)) {
                String elementLocalName = element.getLocalName();
                if ("LogoutRequest".equals(elementLocalName)) {
                    LOCATION.debugT("Found SAML LogoutRequest element in the SOAP Envelope");
                    samlToken = SAML2ProtocolFactory.getInstance().createLogoutRequest(element);
                } else if ("LogoutResponse".equals(elementLocalName)) {
                    LOCATION.debugT("Found SAML LogoutResponse element in the SOAP Envelope");
                    samlToken = SAML2ProtocolFactory.getInstance().createLogoutResponse(element);
                } else if ("AuthnRequest".equals(elementLocalName)) {
                    LOCATION.debugT("Found SAML AuthnRequest element in the SOAP Envelope");
                    samlToken = SAML2ProtocolFactory.getInstance().createAuthnRequest(element);
                } else if ("Response".equals(elementLocalName)) {
                    LOCATION.debugT("Found SAML Response element in the SOAP Envelope");
                    samlToken = SAML2ProtocolFactory.getInstance().createResponse(element);
                } else if ("ArtifactResolve".equals(elementLocalName)) {
                    LOCATION.debugT("Found SAML ArtifactResolve element in the SOAP Envelope");
                    samlToken = SAML2ProtocolFactory.getInstance().createArtifactResolve(element);
                } else if ("ArtifactResponse".equals(elementLocalName)) {
                    LOCATION.debugT("Found SAML ArtifactResponse element in the SOAP Envelope");
                    samlToken = SAML2ProtocolFactory.getInstance().createArtifactResponse(element);
                } else if ("ManageNameIDRequest".equals(elementLocalName)) {
                    LOCATION.debugT("Found SAML ManageNameIDRequest element in the SOAP Envelope");
                    samlToken = SAML2ProtocolFactory.getInstance().createManageNameIDRequest(element);
                } else if ("ManageNameIDResponse".equals(elementLocalName)) {
                    LOCATION.debugT("Found SAML ManageNameIDResponse element in the SOAP Envelope");
                    samlToken = SAML2ProtocolFactory.getInstance().createManageNameIDResponse(element);
                }
            }
        }
        catch (Exception e) {
            throw new SAML2Exception("Failed to extract the SAML2 protocol message", e);
        }
        if (samlToken != null) {
            samlToken.parse();
        }
        return samlToken;
    }

    static SOAPEnvelope extractSOAPEnvelope(InputStream input, MimeHeaders mimeHeaders) throws IOException, SAML2Exception {
        SOAPEnvelope envelope;
        SOAPMessage message = null;
        String messageAsString = null;
        try {
            MessageFactory factory = MessageFactory.newInstance();
            message = factory.createMessage(mimeHeaders, input);
            if (LOCATION.beDebug()) {
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                message.writeTo((OutputStream)output);
                messageAsString = output.toString(ENCODING);
                if (messageAsString == null || messageAsString.length() < 1) {
                    LOCATION.warningT("Received empty message");
                } else {
                    LOCATION.debugT("Received message: " + messageAsString);
                }
            }
            SOAPPart soapPart = message.getSOAPPart();
            envelope = soapPart.getEnvelope();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            try {
                if (messageAsString == null && message != null) {
                    ByteArrayOutputStream output = new ByteArrayOutputStream();
                    message.writeTo((OutputStream)output);
                    messageAsString = output.toString(ENCODING);
                }
            }
            catch (Exception exception) {}
            throw new SAML2Exception("Failed to extract SOAP envelope from the message: \"" + messageAsString + "\"", e);
        }
        return envelope;
    }

    private static String createSOAPEnvelope(String soapBodyXML) {
        return SOAPHTTPBinding.createSOAPEnvelope(soapBodyXML, null);
    }

    static String createSOAPEnvelope(String soapBodyXML, String soapHeaderXML) {
        soapBodyXML = soapBodyXML.replaceAll("<\\?[xX][mM][lL].*\\?>", "");
        StringBuilder builder = new StringBuilder(1024);
        builder.append(SOAP_ENVELOPE_BEGINING);
        if (soapHeaderXML != null && soapHeaderXML.length() > 0) {
            builder.append(SOAP_HEADER_BEGINING);
            builder.append(soapHeaderXML);
            builder.append(SOAP_HEADER_ENDING);
        }
        builder.append(SOAP_BODY_BEGINING);
        builder.append(soapBodyXML);
        builder.append(SOAP_BODY_ENDING);
        builder.append(SOAP_ENVELOPE_ENDING);
        String soapEnvelope = builder.toString();
        return soapEnvelope;
    }

    static MimeHeaders extractMimeHeaders(HttpServletRequest request) {
        MimeHeaders mimeHeaders = new MimeHeaders();
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String values = request.getHeader(name);
            String[] valuesArray = values.split(",");
            int i = 0;
            while (i < valuesArray.length) {
                String value = valuesArray[i].trim();
                if (value.length() > 0) {
                    mimeHeaders.addHeader(name, value);
                    if (LOCATION.beDebug()) {
                        LOCATION.debugT("Added mime header with name: " + name + " and value: " + value);
                    }
                }
                ++i;
            }
        }
        return mimeHeaders;
    }

    private static MimeHeaders extractMimeHeaders(HttpURLConnection conn) {
        MimeHeaders mimeHeaders = new MimeHeaders();
        Map<String, List<String>> headers = conn.getHeaderFields();
        Set<String> headerKeys = headers.keySet();
        for (String key : headerKeys) {
            List<String> values;
            if (key == null || (values = headers.get(key)) == null) continue;
            for (String value : values) {
                if (value == null) continue;
                mimeHeaders.addHeader(key, value);
                if (!LOCATION.beDebug()) continue;
                LOCATION.debugT("Added mime header with name: " + key + " and value: " + value);
            }
        }
        return mimeHeaders;
    }
}

