/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.lib.callbacks;

import com.sap.engine.lib.security.http.HttpGetterCallback;
import com.sap.security.saml2.lib.common.SAML2DataFactory;
import com.sap.security.saml2.lib.common.SAML2ProtocolFactory;
import com.sap.security.saml2.lib.common.SAML2Utils;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2Artifact;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2Assertion;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2Response;
import com.sap.tc.logging.Location;

public class SAMLGetterCallback
extends HttpGetterCallback {
    private static final Location LOCATION = Location.getLocation((String)"com.sap.security.saml2.lib.callbacks.SAMLGetterCallback");
    public static final byte TYPE_SAML2ASSERTION = 100;

    public Object getValue() {
        switch (this.getType()) {
            case 3: {
                String[] parameters;
                Object object = super.getValue();
                if (object != null && object instanceof String[] && (parameters = (String[])object).length != 0) {
                    if (super.getName().equals("SAMLResponse") || super.getName().equals("ProxySAMLResponse")) {
                        try {
                            if (LOCATION.beDebug()) {
                                LOCATION.debugT("SAMLResponse: " + parameters[0]);
                            }
                            String xmlResponse = SAML2Utils.decodeBase64AsString(parameters[0]);
                            if (LOCATION.beDebug()) {
                                LOCATION.debugT("Decoded SAMLResponse: " + xmlResponse);
                            }
                            SAML2Response samlResponse = SAML2ProtocolFactory.getInstance().createResponse(xmlResponse);
                            samlResponse.parse();
                            return samlResponse;
                        }
                        catch (Exception e) {
                            throw new SecurityException(e);
                        }
                    }
                    if (super.getName().equals("SAMLart") || super.getName().equals("ProxySAMLart")) {
                        try {
                            String xmlArtifact = parameters[0];
                            if (LOCATION.beDebug()) {
                                LOCATION.debugT("SAMLart: " + xmlArtifact);
                            }
                            SAML2Artifact samlArtefact = SAML2DataFactory.getInstance().createSAML2Artifact(xmlArtifact);
                            return samlArtefact;
                        }
                        catch (Exception e) {
                            throw new SecurityException(e);
                        }
                    }
                    if (super.getName().equalsIgnoreCase("saml2redirect")) {
                        return parameters[0];
                    }
                }
                return object;
            }
            case 17: {
                break;
            }
            case 100: {
                Object object = super.getValue();
                if (object instanceof SAML2Assertion) {
                    return object;
                }
                return null;
            }
        }
        return super.getValue();
    }
}

