/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.lib.common;

import com.sap.security.saml2.lib.common.SAML2ServicesManager;
import com.sap.security.saml2.lib.common.exceptions.SAML2ServiceInstantiationException;
import com.sap.security.saml2.lib.interfaces.services.AppPropertiesChangeListener;
import com.sap.security.saml2.lib.interfaces.services.ApplicationPropertiesService;
import com.sap.tc.logging.Location;
import java.io.Serializable;
import java.util.Properties;

public final class SAML2Configuration {
    private static final String APP_PROPERTY_CERT_REVOCATION_PROFILE = "certRevocationProfile";
    private static final String APP_PROPERTY_CHECK_CERT_TIME_VALIDITY = "checkCertTimeValidity";
    private static final String APP_PROPERTY_CHECK_CERT_REVOC_STATUS = "checkCertRevocStatus";
    private static final String APP_PROPERTY_MAX_HTTP_CONTENT_LENGTH = "maxHTTPContentLength";
    private static final String APP_PROPERTY_CONNECT_TIMEOUT_FOR_BACKCHANNEL = "connectTimeoutForBackChannelsInMillis";
    private static final String APP_PROPERTY_READ_TIMEOUT_FOR_BACKCHANNEL = "readTimeoutForBackChannelsInMillis";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final Location LOCATION = Location.getLocation(SAML2Configuration.class);
    private String certRevocationProfile;
    private boolean checkCertTimeValidity;
    private boolean checkCertRevocStatus;
    private int maxHTTPContentLength;
    private int connectTimeoutForBackChannelsInMillis;
    private int readTimeoutForBackChannelsInMillis;
    private int transformerPoolSize;
    private int documentBuilderPoolSize;
    private ApplicationPropertiesService appPropertiesService;
    private static final SAML2Configuration INSTANCE = new SAML2Configuration();
    private final AppPropertiesChangeListener PROPERTY_CHANGED_LISTENER;

    private SAML2Configuration() {
        block3: {
            this.certRevocationProfile = "SAML 2.0";
            this.checkCertTimeValidity = true;
            this.checkCertRevocStatus = true;
            this.maxHTTPContentLength = 32768;
            this.connectTimeoutForBackChannelsInMillis = 30000;
            this.readTimeoutForBackChannelsInMillis = 300000;
            this.transformerPoolSize = 10;
            this.documentBuilderPoolSize = 10;
            this.PROPERTY_CHANGED_LISTENER = new PropertyChangedListener();
            try {
                this.appPropertiesService = SAML2ServicesManager.getInstance().getApplicationPropertiesServiceInstance();
            }
            catch (SAML2ServiceInstantiationException e) {
                if (!LOCATION.beWarning()) break block3;
                LOCATION.traceThrowableT(400, "Application properties service not available. Default SAML2 library configuration will be used", (Throwable)e);
            }
        }
        this.readApplicationProperties();
        if (this.appPropertiesService != null) {
            this.appPropertiesService.addApplicationPropertiesChangeListener(this.PROPERTY_CHANGED_LISTENER);
        }
    }

    public static final SAML2Configuration getInstance() {
        return INSTANCE;
    }

    public String getCertRevocationProfile() {
        return this.certRevocationProfile;
    }

    public boolean isCheckCertTimeValidity() {
        return this.checkCertTimeValidity;
    }

    public boolean isCheckCertRevocStatus() {
        return this.checkCertRevocStatus;
    }

    public int getMaxHTTPContentLength() {
        return this.maxHTTPContentLength;
    }

    public int getConnectTimeoutForBackChannelsInMillis() {
        return this.connectTimeoutForBackChannelsInMillis;
    }

    public int getReadTimeoutForBackChannelsInMillis() {
        return this.readTimeoutForBackChannelsInMillis;
    }

    public int getTransformerPoolSize() {
        return this.transformerPoolSize;
    }

    public int getDocumentBuilderPoolSize() {
        return this.documentBuilderPoolSize;
    }

    public void dispose() {
        if (this.appPropertiesService != null) {
            this.appPropertiesService.removeApplicationPropertiesChangeListener(this.PROPERTY_CHANGED_LISTENER);
        }
    }

    private void readApplicationProperties() {
        if (this.appPropertiesService != null) {
            Properties applicationProperties = this.appPropertiesService.getApplicationProperties();
            this.initializeSettings(applicationProperties);
        }
    }

    private void initializeSettings(Properties appProps) {
        if (appProps == null || appProps.isEmpty()) {
            LOCATION.debugT("No application properties configured.");
        } else {
            Integer readTimeoutValue;
            Integer connectTimeoutValue;
            Integer maxHttpLength;
            Boolean certRevStatus;
            Boolean certTimeValidity;
            String profile = this.readStringProperty(APP_PROPERTY_CERT_REVOCATION_PROFILE, appProps);
            if (profile != null) {
                this.certRevocationProfile = profile;
            }
            if ((certTimeValidity = this.readBooleanProperty(APP_PROPERTY_CHECK_CERT_TIME_VALIDITY, appProps)) != null) {
                this.checkCertTimeValidity = certTimeValidity;
            }
            if ((certRevStatus = this.readBooleanProperty(APP_PROPERTY_CHECK_CERT_REVOC_STATUS, appProps)) != null) {
                this.checkCertRevocStatus = certRevStatus;
            }
            if ((maxHttpLength = this.readIntegerProperty(APP_PROPERTY_MAX_HTTP_CONTENT_LENGTH, appProps)) != null) {
                this.maxHTTPContentLength = maxHttpLength;
            }
            if ((connectTimeoutValue = this.readIntegerProperty(APP_PROPERTY_CONNECT_TIMEOUT_FOR_BACKCHANNEL, appProps)) != null) {
                this.connectTimeoutForBackChannelsInMillis = connectTimeoutValue;
            }
            if ((readTimeoutValue = this.readIntegerProperty(APP_PROPERTY_READ_TIMEOUT_FOR_BACKCHANNEL, appProps)) != null) {
                this.readTimeoutForBackChannelsInMillis = readTimeoutValue;
            }
        }
    }

    private final String readStringProperty(String propertyName, Properties appProps) {
        String value = this.readProperty(propertyName, appProps);
        if (value != null && LOCATION.beDebug()) {
            LOCATION.debugT("Configuration property [{0}] overrided by application setting [{1}]. New value: [{2}]", new Object[]{propertyName, propertyName, value});
        }
        return value;
    }

    private final Boolean readBooleanProperty(String propertyName, Properties appProps) {
        String value = this.readProperty(propertyName, appProps);
        if (value != null) {
            if (TRUE.equalsIgnoreCase(value)) {
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("Configuration property [{0}] overrided by application setting [{1}]. New value: [{2}]", new Object[]{propertyName, propertyName, value});
                }
                return Boolean.TRUE;
            }
            if (FALSE.equalsIgnoreCase(value)) {
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("Configuration property [{0}] overrided by application setting [{1}]. New value: [{2}]", new Object[]{propertyName, propertyName, value});
                }
                return Boolean.FALSE;
            }
            if (LOCATION.beWarning()) {
                LOCATION.warningT("Incorrect value: [{0}] for application property: [{1}]. Only \"true\" or \"false\" is accepted.", new Object[]{value, propertyName});
            }
        }
        return null;
    }

    private final Integer readIntegerProperty(String propertyName, Properties appProps) {
        block6: {
            String value = this.readProperty(propertyName, appProps);
            if (value != null) {
                try {
                    Integer integerValue = Integer.valueOf(value);
                    if (integerValue > -1) {
                        if (LOCATION.beDebug()) {
                            LOCATION.debugT("Configuration property [{0}] overrided by application setting [{1}]. New value: [{2}]", new Object[]{propertyName, propertyName, integerValue});
                        }
                        return integerValue;
                    }
                    if (LOCATION.beWarning()) {
                        LOCATION.warningT("Incorrect value: [{0}] for application property: [{1}]. The value of this property could not be a negative number", new Object[]{value, propertyName});
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    if (!LOCATION.beWarning()) break block6;
                    LOCATION.warningT("Incorrect value: [{0}] for application property: [{1}]. The value of this property must be a number", new Object[]{value, propertyName});
                }
            }
        }
        return null;
    }

    private final String readProperty(String propertyName, Properties props) {
        String str;
        String result = null;
        Object value = props.get(propertyName);
        if (value instanceof String && (str = ((String)value).trim()).length() > 0) {
            result = str;
        }
        return result;
    }

    private class PropertyChangedListener
    implements AppPropertiesChangeListener,
    Serializable {
        private static final long serialVersionUID = 1L;

        private PropertyChangedListener() {
        }

        @Override
        public void applicationPropertiesChanged() {
            SAML2Configuration.this.readApplicationProperties();
        }
    }
}

