/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.lib.common;

import com.sap.security.saml2.lib.common.SAML2Base64;
import com.sap.tc.logging.Location;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;
import java.util.UUID;

public class SAML2IDGenerator {
    public static final String ID_PREFIX_IDP_SESSION = "S-IDP-";
    private static final Location LOC;
    private static Random RANDOM;

    static {
        new SAML2IDGenerator();
        LOC = Location.getLocation(SAML2IDGenerator.class);
        try {
            RANDOM = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            LOC.traceThrowableT(100, "Failed to retrieve a secure random generator. Falling back to a simple random number generator.", (Throwable)e);
            RANDOM = new SecureRandom();
        }
    }

    private SAML2IDGenerator() {
    }

    public static String generatePersistentNameID() {
        byte[] binaryID = new byte[20];
        RANDOM.nextBytes(binaryID);
        return "NID-P-" + SAML2Base64.encode(binaryID);
    }

    public static String generateTransientNameID() {
        byte[] binaryID = new byte[20];
        RANDOM.nextBytes(binaryID);
        return "NID-T-" + SAML2Base64.encode(binaryID);
    }

    public static String generateSPProvidedID() {
        byte[] binaryID = new byte[20];
        RANDOM.nextBytes(binaryID);
        return "NID-SP-P-" + SAML2Base64.encode(binaryID);
    }

    public static String generateSLORequestID() {
        return "REQ-SLO-" + SAML2IDGenerator.getUUID();
    }

    public static String generateSLOResponseID() {
        return "RES-SLO-" + SAML2IDGenerator.getUUID();
    }

    public static String generateMNIResponseID() {
        return "RES-MNI-" + SAML2IDGenerator.getUUID();
    }

    public static String generateMNIRequestID() {
        return "REQ-MNI-" + SAML2IDGenerator.getUUID();
    }

    public static String generateSSOResponseID() {
        return "RES-SSO-" + SAML2IDGenerator.getUUID();
    }

    public static String generateAssertionID() {
        return "A-" + SAML2IDGenerator.getUUID();
    }

    public static String generateIDPSessionID() {
        return ID_PREFIX_IDP_SESSION + SAML2IDGenerator.getUUID();
    }

    public static String generateSPSessionIndex() {
        return "S-SP-" + SAML2IDGenerator.getUUID();
    }

    public static String generateSLOProcessID() {
        return "P-SLO-" + SAML2IDGenerator.getUUID();
    }

    private static String getUUID() {
        return UUID.randomUUID().toString();
    }
}

