/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.lib.common;

import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.common.reusables.SAML2DocumentBuilderPool;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class SAML2JAXBUtils {
    private static JAXBContext metadataJC;
    private static JAXBContext protocolJC;
    private static JAXBContext assertionJC;
    private static JAXBContext paosecpJC;
    private static final ClassLoader loader;

    static {
        loader = SAML2JAXBUtils.class.getClassLoader();
    }

    public static Document marshalProtocolTokenToDOM(JAXBElement element) throws SAML2Exception {
        return SAML2JAXBUtils.marshalToDOM(SAML2JAXBUtils.getProtocolMarshaller(), element);
    }

    public static JAXBElement unmarshalProtocolTokenFromDOM(Element parent) throws SAML2Exception {
        return SAML2JAXBUtils.unmarshalFromDOM(SAML2JAXBUtils.getProtocolUnmarshaller(), parent);
    }

    public static String marshalProtocolTokenToText(JAXBElement element) throws SAML2Exception {
        return SAML2JAXBUtils.marshalToText(SAML2JAXBUtils.getProtocolMarshaller(), element);
    }

    public static JAXBElement unmarshalProtocolTokenFromXMLText(String xml) throws SAML2Exception {
        return SAML2JAXBUtils.unmarshalFromXMLText(SAML2JAXBUtils.getProtocolUnmarshaller(), xml);
    }

    public static Document marshalAssertionTokenToDOM(JAXBElement element) throws SAML2Exception {
        return SAML2JAXBUtils.marshalToDOM(SAML2JAXBUtils.getAssertionMarshaller(), element);
    }

    public static String marshalAssertionTokenToText(JAXBElement element) throws SAML2Exception {
        return SAML2JAXBUtils.marshalToText(SAML2JAXBUtils.getAssertionMarshaller(), element);
    }

    public static JAXBElement unmarshalAssertionTokenFromDOM(Element parent) throws SAML2Exception {
        return SAML2JAXBUtils.unmarshalFromDOM(SAML2JAXBUtils.getAssertionUnmarshaller(), parent);
    }

    public static JAXBElement unmarshalAssertionTokenFromText(String xml) throws SAML2Exception {
        return SAML2JAXBUtils.unmarshalFromXMLText(SAML2JAXBUtils.getAssertionUnmarshaller(), xml);
    }

    public static String marshalMetadataTokenToText(JAXBElement element) throws SAML2Exception {
        return SAML2JAXBUtils.marshalToText(SAML2JAXBUtils.getMetadataMarshaller(), element);
    }

    public static JAXBElement unmarshalMetadataTokenFromXMLText(String xml) throws SAML2Exception {
        return SAML2JAXBUtils.unmarshalFromXMLText(SAML2JAXBUtils.getMetadataUnmarshaller(), xml);
    }

    public static String marshalPAOSorECPTokenToText(JAXBElement element) throws SAML2Exception {
        return SAML2JAXBUtils.marshalToText(SAML2JAXBUtils.getPAOSMarshaller(), element);
    }

    private static Document marshalToDOM(Marshaller marshaller, JAXBElement element) throws SAML2Exception {
        Document doc;
        try {
            DocumentBuilder db = SAML2DocumentBuilderPool.getInstance().acquireDocumentBuilder();
            doc = db.newDocument();
            marshaller.marshal((Object)element, (Node)doc);
        }
        catch (Exception e) {
            throw new SAML2Exception("Failed to marshal JAXB element", e);
        }
        return doc;
    }

    private static JAXBElement unmarshalFromDOM(Unmarshaller unmarshaller, Element parent) throws SAML2Exception {
        try {
            return (JAXBElement)unmarshaller.unmarshal((Node)parent);
        }
        catch (Exception e) {
            throw new SAML2Exception("Failed to unmarshal DOM element", e);
        }
    }

    private static String marshalToText(Marshaller marshaller, JAXBElement element) throws SAML2Exception {
        try {
            StringWriter writer = new StringWriter(2000);
            marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
            marshaller.marshal((Object)element, (Writer)writer);
            return writer.toString();
        }
        catch (Exception e) {
            throw new SAML2Exception("Failed to marshal JAXB element", e);
        }
    }

    private static JAXBElement unmarshalFromXMLText(Unmarshaller unmarshaller, String xml) throws SAML2Exception {
        try {
            XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
            xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            xmlInputFactory.setProperty("javax.xml.stream.supportDTD", false);
            XMLStreamReader xmlReader = xmlInputFactory.createXMLStreamReader(new StringReader(xml));
            JAXBElement result = (JAXBElement)unmarshaller.unmarshal(xmlReader);
            return result;
        }
        catch (Exception e) {
            throw new SAML2Exception("Failed to unmarshal the string: " + xml, e);
        }
    }

    public static Marshaller getMetadataMarshaller() throws SAML2Exception {
        try {
            return SAML2JAXBUtils.getMetadataJC().createMarshaller();
        }
        catch (JAXBException e) {
            throw new SAML2Exception("Failed to create a Marshaller for the SAML metadata", e);
        }
    }

    public static Unmarshaller getMetadataUnmarshaller() throws SAML2Exception {
        try {
            return SAML2JAXBUtils.getMetadataJC().createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new SAML2Exception("Failed to create an Unmarshaller for the SAML metadata", e);
        }
    }

    public static Marshaller getProtocolMarshaller() throws SAML2Exception {
        try {
            return SAML2JAXBUtils.getProtocolJC().createMarshaller();
        }
        catch (JAXBException e) {
            throw new SAML2Exception("Failed to create a Marshaller for the SAML protocols", e);
        }
    }

    public static Unmarshaller getProtocolUnmarshaller() throws SAML2Exception {
        try {
            return SAML2JAXBUtils.getProtocolJC().createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new SAML2Exception("Failed to create an Unmarshaller for the SAML protocols", e);
        }
    }

    public static Marshaller getAssertionMarshaller() throws SAML2Exception {
        try {
            return SAML2JAXBUtils.getAssertionJC().createMarshaller();
        }
        catch (JAXBException e) {
            throw new SAML2Exception("Failed to create a Marshaller for the SAML assertions", e);
        }
    }

    public static Unmarshaller getAssertionUnmarshaller() throws SAML2Exception {
        try {
            return SAML2JAXBUtils.getAssertionJC().createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new SAML2Exception("Failed to create an Unmarshaller for the SAML assertions", e);
        }
    }

    public static Marshaller getPAOSMarshaller() throws SAML2Exception {
        try {
            return SAML2JAXBUtils.getPAOSecpJC().createMarshaller();
        }
        catch (JAXBException e) {
            throw new SAML2Exception("Failed to create a Marshaller for PAOS and ECP SOAP headers", e);
        }
    }

    private static synchronized JAXBContext getProtocolJC() throws SAML2Exception {
        if (protocolJC != null) {
            return protocolJC;
        }
        try {
            protocolJC = JAXBContext.newInstance((String)"com.sap.security.saml2.lib.jaxb.protocol", (ClassLoader)loader);
            return protocolJC;
        }
        catch (Exception e) {
            throw new SAML2Exception("Failed to obtain JAXBContext for the package com.sap.security.saml2.lib.jaxb.protocol", e);
        }
    }

    private static synchronized JAXBContext getMetadataJC() throws SAML2Exception {
        if (metadataJC != null) {
            return metadataJC;
        }
        try {
            metadataJC = JAXBContext.newInstance((String)"com.sap.security.saml2.lib.jaxb.metadata", (ClassLoader)loader);
            return metadataJC;
        }
        catch (JAXBException e) {
            throw new SAML2Exception("Failed to obtain JAXBContext for the package com.sap.security.saml2.lib.jaxb.metadata", e);
        }
    }

    private static synchronized JAXBContext getAssertionJC() throws SAML2Exception {
        if (assertionJC != null) {
            return assertionJC;
        }
        try {
            assertionJC = JAXBContext.newInstance((String)"com.sap.security.saml2.lib.jaxb.assertion", (ClassLoader)loader);
            return assertionJC;
        }
        catch (Exception e) {
            throw new SAML2Exception("Failed to obtain JAXBContext for the package com.sap.security.saml2.lib.jaxb.protocol", e);
        }
    }

    private static synchronized JAXBContext getPAOSecpJC() throws SAML2Exception {
        if (paosecpJC != null) {
            return paosecpJC;
        }
        try {
            paosecpJC = JAXBContext.newInstance((String)"com.sap.security.saml2.lib.jaxb.liberty.paos:com.sap.security.saml2.lib.jaxb.profiles.sso.ecp", (ClassLoader)loader);
            return paosecpJC;
        }
        catch (Exception e) {
            throw new SAML2Exception("Could not obtain JAXBContext for the packages: com.sap.security.saml2.lib.jaxb.liberty.paosand com.sap.security.saml2.lib.jaxb.profiles.sso.ecp", e);
        }
    }
}

