/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.lib.common;

import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.common.SAML2ServicesManagerBase;
import com.sap.security.saml2.lib.common.exceptions.SAML2ServiceInstantiationException;
import com.sap.security.saml2.lib.interfaces.services.ApplicationPropertiesService;
import com.sap.security.saml2.lib.interfaces.services.CDCReadingService;
import com.sap.security.saml2.lib.interfaces.services.CDCWritingService;
import com.sap.security.saml2.lib.interfaces.services.CertificateRevocationChecker;
import com.sap.security.saml2.lib.services.CDCReadingServiceImpl;
import com.sap.security.saml2.lib.services.CDCWritingServiceImpl;
import com.sap.tc.logging.Location;
import java.util.HashMap;
import java.util.Map;

public final class SAML2ServicesManager
extends SAML2ServicesManagerBase {
    private static final String CERTIFICATE_REVOCATION_NW_ADAPTER = "com.sap.security.saml2.lib.nwadapters.CertificateRevocationCheckerNWAdapter";
    private static final String CERTIFICATE_REVOCATION_LJS_ADAPTER = "com.sap.security.saml2.lib.ljsadapters.CertificateRevocationCheckerLJSAdapter";
    private static final String APPLICATION_PROPERTIES_NW_ADAPTER = "com.sap.security.saml2.lib.nwadapters.ApplicationPropertiesServiceNWAdapter";
    private static final String APPLICATION_PROPERTIES_LJS_ADAPTER = "com.sap.security.saml2.lib.ljsadapters.ApplicationPropertiesServiceLJSAdapter";
    private static final Location LOCATION = Location.getLocation(SAML2ServicesManager.class);
    private final Map<Class, Object> adapterInstances = new HashMap<Class, Object>();
    private static final SAML2ServicesManager INSTANCE = new SAML2ServicesManager();

    public static SAML2ServicesManager getInstance() {
        return INSTANCE;
    }

    private SAML2ServicesManager() {
    }

    @Override
    protected Object instantiateClass(String className) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return Class.forName(className).newInstance();
    }

    @Override
    protected Map<Class, Object> getAdapterInstances() {
        return this.adapterInstances;
    }

    public CDCReadingService createCDCReader() {
        return new CDCReadingServiceImpl();
    }

    public CDCWritingService createCDCWriter(String idpName) throws SAML2Exception {
        return new CDCWritingServiceImpl(idpName);
    }

    public CertificateRevocationChecker getCertificateRevocationCheckerInstance() throws SAML2ServiceInstantiationException {
        return this.instantiateService(CertificateRevocationChecker.class, CERTIFICATE_REVOCATION_NW_ADAPTER, CERTIFICATE_REVOCATION_LJS_ADAPTER);
    }

    public ApplicationPropertiesService getApplicationPropertiesServiceInstance() throws SAML2ServiceInstantiationException {
        return this.instantiateService(ApplicationPropertiesService.class, APPLICATION_PROPERTIES_NW_ADAPTER, APPLICATION_PROPERTIES_LJS_ADAPTER);
    }

    public void registerCertificateRevocationChecker(CertificateRevocationChecker adapterInstance) throws SAML2Exception {
        this.registerServiceAdapter(CertificateRevocationChecker.class, adapterInstance);
    }

    public void registerApplicationPropertiesService(ApplicationPropertiesService adapterInstance) throws SAML2Exception {
        this.registerServiceAdapter(ApplicationPropertiesService.class, adapterInstance);
    }

    public void unregisterCertificateRevocationChecker(CertificateRevocationChecker adapterInstance) {
        this.unregisterServiceAdapter(CertificateRevocationChecker.class, adapterInstance);
    }

    public void unregisterApplicationPropertiesService(ApplicationPropertiesService adapterInstance) {
        this.unregisterServiceAdapter(ApplicationPropertiesService.class, adapterInstance);
    }
}

