/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.lib.common;

import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.common.exceptions.SAML2ServiceInstantiationException;
import com.sap.tc.logging.Location;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public abstract class SAML2ServicesManagerBase {
    private static final Location LOCATION = Location.getLocation(SAML2ServicesManagerBase.class);
    private final Map<Class, Object> adapterInstances = new HashMap<Class, Object>();

    protected <T> T instantiateService(Class<T> serviceClass, String ... adapterClasses) throws SAML2ServiceInstantiationException {
        Class<T> clazz = serviceClass;
        synchronized (clazz) {
            if (this.getAdapterInstances().containsKey(serviceClass)) {
                return (T)this.getAdapterInstances().get(serviceClass);
            }
            String[] stringArray = adapterClasses;
            int n = adapterClasses.length;
            int n2 = 0;
            while (n2 < n) {
                String className = stringArray[n2];
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("Trying to instantiate service: {0} from addapter class: {1}", new Object[]{serviceClass, className});
                }
                try {
                    Object result = this.instantiateClass(className);
                    this.getAdapterInstances().put(serviceClass, result);
                    if (LOCATION.beDebug()) {
                        LOCATION.debugT("Successfully instantiated service: {0} from addapter class: {1}", new Object[]{serviceClass, className});
                    }
                    return (T)result;
                }
                catch (InstantiationException e) {
                    throw new SAML2ServiceInstantiationException("Instantiation of the service: " + serviceClass + " from addapter class: " + className + " failed.", e);
                }
                catch (IllegalAccessException e) {
                    throw new SAML2ServiceInstantiationException("Instantiation of the service: " + serviceClass + " from addapter class: " + className + " failed.", e);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (LOCATION.beDebug()) {
                        LOCATION.debugT("Could not instantiate service: {0} from adapter class: {1}, because the adapter class is not found.", new Object[]{serviceClass, className});
                    }
                    ++n2;
                }
            }
            throw new SAML2ServiceInstantiationException("Could not instantiate service: " + serviceClass + " from any of the known addapter classes: " + Arrays.asList(adapterClasses));
        }
    }

    protected abstract Object instantiateClass(String var1) throws InstantiationException, IllegalAccessException, ClassNotFoundException;

    protected Map<Class, Object> getAdapterInstances() {
        return this.adapterInstances;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized <T> void registerServiceAdapter(Class<T> serviceClass, T adapterInstance) throws SAML2Exception {
        if (adapterInstance == null) {
            throw new SAML2Exception("Instance of the registered adapter for service: " + serviceClass + " could not be null");
        }
        Class<T> clazz = serviceClass;
        synchronized (clazz) {
            if (LOCATION.beDebug()) {
                if (this.getAdapterInstances().containsKey(serviceClass)) {
                    LOCATION.debugT("The existing instantiation: {0} of service: {1} is going to be replaced with registered adapter instance: {2}", new Object[]{this.getAdapterInstances().get(serviceClass), serviceClass, adapterInstance});
                } else {
                    LOCATION.debugT("Register adapter instance: {0} for service: {1}", new Object[]{adapterInstance, serviceClass});
                }
            }
            this.getAdapterInstances().put(serviceClass, adapterInstance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized <T> void unregisterServiceAdapter(Class<T> serviceClass, T adapterInstance) {
        if (adapterInstance == null) {
            return;
        }
        Class<T> clazz = serviceClass;
        synchronized (clazz) {
            Object registeredAdapterInstance = this.getAdapterInstances().get(serviceClass);
            if (adapterInstance.equals(registeredAdapterInstance)) {
                this.getAdapterInstances().remove(serviceClass);
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("Unregister adapter instance: {0} for service: {1}", new Object[]{registeredAdapterInstance, serviceClass});
                }
            } else if (LOCATION.beDebug()) {
                LOCATION.debugT("Unregistration of the adapter instance: {0} of service: {1} is not performed, because it is not registered. Currently registered adapter instance: {2}", new Object[]{adapterInstance, serviceClass, registeredAdapterInstance});
            }
        }
    }
}

