/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.lib.common;

import com.sap.engine.lib.xml.parser.tokenizer.XMLTokenReader;
import com.sap.engine.lib.xml.parser.tokenizer.XMLTokenReaderFactory;
import com.sap.engine.lib.xml.util.BASE64Decoder;
import com.sap.engine.lib.xml.util.BASE64Encoder;
import com.sap.security.saml2.lib.attributes.AttributeValuePair;
import com.sap.security.saml2.lib.attributes.AttributeValues;
import com.sap.security.saml2.lib.common.SAML2Configuration;
import com.sap.security.saml2.lib.common.SAML2DataFactory;
import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.common.reusables.SAML2DocumentBuilderPool;
import com.sap.security.saml2.lib.common.reusables.SAML2TransformerPool;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2Assertion;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2Attribute;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2AttributeStatement;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2EncryptedAttribute;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2IDPEntry;
import com.sap.tc.logging.Location;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import java.util.UUID;
import javax.xml.bind.JAXBElement;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class SAML2Utils {
    public static final int SAML_TYPE_UNKNOWN = 0;
    public static final int SAML_TYPE_AUTHN_REQUEST = 2;
    public static final int SAML_TYPE_LOGOUT_REQUEST = 4;
    public static final int SAML_TYPE_RESPONSE = 8;
    public static final int SAML_TYPE_LOGOUT_RESPONSE = 16;
    public static final int SAML_TYPE_ARTIFACT_RESOLVE = 32;
    public static final int SAML_TYPE_ARTIFACT_RESPONSE = 64;
    public static final int SAML_TYPE_MANAGE_NAME_ID_REQUEST = 128;
    public static final int SAML_TYPE_MANAGE_NAME_ID_RESPONSE = 256;
    private static final TimeZone GMT_TIMEZONE = TimeZone.getTimeZone("GMT+00:00");
    private static final SecureRandom numberGenerator = new SecureRandom();
    private static final Location LOCATION = Location.getLocation(SAML2Utils.class);
    private static DatatypeFactory datatypeFactory;

    public static int resolveSAMLProtocolTokenType(String xml) {
        String elementName;
        block11: {
            XMLTokenReader xmlReader;
            block10: {
                block9: {
                    if (xml != null) {
                        xml = xml.trim();
                    }
                    if (xml == null || xml.length() < 1) {
                        return 0;
                    }
                    StringReader reader = new StringReader(xml);
                    xmlReader = XMLTokenReaderFactory.getInstance().createReader((Reader)reader);
                    try {
                        xmlReader.begin();
                        if (xmlReader.getState() != 6) break block9;
                        return 0;
                    }
                    catch (Exception e) {
                        LOCATION.debugT("Failed to resolve the SAML protocol token type. Reason: " + e.toString());
                        return 0;
                    }
                }
                if (xmlReader.getState() != 1) {
                    xmlReader.moveToNextElementStart();
                }
                if (xmlReader.getState() != 6) break block10;
                return 0;
            }
            String namespaceURI = xmlReader.getURI();
            elementName = xmlReader.getLocalName();
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Namespace URI of the root element is: " + namespaceURI);
                LOCATION.debugT("Local name of the root element is: " + elementName);
            }
            if ("urn:oasis:names:tc:SAML:2.0:protocol".equals(namespaceURI)) break block11;
            return 0;
        }
        return SAML2Utils.resolveTypeFromElementName(elementName);
    }

    public static int resolveSAMLProtocolTokenType(Element parent) {
        if (parent == null) {
            return 0;
        }
        String namespaceURI = parent.getNamespaceURI();
        String elementName = parent.getLocalName();
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Namespace URI of the given DOM element is: " + namespaceURI);
            LOCATION.debugT("Local name of the given DOM element is: " + elementName);
        }
        if (!"urn:oasis:names:tc:SAML:2.0:protocol".equals(namespaceURI)) {
            return 0;
        }
        return SAML2Utils.resolveTypeFromElementName(elementName);
    }

    public static int resolveSAMLProtocolTokenType(JAXBElement element) {
        if (element == null) {
            return 0;
        }
        QName qname = element.getName();
        String namespaceURI = qname.getNamespaceURI();
        String elementName = qname.getLocalPart();
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Namespace URI of the given JAXBElement element is: " + namespaceURI);
            LOCATION.debugT("Local name of the given JAXBElement element is: " + elementName);
        }
        if (!"urn:oasis:names:tc:SAML:2.0:protocol".equals(namespaceURI)) {
            return 0;
        }
        return SAML2Utils.resolveTypeFromElementName(elementName);
    }

    private static int resolveTypeFromElementName(String elementName) {
        if ("AuthnRequest".equals(elementName)) {
            return 2;
        }
        if ("LogoutRequest".equals(elementName)) {
            return 4;
        }
        if ("Response".equals(elementName)) {
            return 8;
        }
        if ("LogoutResponse".equals(elementName)) {
            return 16;
        }
        if ("ArtifactResolve".equals(elementName)) {
            return 32;
        }
        if ("ArtifactResponse".equals(elementName)) {
            return 64;
        }
        if ("ManageNameIDRequest".equals(elementName)) {
            return 128;
        }
        if ("ManageNameIDResponse".equals(elementName)) {
            return 256;
        }
        return 0;
    }

    public static String encodeBase64AsString(String value) throws SAML2Exception {
        String encValue;
        if (value == null) {
            return null;
        }
        try {
            encValue = SAML2Utils.encodeBase64(value.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new SAML2Exception("Unsupported encoding", e);
        }
        return encValue;
    }

    public static String decodeBase64AsString(String value) throws SAML2Exception {
        String decValue;
        if (value == null) {
            return null;
        }
        try {
            decValue = new String(SAML2Utils.decodeBase64(value), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new SAML2Exception("Unsupported encoding", e);
        }
        return decValue;
    }

    public static String encodeBase64(byte[] bytes) throws SAML2Exception {
        String encValue;
        if (bytes == null) {
            return null;
        }
        try {
            encValue = new String(BASE64Encoder.encodeN((byte[])bytes), "UTF-8");
        }
        catch (Exception e) {
            throw new SAML2Exception("Failed to Base64 encode given value: " + new String(bytes, Charset.forName("UTF-8")), e);
        }
        return encValue;
    }

    public static byte[] decodeBase64(String value) throws SAML2Exception {
        byte[] result;
        if (value == null) {
            return null;
        }
        try {
            result = BASE64Decoder.decode((byte[])value.getBytes("UTF-8"));
        }
        catch (Exception e) {
            throw new SAML2Exception("Failed to Base64 decode the given value: " + value, e);
        }
        return result;
    }

    public static String generateUUID() {
        return "S" + UUID.randomUUID().toString();
    }

    public static byte[] generateUUID(int length) {
        byte[] result = new byte[length];
        numberGenerator.nextBytes(result);
        return result;
    }

    public static void transformDOMtoXML(Node root, StreamResult result, boolean omitXMLDeclaration, boolean addIndent) throws SAML2Exception {
        Transformer transformer = null;
        try {
            try {
                transformer = SAML2TransformerPool.getInstance().acquireTransformer();
                if (omitXMLDeclaration) {
                    transformer.setOutputProperty("omit-xml-declaration", "yes");
                } else {
                    transformer.setOutputProperty("omit-xml-declaration", "no");
                }
                if (addIndent) {
                    transformer.setOutputProperty("indent", "yes");
                } else {
                    transformer.setOutputProperty("indent", "no");
                }
                DOMSource source = new DOMSource(root);
                transformer.transform(source, result);
            }
            catch (Exception e) {
                throw new SAML2Exception("Failed to transform DOM tree to XML", e);
            }
        }
        finally {
            SAML2TransformerPool.getInstance().releaseTransformer(transformer);
        }
    }

    public static String transformDOMtoXML(Node root) throws SAML2Exception {
        StringWriter writer = new StringWriter(2000);
        SAML2Utils.transformDOMtoXML(root, new StreamResult(writer), true, false);
        return writer.toString();
    }

    public static Document transformXMLtoDOM(String xml) throws SAML2Exception {
        DocumentBuilder builder = null;
        try {
            Document document;
            builder = SAML2DocumentBuilderPool.getInstance().acquireDocumentBuilder();
            InputSource source = new InputSource(new StringReader(xml));
            Document document2 = document = builder.parse(source);
            return document2;
        }
        catch (Exception e) {
            throw new SAML2Exception("Failed to transform XML to DOM tree", e);
        }
        finally {
            SAML2DocumentBuilderPool.getInstance().releaseDocumentBuilder(builder);
        }
    }

    public static String transformDOMForTrace(Node node) {
        String resultAsString = "" + node;
        try {
            StringWriter writer = new StringWriter(2000);
            SAML2Utils.transformDOMtoXML(node, new StreamResult(writer), true, true);
            resultAsString = writer.toString();
        }
        catch (Throwable throwable) {}
        return resultAsString;
    }

    public static String byteArrayToHEXString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder(64);
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                builder.append('0');
            }
            builder.append(hex);
            ++n2;
        }
        return builder.toString();
    }

    public static byte[] calculateSha1Hash(String value) throws SAML2Exception {
        byte[] result;
        byte[] bytes;
        try {
            bytes = value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException err) {
            throw new SAML2Exception("Could not calculate SHA-1 hash from value: " + value, err);
        }
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            result = md.digest(bytes);
        }
        catch (NoSuchAlgorithmException e) {
            if (LOCATION.beError()) {
                LOCATION.traceThrowableT(500, "Could not calculate SHA-1 hash from value: {0}, because \"SHA-1\" algorithm is not available", new Object[]{value}, (Throwable)e);
            }
            throw new SAML2Exception("Could not calculate SHA-1 hash from value: " + value + ", because \"SHA-1\" algorithm is not available", e);
        }
        if (LOCATION.beDebug()) {
            LOCATION.debugT("SHA-1 hash of value: {0} is: {1}", new Object[]{value, SAML2Utils.byteArrayToHEXString(result)});
        }
        return result;
    }

    public static void checkRequestContentLengthHeader(int requestContentLength) throws SAML2Exception {
        int maxContentLength = SAML2Configuration.getInstance().getMaxHTTPContentLength();
        if (requestContentLength > maxContentLength) {
            throw new SAML2Exception("The request content lenght (" + requestContentLength + ") exceed the max allowed content length (" + maxContentLength + ")");
        }
    }

    public static void checkRequestParameterLength(String parameter) throws SAML2Exception {
        int maxContentLength;
        int actualContentLength;
        if (parameter != null && (actualContentLength = parameter.length()) > (maxContentLength = SAML2Configuration.getInstance().getMaxHTTPContentLength())) {
            throw new SAML2Exception("The request parameter lenght (" + actualContentLength + ") exceed the max allowed content length (" + maxContentLength + ")");
        }
    }

    public static XMLGregorianCalendar currentXMLGregorianCalendar() throws SAML2Exception {
        XMLGregorianCalendar xmlCal;
        GregorianCalendar cal = new GregorianCalendar(GMT_TIMEZONE);
        try {
            xmlCal = SAML2Utils.getDatatypeFactory().newXMLGregorianCalendar(cal);
        }
        catch (DatatypeConfigurationException e) {
            throw new SAML2Exception("Failed to obtain the current time as an XMLGregorianCalendar", e);
        }
        return xmlCal;
    }

    public static XMLGregorianCalendar convertDateToXMLGregorianCalendar(Date date) throws SAML2Exception {
        XMLGregorianCalendar xmlCal;
        if (date == null) {
            return null;
        }
        GregorianCalendar cal = new GregorianCalendar(GMT_TIMEZONE);
        cal.setTime(date);
        try {
            xmlCal = SAML2Utils.getDatatypeFactory().newXMLGregorianCalendar(cal);
        }
        catch (DatatypeConfigurationException e) {
            throw new SAML2Exception("Failed to convert the XMLGregorianCalendar", e);
        }
        return xmlCal;
    }

    private static synchronized DatatypeFactory getDatatypeFactory() throws DatatypeConfigurationException {
        if (datatypeFactory == null) {
            datatypeFactory = DatatypeFactory.newInstance();
        }
        return datatypeFactory;
    }

    public static Date convertXMLGregorianCalendarToDate(XMLGregorianCalendar calendar) {
        if (calendar == null) {
            return null;
        }
        Date result = calendar.toGregorianCalendar(GMT_TIMEZONE, null, null).getTime();
        return result;
    }

    public static boolean isIPAddress(String dnNameOrIPAddress) {
        return SAML2Utils.isIPv4Address(dnNameOrIPAddress) || SAML2Utils.isIPv6Address(dnNameOrIPAddress);
    }

    public static boolean isIPv4Address(String dnNameOrIPAddress) {
        boolean isIP = false;
        if (dnNameOrIPAddress != null) {
            isIP = true;
            int i = dnNameOrIPAddress.lastIndexOf(46) + 1;
            while (i < dnNameOrIPAddress.length()) {
                if ("1234567890".indexOf(dnNameOrIPAddress.charAt(i)) == -1) {
                    isIP = false;
                    break;
                }
                ++i;
            }
        }
        return isIP;
    }

    public static boolean isIPv6Address(String dnNameOrIPAddress) {
        boolean isIP = false;
        if (dnNameOrIPAddress != null) {
            isIP = dnNameOrIPAddress.indexOf(58) != -1;
        }
        return isIP;
    }

    public static Element getFirstChildElementByTagName(Element parent, String localName) {
        NodeList nodeList;
        if (parent != null && (nodeList = parent.getElementsByTagName(localName)).getLength() > 0) {
            return (Element)nodeList.item(0);
        }
        return null;
    }

    public static Element getFirstChildElementByTagNameNS(Element parent, String namespace, String localName) {
        NodeList nodeList;
        if (parent != null && (nodeList = parent.getElementsByTagNameNS(namespace, localName)).getLength() > 0) {
            return (Element)nodeList.item(0);
        }
        return null;
    }

    public static String getElementValueAsChildText(Element parent) {
        Node child;
        if (parent != null && (child = parent.getFirstChild()) instanceof Text) {
            return ((Text)child).getWholeText();
        }
        return null;
    }

    public static List<SAML2IDPEntry> convertIdPNamesToIdPEntries(List<String> idpNames) {
        if (idpNames == null) {
            return null;
        }
        ArrayList<SAML2IDPEntry> result = new ArrayList<SAML2IDPEntry>(idpNames.size());
        for (String idpName : idpNames) {
            try {
                SAML2IDPEntry idpEntry = SAML2DataFactory.getInstance().createSAML2IDPEntry(idpName);
                result.add(idpEntry);
            }
            catch (SAML2Exception e) {
                if (!LOCATION.beWarning()) continue;
                LOCATION.warningT("IdP with name: [{0}] could not be added to the SAML2 IDP Entry list. Reason: {1}", new Object[]{idpName, e.getMessage()});
            }
        }
        return result;
    }

    public static List<String> convertIdPEntriesToIdPNames(List<SAML2IDPEntry> idpEntries) {
        if (idpEntries == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>(idpEntries.size());
        for (SAML2IDPEntry idpEntry : idpEntries) {
            String idpName = idpEntry.getProviderID();
            if (idpName == null || idpName.length() <= 0) continue;
            result.add(idpName);
        }
        return result;
    }

    public static AttributeValues extractAttributeValues(SAML2Assertion assertion, PrivateKey recipientPrivateKey) throws SAML2Exception {
        if (assertion == null) {
            return null;
        }
        AttributeValues result = new AttributeValues();
        List<SAML2AttributeStatement> statements = assertion.getAttributeStatements();
        if (statements != null) {
            for (SAML2AttributeStatement attrStatement : statements) {
                List<SAML2EncryptedAttribute> encAttributes;
                List<SAML2Attribute> attributes = attrStatement.getAttributes();
                if (attributes != null) {
                    for (SAML2Attribute attribute : attributes) {
                        SAML2Utils.updateAttributeValues(result, attribute, false);
                    }
                }
                if ((encAttributes = attrStatement.getEncryptedAttributes()) == null || encAttributes.size() <= 0) continue;
                if (recipientPrivateKey == null) {
                    throw new SAML2Exception("There is no private key to decrypt encrypted attribute.");
                }
                for (SAML2EncryptedAttribute encryptedAttribute : encAttributes) {
                    SAML2Attribute attribute = encryptedAttribute.decrypt(recipientPrivateKey);
                    SAML2Utils.updateAttributeValues(result, attribute, true);
                }
            }
        }
        return result;
    }

    public static final void updateAttributeValues(AttributeValues result, SAML2Attribute attribute, boolean isEncrypted) throws SAML2Exception {
        String attributeName = attribute.getName();
        List<Object> attributeValues = attribute.getAttributeValues();
        AttributeValuePair pair = result.get(attributeName);
        if (pair != null) {
            if (attributeValues != null && attributeValues.size() > 0) {
                pair.addValues(attributeValues);
            }
        } else {
            pair = new AttributeValuePair(attributeName, attributeValues, attribute.getNameFormat(), isEncrypted);
            result.put(pair);
        }
    }
}

