/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.lib.common.reusables;

import com.sap.security.saml2.lib.common.SAML2Configuration;
import com.sap.security.saml2.lib.common.reusables.SAML2ReusablePool;
import com.sap.tc.logging.Location;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SAML2DocumentBuilderPool
extends SAML2ReusablePool<DocumentBuilder> {
    private static final Location LOCATION = Location.getLocation(SAML2DocumentBuilderPool.class);
    private static final SAML2DocumentBuilderPool instance = new SAML2DocumentBuilderPool();
    private static DocumentBuilderFactory documentBuilderFactory;

    private SAML2DocumentBuilderPool() {
        super(SAML2Configuration.getInstance().getDocumentBuilderPoolSize());
    }

    public static SAML2DocumentBuilderPool getInstance() {
        return instance;
    }

    public DocumentBuilder acquireDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilder result = (DocumentBuilder)this.acquireReusable();
        if (result == null) {
            result = this.getDocumentBuilderFactory().newDocumentBuilder();
            result.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException exception) throws SAXException {
                    LOCATION.traceThrowableT(100, "Warning during parsing of XML message", (Throwable)exception);
                }

                @Override
                public void fatalError(SAXParseException exception) throws SAXException {
                    LOCATION.traceThrowableT(100, "Fatal error during parsing of XML message", (Throwable)exception);
                    throw exception;
                }

                @Override
                public void error(SAXParseException exception) throws SAXException {
                    LOCATION.traceThrowableT(100, "Error during parsing of XML message", (Throwable)exception);
                }
            });
        }
        return result;
    }

    public boolean releaseDocumentBuilder(DocumentBuilder documentBuilder) {
        if (documentBuilder != null) {
            try {
                documentBuilder.reset();
            }
            catch (Exception e) {
                if (LOCATION.beDebug()) {
                    LOCATION.traceThrowableT(100, "Could not reset DocumentBuilder. It will not be returned to the reusable pool.", (Throwable)e);
                }
                return false;
            }
            boolean result = this.releaseReusable(documentBuilder);
            return result;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DocumentBuilderFactory getDocumentBuilderFactory() {
        if (documentBuilderFactory == null) {
            SAML2DocumentBuilderPool sAML2DocumentBuilderPool = this;
            synchronized (sAML2DocumentBuilderPool) {
                if (documentBuilderFactory == null) {
                    documentBuilderFactory = DocumentBuilderFactory.newInstance();
                    documentBuilderFactory.setNamespaceAware(true);
                    try {
                        documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                    }
                    catch (ParserConfigurationException e1) {
                        LOCATION.traceThrowableT(500, "DocumentBuilderFactory feature 'http://javax.xml.XMLConstants/feature/secure-processing' is not supported.", (Throwable)e1);
                    }
                    try {
                        documentBuilderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
                    }
                    catch (ParserConfigurationException e) {
                        LOCATION.traceThrowableT(500, "DocumentBuilderFactory feature 'http://xml.org/sax/features/external-general-entities' is not supported.", (Throwable)e);
                    }
                    try {
                        documentBuilderFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                    }
                    catch (ParserConfigurationException e) {
                        LOCATION.traceThrowableT(500, "DocumentBuilderFactory feature 'http://xml.org/sax/features/external-parameter-entities' is not supported.", (Throwable)e);
                    }
                    try {
                        documentBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                    }
                    catch (ParserConfigurationException e) {
                        LOCATION.traceThrowableT(500, "DocumentBuilderFactory feature 'http://apache.org/xml/features/disallow-doctype-decl' is not supported.", (Throwable)e);
                    }
                }
            }
        }
        return documentBuilderFactory;
    }
}

