/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.lib.common.reusables;

import com.sap.security.saml2.lib.common.SAML2Configuration;
import com.sap.security.saml2.lib.common.reusables.SAML2ReusablePool;
import com.sap.tc.logging.Location;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;

public class SAML2TransformerPool
extends SAML2ReusablePool<Transformer> {
    private static final Location LOCATION = Location.getLocation(SAML2TransformerPool.class);
    private static final SAML2TransformerPool instance = new SAML2TransformerPool();
    private static TransformerFactory transformerFactory;

    private SAML2TransformerPool() {
        super(SAML2Configuration.getInstance().getTransformerPoolSize());
    }

    public static SAML2TransformerPool getInstance() {
        return instance;
    }

    public Transformer acquireTransformer() throws TransformerConfigurationException {
        Transformer result = (Transformer)this.acquireReusable();
        if (result == null) {
            result = this.getTransformerFactory().newTransformer();
        }
        return result;
    }

    public boolean releaseTransformer(Transformer transformer) {
        if (transformer != null) {
            try {
                transformer.reset();
            }
            catch (Exception e) {
                if (LOCATION.beDebug()) {
                    LOCATION.traceThrowableT(100, "Could not reset Transformer. It will not be returned to the reusable pool.", (Throwable)e);
                }
                return false;
            }
            boolean result = this.releaseReusable(transformer);
            return result;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransformerFactory getTransformerFactory() {
        if (transformerFactory == null) {
            SAML2TransformerPool sAML2TransformerPool = this;
            synchronized (sAML2TransformerPool) {
                if (transformerFactory == null) {
                    transformerFactory = TransformerFactory.newInstance();
                }
            }
        }
        return transformerFactory;
    }
}

