/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.lib.extensions;

import com.sap.security.saml2.lib.extensions.SAML2ExtensionSupplierWithType;
import com.sap.security.saml2.lib.extensions.SAML2MessageType;
import com.sap.security.saml2.lib.interfaces.extensions.SAML2ExtensionSupplier;
import com.sap.security.saml2.lib.interfaces.extensions.read.SAML2ExtensionSupplierDescriptor;
import com.sap.tc.logging.Location;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SAML2ExtensionService {
    private Map<SAML2MessageType, Map<String, SAML2ExtensionSupplier>> registeredSuppliers = new HashMap<SAML2MessageType, Map<String, SAML2ExtensionSupplier>>();
    private static SAML2ExtensionService instance;
    private static final Location LOCATION;

    static {
        LOCATION = Location.getLocation(SAML2ExtensionService.class);
    }

    public synchronized void registerExtensionSupplier(SAML2ExtensionSupplier supplier, SAML2MessageType type) {
        Map<String, SAML2ExtensionSupplier> suppliersForType = this.registeredSuppliers.get((Object)type);
        if (suppliersForType == null) {
            suppliersForType = new HashMap<String, SAML2ExtensionSupplier>();
            this.registeredSuppliers.put(type, suppliersForType);
        }
        SAML2ExtensionSupplier oldSupplier = suppliersForType.put(supplier.getName(), supplier);
        if (LOCATION.beDebug()) {
            String additionalStr = oldSupplier == null ? "" : ". The old supplier with the same name will be replaced";
            LOCATION.debugT("Registering new extension supplier: " + supplier.getName() + additionalStr);
        }
    }

    public synchronized void unregisterExtensionSupplier(SAML2ExtensionSupplier supplier, SAML2MessageType type) {
        Map<String, SAML2ExtensionSupplier> suppliersForType = this.registeredSuppliers.get((Object)type);
        SAML2ExtensionSupplier oldSupplier = null;
        if (suppliersForType != null) {
            oldSupplier = suppliersForType.remove(supplier.getName());
        }
        if (LOCATION.beDebug()) {
            String traceStr = suppliersForType == null || oldSupplier == null ? "Supplier with name " + supplier.getName() + " is not registered and won't be unregistered" : "Supplier " + supplier.getName() + " was successfully unregistered";
            LOCATION.debugT("Registering new extension supplier: " + supplier.getName() + traceStr);
        }
    }

    public SAML2ExtensionSupplier getRegisteredSupplier(String supplierName, SAML2MessageType type) {
        Map<String, SAML2ExtensionSupplier> suppliersForType = this.registeredSuppliers.get((Object)type);
        if (suppliersForType == null) {
            return null;
        }
        return suppliersForType.get(supplierName);
    }

    public Set<SAML2ExtensionSupplierDescriptor> getAllSuppliers() {
        HashSet<SAML2ExtensionSupplierDescriptor> ret = new HashSet<SAML2ExtensionSupplierDescriptor>();
        Set<SAML2MessageType> types = this.registeredSuppliers.keySet();
        for (SAML2MessageType type : types) {
            Map<String, SAML2ExtensionSupplier> suppliersForType = this.registeredSuppliers.get((Object)type);
            Set<String> supplierNames = suppliersForType.keySet();
            Iterator<String> iterator2 = supplierNames.iterator();
            while (iterator2.hasNext()) {
                ret.add(new SAML2ExtensionSupplierWithType(iterator2.next(), type));
            }
        }
        return ret;
    }

    public static synchronized SAML2ExtensionService getInstance() {
        if (instance == null) {
            instance = new SAML2ExtensionService();
        }
        return instance;
    }

    private SAML2ExtensionService() {
    }
}

