/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.lib.protocols;

import com.sap.security.saml2.lib.assertions.AnyTypeImpl;
import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.common.SAML2JAXBUtils;
import com.sap.security.saml2.lib.common.SAML2Utils;
import com.sap.security.saml2.lib.interfaces.assertions.AnyType;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2ArtifactResponse;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2ProtocolToken;
import com.sap.security.saml2.lib.jaxb.protocol.ArtifactResponseType;
import com.sap.security.saml2.lib.jaxb.protocol.AuthnRequestType;
import com.sap.security.saml2.lib.jaxb.protocol.LogoutRequestType;
import com.sap.security.saml2.lib.jaxb.protocol.ObjectFactory;
import com.sap.security.saml2.lib.jaxb.protocol.ResponseType;
import com.sap.security.saml2.lib.jaxb.protocol.StatusResponseType;
import com.sap.security.saml2.lib.jaxb.xmldsig.SignatureType;
import com.sap.security.saml2.lib.protocols.SAML2AuthnRequestJxbImpl;
import com.sap.security.saml2.lib.protocols.SAML2LogoutRequestJxbImpl;
import com.sap.security.saml2.lib.protocols.SAML2LogoutResponseJxbImpl;
import com.sap.security.saml2.lib.protocols.SAML2ResponseBaseJxbImpl;
import com.sap.security.saml2.lib.protocols.SAML2ResponseJxbImpl;
import com.sap.tc.logging.Location;
import java.util.Date;
import javax.xml.bind.JAXBElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SAML2ArtifactResponseJxbImpl
extends SAML2ResponseBaseJxbImpl
implements SAML2ArtifactResponse {
    private static final String TEMP_PAYLOAD_ELEMENT_NAME = "TempPayload";
    private static final String TEMP_PAYLOAD_ELEMENT_NAMESPACE = "urn:sap:artifactresponse:payload";
    private static final Location LOCATION = Location.getLocation(SAML2ArtifactResponseJxbImpl.class);
    private Element payloadElementForReplace;

    public SAML2ArtifactResponseJxbImpl(Element responseElement) throws SAML2Exception {
        super(responseElement, (StatusResponseType)new ObjectFactory().createArtifactResponseType());
    }

    public SAML2ArtifactResponseJxbImpl(String xmlResponse) throws SAML2Exception {
        super(xmlResponse, (StatusResponseType)new ObjectFactory().createArtifactResponseType());
    }

    public SAML2ArtifactResponseJxbImpl(String id, String topLevelStatusCode, String samlVersion, Date issueInstant) throws SAML2Exception {
        super(id, topLevelStatusCode, samlVersion, issueInstant, new ObjectFactory().createArtifactResponseType());
    }

    @Override
    protected Document marshalToDOM() throws SAML2Exception {
        JAXBElement<ArtifactResponseType> res = new ObjectFactory().createArtifactResponse(this.getJaxbArtifactResponse());
        Document doc = SAML2JAXBUtils.marshalProtocolTokenToDOM(res);
        return doc;
    }

    @Override
    protected String marshalToXMLText() throws SAML2Exception {
        JAXBElement<ArtifactResponseType> res = new ObjectFactory().createArtifactResponse(this.getJaxbArtifactResponse());
        String result = SAML2JAXBUtils.marshalProtocolTokenToText(res);
        return result;
    }

    @Override
    protected StatusResponseType unmarshalFromDOM(Element parent) throws SAML2Exception {
        JAXBElement jaxbElement = SAML2JAXBUtils.unmarshalProtocolTokenFromDOM(parent);
        Object jaxbValue = jaxbElement.getValue();
        if (jaxbValue instanceof ArtifactResponseType) {
            return (ArtifactResponseType)jaxbValue;
        }
        throw new SAML2Exception("Invalid protocol type. Must be \"ArtifactResponse\".");
    }

    @Override
    protected StatusResponseType unmarshalFromXMLText(String xml) throws SAML2Exception {
        JAXBElement jaxbElement = SAML2JAXBUtils.unmarshalProtocolTokenFromXMLText(xml);
        Object jaxbValue = jaxbElement.getValue();
        if (jaxbValue instanceof ArtifactResponseType) {
            return (ArtifactResponseType)jaxbValue;
        }
        throw new SAML2Exception("Invalid protocol type. Must be \"ArtifactResponse\".");
    }

    @Override
    public String generate() throws SAML2Exception {
        String result;
        if (this.getMode() == 8) {
            return this.xmlResponse;
        }
        if (this.getMode() != 2) {
            throw new SAML2Exception("Wrong mode. Generate can be executed only if you initialized this with constructor (String, String, String, Date)");
        }
        if (this.getJaxbArtifactResponse().getIssueInstant() == null) {
            this.setIssueInstantToCurrentTime();
        }
        boolean payloadReplaced = false;
        Element responseElement = null;
        try {
            if (this.isSigningScheduled()) {
                SignatureType dummySignature = this.createDummySignature();
                this.getJaxbArtifactResponse().setSignature(dummySignature);
            }
            Document doc = this.marshalToDOM();
            responseElement = doc.getDocumentElement();
            if (this.payloadElementForReplace != null) {
                NodeList nl = responseElement.getElementsByTagNameNS(TEMP_PAYLOAD_ELEMENT_NAMESPACE, TEMP_PAYLOAD_ELEMENT_NAME);
                Node oldElement = nl.item(0);
                Node parent = oldElement.getParentNode();
                Element newElement = this.payloadElementForReplace;
                Node replacing = doc.importNode(newElement, true);
                parent.replaceChild(replacing, oldElement);
                payloadReplaced = true;
            }
        }
        catch (Exception e) {
            throw new SAML2Exception("Failed to replace the ArtifactResponse payload", e);
        }
        try {
            if (this.isSigningScheduled()) {
                if (payloadReplaced) {
                    result = this.sign(responseElement);
                } else {
                    Element parent = this.marshalToDOM().getDocumentElement();
                    result = this.sign(parent);
                }
            } else {
                result = payloadReplaced ? SAML2Utils.transformDOMtoXML(responseElement) : this.marshalToXMLText();
            }
        }
        catch (Exception e) {
            throw new SAML2Exception("SAML creation failed.", e);
        }
        this.xmlResponse = result;
        this.setMode(8);
        return result;
    }

    @Override
    public AnyType getPayload() {
        Object obj = this.getJaxbArtifactResponse().getAny();
        AnyTypeImpl anyType = null;
        try {
            if (obj instanceof Element) {
                anyType = new AnyTypeImpl((Element)obj);
            } else if (obj instanceof JAXBElement) {
                anyType = new AnyTypeImpl((JAXBElement)obj);
            } else {
                LOCATION.debugT("Unexpected AnyType object has been found: " + obj);
            }
        }
        catch (Exception e) {
            LOCATION.debugT("Failed to create AnyType from the object: " + obj + ". Reason: " + e);
        }
        return anyType;
    }

    @Override
    public void setPayload(AnyType any) {
        if (any != null) {
            Object content = any.getContent();
            if (content instanceof Element) {
                Document doc = ((Element)content).getOwnerDocument();
                Element tempPayload = doc.createElementNS(TEMP_PAYLOAD_ELEMENT_NAMESPACE, TEMP_PAYLOAD_ELEMENT_NAME);
                this.getJaxbArtifactResponse().setAny(tempPayload);
                this.payloadElementForReplace = (Element)content;
            } else {
                this.getJaxbArtifactResponse().setAny(content);
            }
        }
    }

    @Override
    public SAML2ProtocolToken extractPayloadAsProtocolToken() throws SAML2Exception {
        if (this.getMode() != 16) {
            throw new SAML2Exception("extractPayloadAsProtocolToken() is available only if the token is in state parsed.");
        }
        Object obj = this.getJaxbArtifactResponse().getAny();
        Element domElement = null;
        JAXBElement jaxbElement = null;
        if (obj instanceof Element) {
            domElement = (Element)obj;
        } else if (obj instanceof JAXBElement) {
            jaxbElement = (JAXBElement)obj;
        } else {
            LOCATION.debugT("Unexpected AnyType object has been found: " + obj);
            return null;
        }
        int tokenType = 0;
        tokenType = jaxbElement != null ? SAML2Utils.resolveSAMLProtocolTokenType(jaxbElement) : SAML2Utils.resolveSAMLProtocolTokenType(domElement);
        SAML2ProtocolToken samlToken = null;
        switch (tokenType) {
            case 2: {
                LOCATION.debugT("Found AuthnRequest element in the ArtifactResponse.");
                if (jaxbElement != null) {
                    Element domForSecOperations = this.findPayloadElement("urn:oasis:names:tc:SAML:2.0:protocol", "AuthnRequest");
                    samlToken = new SAML2AuthnRequestJxbImpl((AuthnRequestType)jaxbElement.getValue(), domForSecOperations);
                    break;
                }
                samlToken = new SAML2AuthnRequestJxbImpl(domElement);
                break;
            }
            case 8: {
                LOCATION.debugT("Found Response element in the ArtifactResponse.");
                if (jaxbElement != null) {
                    Element domForSecOperations = this.findPayloadElement("urn:oasis:names:tc:SAML:2.0:protocol", "Response");
                    samlToken = new SAML2ResponseJxbImpl((ResponseType)jaxbElement.getValue(), domForSecOperations);
                    break;
                }
                samlToken = new SAML2ResponseJxbImpl(domElement);
                break;
            }
            case 4: {
                LOCATION.debugT("Found LogoutRequest element in the ArtifactResponse.");
                if (jaxbElement != null) {
                    Element domForSecOperations = this.findPayloadElement("urn:oasis:names:tc:SAML:2.0:protocol", "LogoutRequest");
                    samlToken = new SAML2LogoutRequestJxbImpl((LogoutRequestType)jaxbElement.getValue(), domForSecOperations);
                    break;
                }
                samlToken = new SAML2LogoutRequestJxbImpl(domElement);
                break;
            }
            case 16: {
                LOCATION.debugT("Found LogoutResponse element in the ArtifactResponse.");
                if (jaxbElement != null) {
                    Element domForSecOperations = this.findPayloadElement("urn:oasis:names:tc:SAML:2.0:protocol", "LogoutResponse");
                    samlToken = new SAML2LogoutResponseJxbImpl((StatusResponseType)jaxbElement.getValue(), domForSecOperations);
                    break;
                }
                samlToken = new SAML2LogoutResponseJxbImpl(domElement);
                break;
            }
        }
        if (samlToken != null) {
            samlToken.parse();
        }
        return samlToken;
    }

    private Element findPayloadElement(String namespace, String localName) throws SAML2Exception {
        Element domForSecOperations = this.getDomForSecOperations();
        NodeList nodeList = domForSecOperations.getElementsByTagNameNS(namespace, localName);
        if (nodeList == null || nodeList.getLength() < 1) {
            return null;
        }
        return (Element)nodeList.item(0);
    }

    protected ArtifactResponseType getJaxbArtifactResponse() {
        return (ArtifactResponseType)super.getJaxbResponseBase();
    }
}

