/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.lib.protocols;

import com.sap.security.saml2.lib.assertions.SAML2EncryptedNameIDJxbImpl;
import com.sap.security.saml2.lib.assertions.SAML2NameIDJxbImpl;
import com.sap.security.saml2.lib.assertions.SAML2ScopingJxbImpl;
import com.sap.security.saml2.lib.assertions.SAML2SubjectConfirmationJxbImpl;
import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.common.SAML2JAXBUtils;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2EncryptedNameID;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2NameID;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2Scoping;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2SubjectConfirmation;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2AuthRequest;
import com.sap.security.saml2.lib.jaxb.assertion.EncryptedElementType;
import com.sap.security.saml2.lib.jaxb.assertion.SubjectConfirmationType;
import com.sap.security.saml2.lib.jaxb.assertion.SubjectType;
import com.sap.security.saml2.lib.jaxb.protocol.AuthnContextComparisonType;
import com.sap.security.saml2.lib.jaxb.protocol.AuthnRequestType;
import com.sap.security.saml2.lib.jaxb.protocol.NameIDPolicyType;
import com.sap.security.saml2.lib.jaxb.protocol.ObjectFactory;
import com.sap.security.saml2.lib.jaxb.protocol.RequestAbstractType;
import com.sap.security.saml2.lib.jaxb.protocol.RequestedAuthnContextType;
import com.sap.security.saml2.lib.jaxb.protocol.ScopingType;
import com.sap.security.saml2.lib.protocols.SAML2RequestBaseJxbImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SAML2AuthnRequestJxbImpl
extends SAML2RequestBaseJxbImpl
implements SAML2AuthRequest {
    public SAML2AuthnRequestJxbImpl(AuthnRequestType jaxbAuthnRequest, Element domForSecOperations) throws SAML2Exception {
        super(jaxbAuthnRequest, domForSecOperations);
    }

    public SAML2AuthnRequestJxbImpl(Element requestElement) throws SAML2Exception {
        super(requestElement, (RequestAbstractType)new ObjectFactory().createAuthnRequestType());
    }

    public SAML2AuthnRequestJxbImpl(String xmlRequest) throws SAML2Exception {
        super(xmlRequest, (RequestAbstractType)new ObjectFactory().createAuthnRequestType());
    }

    public SAML2AuthnRequestJxbImpl(String id, String samlVersion, Date issueInstant) throws SAML2Exception {
        super(id, samlVersion, issueInstant, new ObjectFactory().createAuthnRequestType());
    }

    @Override
    public Document marshalToDOM() throws SAML2Exception {
        JAXBElement<AuthnRequestType> req = new ObjectFactory().createAuthnRequest(this.getJaxbAuthnRequest());
        Document doc = SAML2JAXBUtils.marshalProtocolTokenToDOM(req);
        return doc;
    }

    @Override
    protected String marshalToXMLText() throws SAML2Exception {
        JAXBElement<AuthnRequestType> req = new ObjectFactory().createAuthnRequest(this.getJaxbAuthnRequest());
        String result = SAML2JAXBUtils.marshalProtocolTokenToText(req);
        return result;
    }

    @Override
    protected AuthnRequestType unmarshalFromDOM(Element parent) throws SAML2Exception {
        JAXBElement jaxbElement = SAML2JAXBUtils.unmarshalProtocolTokenFromDOM(parent);
        Object jaxbValue = jaxbElement.getValue();
        if (jaxbValue instanceof AuthnRequestType) {
            return (AuthnRequestType)jaxbValue;
        }
        throw new SAML2Exception("Invalid protocol type. Must be \"AuthnRequest\".");
    }

    @Override
    protected AuthnRequestType unmarshalFromXMLText(String xml) throws SAML2Exception {
        JAXBElement jaxbElement = SAML2JAXBUtils.unmarshalProtocolTokenFromXMLText(xml);
        Object jaxbValue = jaxbElement.getValue();
        if (jaxbValue instanceof AuthnRequestType) {
            return (AuthnRequestType)jaxbValue;
        }
        throw new SAML2Exception("Invalid protocol type. Must be \"AuthnRequest\".");
    }

    @Override
    public String getAssertionConsumerServiceURL() {
        return this.getJaxbAuthnRequest().getAssertionConsumerServiceURL();
    }

    @Override
    public String getNameIDPolicyFormat() {
        String format = null;
        NameIDPolicyType policy = this.getJaxbAuthnRequest().getNameIDPolicy();
        if (policy != null) {
            format = policy.getFormat();
        }
        return format;
    }

    @Override
    public String getNameIDPolicySPNameQualifier() {
        String spNameQualifier = null;
        NameIDPolicyType policy = this.getJaxbAuthnRequest().getNameIDPolicy();
        if (policy != null) {
            spNameQualifier = policy.getSPNameQualifier();
        }
        return spNameQualifier;
    }

    @Override
    public String getProtocolBinding() {
        return this.getJaxbAuthnRequest().getProtocolBinding();
    }

    @Override
    public String getProviderName() {
        return this.getJaxbAuthnRequest().getProviderName();
    }

    @Override
    public boolean isForceAuthn() {
        Boolean forceAuthn = this.getJaxbAuthnRequest().isForceAuthn();
        if (forceAuthn != null) {
            return forceAuthn;
        }
        return false;
    }

    @Override
    public boolean isNameIDPolicyAllowCreate() {
        Boolean allowCreate;
        NameIDPolicyType policy = this.getJaxbAuthnRequest().getNameIDPolicy();
        if (policy != null && (allowCreate = policy.isAllowCreate()) != null) {
            return allowCreate;
        }
        return false;
    }

    @Override
    public boolean isPassive() {
        Boolean isPasive = this.getJaxbAuthnRequest().isIsPassive();
        if (isPasive != null) {
            return isPasive;
        }
        return false;
    }

    @Override
    public void setAssertionConsumerServiceURL(String uri) {
        this.getJaxbAuthnRequest().setAssertionConsumerServiceURL(uri);
    }

    @Override
    public void setForceAuthn(boolean fourceAuthn) {
        this.getJaxbAuthnRequest().setForceAuthn(fourceAuthn);
    }

    @Override
    public void setNameIDPolicyAllowCreate(boolean allowCreate) {
        NameIDPolicyType policy = this.getJaxbAuthnRequest().getNameIDPolicy();
        if (policy != null) {
            policy.setAllowCreate(allowCreate);
        } else {
            policy = new ObjectFactory().createNameIDPolicyType();
            policy.setAllowCreate(allowCreate);
            this.getJaxbAuthnRequest().setNameIDPolicy(policy);
        }
    }

    @Override
    public void setNameIDPolicyFormat(String format) {
        NameIDPolicyType policy = this.getJaxbAuthnRequest().getNameIDPolicy();
        if (policy != null) {
            policy.setFormat(format);
        } else {
            policy = new ObjectFactory().createNameIDPolicyType();
            policy.setFormat(format);
            this.getJaxbAuthnRequest().setNameIDPolicy(policy);
        }
    }

    @Override
    public void setNameIDPolicySPNameQualifier(String spNameQualifier) {
        NameIDPolicyType policy = this.getJaxbAuthnRequest().getNameIDPolicy();
        if (policy != null) {
            policy.setSPNameQualifier(spNameQualifier);
        } else {
            policy = new ObjectFactory().createNameIDPolicyType();
            policy.setSPNameQualifier(spNameQualifier);
            this.getJaxbAuthnRequest().setNameIDPolicy(policy);
        }
    }

    @Override
    public void setPassive(boolean passive) {
        this.getJaxbAuthnRequest().setIsPassive(passive);
    }

    @Override
    public void setProtocolBinding(String uri) {
        this.getJaxbAuthnRequest().setProtocolBinding(uri);
    }

    @Override
    public void setProviderName(String name) {
        this.getJaxbAuthnRequest().setProviderName(name);
    }

    protected AuthnRequestType getJaxbAuthnRequest() {
        return (AuthnRequestType)super.getJaxbRequest();
    }

    @Override
    public List<String> getRequestedAuthnContextClassRefs() {
        RequestedAuthnContextType authnContext = this.getJaxbAuthnRequest().getRequestedAuthnContext();
        if (authnContext != null) {
            return authnContext.getAuthnContextClassRef();
        }
        return null;
    }

    @Override
    public void setRequestedAuthnContextClassRefs(List<String> anyURIs) {
        RequestedAuthnContextType authnContext = this.getJaxbAuthnRequest().getRequestedAuthnContext();
        if (authnContext != null) {
            authnContext.getAuthnContextClassRef().addAll(anyURIs);
        } else {
            authnContext = new ObjectFactory().createRequestedAuthnContextType();
            authnContext.getAuthnContextClassRef().addAll(anyURIs);
            this.getJaxbAuthnRequest().setRequestedAuthnContext(authnContext);
        }
    }

    @Override
    public List<String> getRequestedAuthnContextDeclRefs() {
        RequestedAuthnContextType authnContext = this.getJaxbAuthnRequest().getRequestedAuthnContext();
        if (authnContext != null) {
            return authnContext.getAuthnContextDeclRef();
        }
        return null;
    }

    @Override
    public void setRequestedAuthnContextDeclRefs(List<String> anyURIs) {
        RequestedAuthnContextType authnContext = this.getJaxbAuthnRequest().getRequestedAuthnContext();
        if (authnContext != null) {
            authnContext.getAuthnContextDeclRef().addAll(anyURIs);
        } else {
            authnContext = new ObjectFactory().createRequestedAuthnContextType();
            authnContext.getAuthnContextDeclRef().addAll(anyURIs);
            this.getJaxbAuthnRequest().setRequestedAuthnContext(authnContext);
        }
    }

    @Override
    public String getRequestedAuthnContextComparison() {
        AuthnContextComparisonType comparisonType;
        RequestedAuthnContextType authnContext = this.getJaxbAuthnRequest().getRequestedAuthnContext();
        if (authnContext != null && (comparisonType = authnContext.getComparison()) != null) {
            return comparisonType.value();
        }
        return null;
    }

    @Override
    public void setRequestedAuthnContextComparison(String comparisonMethod) {
        RequestedAuthnContextType authnContext = this.getJaxbAuthnRequest().getRequestedAuthnContext();
        if (authnContext != null) {
            authnContext.setComparison(AuthnContextComparisonType.fromValue(comparisonMethod));
        } else {
            authnContext = new ObjectFactory().createRequestedAuthnContextType();
            authnContext.setComparison(AuthnContextComparisonType.fromValue(comparisonMethod));
            this.getJaxbAuthnRequest().setRequestedAuthnContext(authnContext);
        }
    }

    @Override
    public Integer getAssertionConsumerServiceIndex() {
        return this.getJaxbAuthnRequest().getAssertionConsumerServiceIndex();
    }

    @Override
    public void setAssertionConsumerServiceIndex(Integer index) {
        if (index != null) {
            this.getJaxbAuthnRequest().setAssertionConsumerServiceIndex(index);
        }
    }

    @Override
    public SAML2Scoping getScoping() {
        ScopingType jaxbScoping = this.getJaxbAuthnRequest().getScoping();
        if (jaxbScoping != null) {
            return new SAML2ScopingJxbImpl(jaxbScoping);
        }
        return null;
    }

    @Override
    public void setScoping(SAML2Scoping scoping) {
        if (scoping != null) {
            ScopingType jaxbScoping = (ScopingType)scoping.convertToSAMLGenerator();
            this.getJaxbAuthnRequest().setScoping(jaxbScoping);
        }
    }

    @Override
    public SAML2EncryptedNameID getEncryptedSubjectNameID() {
        SubjectType subject = this.getJaxbAuthnRequest().getSubject();
        if (subject != null && subject.getEncryptedID() != null) {
            return new SAML2EncryptedNameIDJxbImpl(subject.getEncryptedID());
        }
        return null;
    }

    @Override
    public SAML2NameID getSubjectNameID() {
        SubjectType subject = this.getJaxbAuthnRequest().getSubject();
        if (subject != null && subject.getNameID() != null) {
            return new SAML2NameIDJxbImpl(subject.getNameID());
        }
        return null;
    }

    @Override
    public List<SAML2SubjectConfirmation> getSubjectConfirmations() {
        ArrayList<SAML2SubjectConfirmationJxbImpl> result = null;
        SubjectType subject = this.getJaxbAuthnRequest().getSubject();
        if (subject != null && subject.getSubjectConfirmation() != null) {
            List<SubjectConfirmationType> subjectConfirmations = subject.getSubjectConfirmation();
            result = new ArrayList<SAML2SubjectConfirmationJxbImpl>(subjectConfirmations.size());
            for (SubjectConfirmationType subjectConfirmation : subjectConfirmations) {
                try {
                    if (subjectConfirmation == null) continue;
                    result.add(new SAML2SubjectConfirmationJxbImpl(subjectConfirmation));
                }
                catch (SAML2Exception e) {
                    throw new IllegalStateException(e);
                }
            }
        }
        return result;
    }

    @Override
    public void setEncryptedSubjectNameID(SAML2EncryptedNameID encryptedNameId) {
        if (encryptedNameId != null) {
            SubjectType subject = this.getJaxbAuthnRequest().getSubject();
            if (subject == null) {
                subject = new SubjectType();
                this.getJaxbAuthnRequest().setSubject(subject);
            }
            try {
                subject.setEncryptedID((EncryptedElementType)encryptedNameId.convertToSAMLGenerator());
            }
            catch (SAML2Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    public void setSubjectNameID(SAML2NameID nameId) {
        if (nameId != null) {
            SubjectType subject = this.getJaxbAuthnRequest().getSubject();
            if (subject == null) {
                subject = new SubjectType();
                this.getJaxbAuthnRequest().setSubject(subject);
            }
            subject.setNameID(nameId.convertToSAMLGenerator());
        }
    }

    @Override
    public void setSubjectConfirmations(List<SAML2SubjectConfirmation> confirmations) {
        if (confirmations != null && !confirmations.isEmpty()) {
            SubjectType subject = this.getJaxbAuthnRequest().getSubject();
            if (subject == null) {
                subject = new SubjectType();
                this.getJaxbAuthnRequest().setSubject(subject);
            }
            for (SAML2SubjectConfirmation subjectConfirmation : confirmations) {
                if (subjectConfirmation == null) continue;
                try {
                    subject.getSubjectConfirmation().add((SubjectConfirmationType)subjectConfirmation.convertToSAMLGenerator());
                }
                catch (SAML2Exception e) {
                    throw new IllegalStateException(e);
                }
            }
        }
    }
}

