/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.lib.protocols;

import com.sap.security.saml2.lib.assertions.SAML2EncryptedNameIDJxbImpl;
import com.sap.security.saml2.lib.assertions.SAML2NameIDJxbImpl;
import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.common.SAML2JAXBUtils;
import com.sap.security.saml2.lib.common.SAML2Utils;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2EncryptedNameID;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2NameID;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2LogoutRequest;
import com.sap.security.saml2.lib.jaxb.assertion.EncryptedElementType;
import com.sap.security.saml2.lib.jaxb.assertion.NameIDType;
import com.sap.security.saml2.lib.jaxb.protocol.LogoutRequestType;
import com.sap.security.saml2.lib.jaxb.protocol.ObjectFactory;
import com.sap.security.saml2.lib.jaxb.protocol.RequestAbstractType;
import com.sap.security.saml2.lib.protocols.SAML2RequestBaseJxbImpl;
import java.util.Date;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.datatype.XMLGregorianCalendar;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SAML2LogoutRequestJxbImpl
extends SAML2RequestBaseJxbImpl
implements SAML2LogoutRequest {
    public SAML2LogoutRequestJxbImpl(LogoutRequestType jaxbLogoutRequest, Element domForSecOperations) throws SAML2Exception {
        super(jaxbLogoutRequest, domForSecOperations);
    }

    public SAML2LogoutRequestJxbImpl(Element requestElement) throws SAML2Exception {
        super(requestElement, (RequestAbstractType)new ObjectFactory().createLogoutRequestType());
    }

    public SAML2LogoutRequestJxbImpl(String xmlRequest) throws SAML2Exception {
        super(xmlRequest, (RequestAbstractType)new ObjectFactory().createLogoutRequestType());
    }

    public SAML2LogoutRequestJxbImpl(String id, String samlVersion, Date issueInstant, SAML2NameID nameID) throws SAML2Exception {
        super(id, samlVersion, issueInstant, new ObjectFactory().createLogoutRequestType());
        if (nameID == null) {
            throw new SAML2Exception("NameID cannot be null");
        }
        this.getJaxbLogoutRequest().setNameID(nameID.convertToSAMLGenerator());
    }

    public SAML2LogoutRequestJxbImpl(String id, String samlVersion, Date issueInstant, SAML2EncryptedNameID encryptedNameID) throws SAML2Exception {
        super(id, samlVersion, issueInstant, new ObjectFactory().createLogoutRequestType());
        if (encryptedNameID == null) {
            throw new SAML2Exception("encryptedNameID cannot be null");
        }
        this.getJaxbLogoutRequest().setEncryptedID(((SAML2EncryptedNameIDJxbImpl)encryptedNameID).convertToSAMLGenerator());
    }

    @Override
    protected Document marshalToDOM() throws SAML2Exception {
        JAXBElement<LogoutRequestType> req = new ObjectFactory().createLogoutRequest(this.getJaxbLogoutRequest());
        Document doc = SAML2JAXBUtils.marshalProtocolTokenToDOM(req);
        return doc;
    }

    @Override
    protected String marshalToXMLText() throws SAML2Exception {
        JAXBElement<LogoutRequestType> req = new ObjectFactory().createLogoutRequest(this.getJaxbLogoutRequest());
        String result = SAML2JAXBUtils.marshalProtocolTokenToText(req);
        return result;
    }

    @Override
    protected RequestAbstractType unmarshalFromDOM(Element parent) throws SAML2Exception {
        JAXBElement jaxbElement = SAML2JAXBUtils.unmarshalProtocolTokenFromDOM(parent);
        Object jaxbValue = jaxbElement.getValue();
        if (jaxbValue instanceof LogoutRequestType) {
            return (LogoutRequestType)jaxbValue;
        }
        throw new SAML2Exception("Invalid protocol type. Must be \"LogoutRequest\".");
    }

    @Override
    protected RequestAbstractType unmarshalFromXMLText(String xml) throws SAML2Exception {
        JAXBElement jaxbElement = SAML2JAXBUtils.unmarshalProtocolTokenFromXMLText(xml);
        Object jaxbValue = jaxbElement.getValue();
        if (jaxbValue instanceof LogoutRequestType) {
            return (LogoutRequestType)jaxbValue;
        }
        throw new SAML2Exception("Invalid protocol type. Must be \"LogoutRequest\".");
    }

    @Override
    public SAML2NameID getNameID() {
        NameIDType nameID = this.getJaxbLogoutRequest().getNameID();
        if (nameID != null) {
            return new SAML2NameIDJxbImpl(nameID);
        }
        return null;
    }

    @Override
    public SAML2EncryptedNameID getEncryptedNameID() {
        EncryptedElementType encrypted = this.getJaxbLogoutRequest().getEncryptedID();
        if (encrypted != null) {
            return new SAML2EncryptedNameIDJxbImpl(encrypted);
        }
        return null;
    }

    @Override
    public Date getNotOnOrAfter() {
        Date date = SAML2Utils.convertXMLGregorianCalendarToDate(this.getJaxbLogoutRequest().getNotOnOrAfter());
        return date;
    }

    @Override
    public String getReason() {
        return this.getJaxbLogoutRequest().getReason();
    }

    @Override
    public List<String> getSessionIndex() {
        return this.getJaxbLogoutRequest().getSessionIndex();
    }

    @Override
    public void setNotOnOrAfter(Date date) throws SAML2Exception {
        if (date != null) {
            XMLGregorianCalendar xmlCal = SAML2Utils.convertDateToXMLGregorianCalendar(date);
            this.getJaxbLogoutRequest().setNotOnOrAfter(xmlCal);
        }
    }

    @Override
    public void setReason(String reason) {
        this.getJaxbLogoutRequest().setReason(reason);
    }

    @Override
    public void setSessionIndex(List<String> indexes) {
        this.getJaxbLogoutRequest().getSessionIndex().addAll(indexes);
    }

    protected LogoutRequestType getJaxbLogoutRequest() {
        return (LogoutRequestType)super.getJaxbRequest();
    }
}

