/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.lib.protocols;

import com.sap.security.saml2.lib.assertions.AnyTypeImpl;
import com.sap.security.saml2.lib.assertions.SAML2NameIDJxbImpl;
import com.sap.security.saml2.lib.assertions.SAML2SignatureKeyInfoImpl;
import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.common.SAML2Utils;
import com.sap.security.saml2.lib.interfaces.assertions.AnyType;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2NameID;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2SignatureKeyInfo;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2RequestBase;
import com.sap.security.saml2.lib.jaxb.assertion.NameIDType;
import com.sap.security.saml2.lib.jaxb.protocol.ExtensionsType;
import com.sap.security.saml2.lib.jaxb.protocol.RequestAbstractType;
import com.sap.security.saml2.lib.jaxb.xmldsig.KeyInfoType;
import com.sap.security.saml2.lib.jaxb.xmldsig.ObjectFactory;
import com.sap.security.saml2.lib.jaxb.xmldsig.SignatureType;
import com.sap.security.saml2.lib.protocols.SAML2ProtocolTokenBase;
import com.sap.security.saml2.lib.xmlsecurity.XMLSignature;
import com.sap.security.saml2.lib.xmlsecurity.XMLSignatureManager;
import com.sap.tc.logging.Location;
import java.io.StringWriter;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.datatype.XMLGregorianCalendar;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class SAML2RequestBaseJxbImpl
extends SAML2ProtocolTokenBase
implements SAML2RequestBase {
    private Element domElement;
    private String xmlRequest;
    private boolean isSigned;
    private PrivateKey signPrivateKey;
    private Certificate signCert;
    private Element domForSecOperations;
    private String xmlRepresentationForTrace;
    protected String digestAlgorithm;
    protected String signature;
    private SAML2SignatureKeyInfo signatureKeyInfo;
    protected RequestAbstractType jaxbRequest;
    private static final Location LOCATION = Location.getLocation(SAML2RequestBaseJxbImpl.class);

    protected SAML2RequestBaseJxbImpl(RequestAbstractType jaxbRequest, Element domForSecOperations) throws SAML2Exception {
        if (jaxbRequest == null) {
            throw new SAML2Exception("Invalid Request type jaxbRequest: " + jaxbRequest);
        }
        this.jaxbRequest = jaxbRequest;
        this.domForSecOperations = domForSecOperations;
        this.setMode(4);
    }

    protected SAML2RequestBaseJxbImpl(Element requestElement, RequestAbstractType jaxbRequest) throws SAML2Exception {
        if (requestElement == null) {
            throw new SAML2Exception("Invalid SAML request: " + requestElement);
        }
        if (jaxbRequest == null) {
            throw new SAML2Exception("Invalid Request type jaxbRequest: " + jaxbRequest);
        }
        this.jaxbRequest = jaxbRequest;
        this.domElement = requestElement;
        this.setMode(4);
    }

    protected SAML2RequestBaseJxbImpl(String xmlRequest, RequestAbstractType jaxbRequest) throws SAML2Exception {
        if (xmlRequest == null || xmlRequest.length() < 1) {
            throw new SAML2Exception("Invalid SAML request: " + xmlRequest);
        }
        if (jaxbRequest == null) {
            throw new SAML2Exception("Invalid Request type jaxbRequest: " + jaxbRequest);
        }
        this.jaxbRequest = jaxbRequest;
        this.xmlRequest = xmlRequest;
        this.setMode(4);
    }

    protected SAML2RequestBaseJxbImpl(String id, String samlVersion, Date issueInstant, RequestAbstractType jaxbRequest) throws SAML2Exception {
        if (jaxbRequest == null) {
            throw new SAML2Exception("Invalid Request type jaxbRequest: " + jaxbRequest);
        }
        this.jaxbRequest = jaxbRequest;
        jaxbRequest.setID(id);
        if (samlVersion != null) {
            jaxbRequest.setVersion(samlVersion);
        } else {
            jaxbRequest.setVersion("2.0");
        }
        if (issueInstant != null) {
            XMLGregorianCalendar xmlCal = SAML2Utils.convertDateToXMLGregorianCalendar(issueInstant);
            jaxbRequest.setIssueInstant(xmlCal);
        }
        this.setMode(2);
    }

    protected void setIssueInstantToCurrentTime() throws SAML2Exception {
        XMLGregorianCalendar xmlCal = SAML2Utils.currentXMLGregorianCalendar();
        this.jaxbRequest.setIssueInstant(xmlCal);
    }

    @Override
    public String getConsent() {
        return this.jaxbRequest.getConsent();
    }

    @Override
    public String getDestination() {
        return this.jaxbRequest.getDestination();
    }

    @Override
    public List<AnyType> getExtensions() {
        ArrayList<AnyType> result = new ArrayList<AnyType>();
        ExtensionsType extensions = this.jaxbRequest.getExtensions();
        List<Object> any = extensions.getAny();
        if (any != null) {
            for (Object object : any) {
                AnyTypeImpl anyType = null;
                try {
                    if (object instanceof Element) {
                        anyType = new AnyTypeImpl((Element)object);
                    } else if (object instanceof JAXBElement) {
                        anyType = new AnyTypeImpl((JAXBElement)object);
                    } else {
                        LOCATION.debugT("Unexpected AnyType object has been found: " + object);
                    }
                }
                catch (Exception e) {
                    LOCATION.debugT("Failed to create AnyType from the object: " + object + ". Reason: " + e);
                }
                if (anyType == null) continue;
                result.add(anyType);
            }
        }
        return result;
    }

    @Override
    public String getID() {
        return this.jaxbRequest.getID();
    }

    @Override
    public Date getIssueInstant() {
        Date date = SAML2Utils.convertXMLGregorianCalendarToDate(this.jaxbRequest.getIssueInstant());
        return date;
    }

    @Override
    public SAML2NameID getIssuer() {
        NameIDType issuer = this.jaxbRequest.getIssuer();
        if (issuer != null) {
            return new SAML2NameIDJxbImpl(issuer);
        }
        return null;
    }

    @Override
    public String getSignature() {
        return this.signature;
    }

    @Override
    public String getVersion() {
        return this.jaxbRequest.getVersion();
    }

    @Override
    public void setConsent(String uri) {
        this.jaxbRequest.setConsent(uri);
    }

    @Override
    public void setDestination(String uri) {
        this.jaxbRequest.setDestination(uri);
    }

    @Override
    public void setExtensions(List<AnyType> extensions) {
        if (extensions == null) {
            return;
        }
        com.sap.security.saml2.lib.jaxb.protocol.ObjectFactory factory = new com.sap.security.saml2.lib.jaxb.protocol.ObjectFactory();
        ExtensionsType jaxbExtensions = factory.createExtensionsType();
        for (AnyType anyType : extensions) {
            jaxbExtensions.getAny().add(anyType.getContent());
        }
        this.jaxbRequest.setExtensions(jaxbExtensions);
    }

    @Override
    public void setIssuer(SAML2NameID issuer) {
        if (issuer != null) {
            NameIDType iss = issuer.convertToSAMLGenerator();
            this.jaxbRequest.setIssuer(iss);
        }
    }

    @Override
    public String generate() throws SAML2Exception {
        String result;
        if (this.getMode() == 8) {
            return this.xmlRequest;
        }
        if (this.getMode() != 2) {
            throw new SAML2Exception("Wrong mode. Generate can be executed only if you initialized this with constructor (String, String, Date)");
        }
        if (this.jaxbRequest.getIssueInstant() == null) {
            this.setIssueInstantToCurrentTime();
        }
        try {
            if (this.isSigningScheduled()) {
                SignatureType dummySignature = this.createDummySignature();
                this.jaxbRequest.setSignature(dummySignature);
                Element parent = this.marshalToDOM().getDocumentElement();
                result = this.sign(parent);
            } else {
                result = this.marshalToXMLText();
            }
        }
        catch (Exception e) {
            throw new SAML2Exception("SAML creation failed.", e);
        }
        this.xmlRequest = result;
        this.setMode(8);
        return result;
    }

    protected String sign(Element parent) throws SAML2Exception {
        XMLSignature signer = XMLSignatureManager.getXMLSignatureInstance();
        StringWriter signedXML = new StringWriter(2000);
        this.signature = signer.sign(parent, this.getID(), this.signPrivateKey, this.signCert, signedXML, this.digestAlgorithm);
        String result = signedXML.toString();
        this.isSigned = true;
        return result;
    }

    @Override
    public boolean isSigned() {
        return this.isSigned;
    }

    @Override
    public SAML2SignatureKeyInfo getSignatureKeyInfo() {
        return this.signatureKeyInfo;
    }

    @Override
    public void parse() throws SAML2Exception {
        if (this.getMode() == 16) {
            return;
        }
        if (this.getMode() != 4) {
            throw new SAML2Exception("Wrong mode. Parse can be executed only if you initialized this either with constructor(String) or constructor(Element)");
        }
        try {
            if (this.domElement != null) {
                this.jaxbRequest = this.unmarshalFromDOM(this.domElement);
            } else if (this.xmlRequest != null) {
                this.jaxbRequest = this.unmarshalFromXMLText(this.xmlRequest);
            }
            SignatureType jaxbSignature = this.jaxbRequest.getSignature();
            if (jaxbSignature != null) {
                this.isSigned = true;
                KeyInfoType jaxbKeyInfo = jaxbSignature.getKeyInfo();
                if (jaxbKeyInfo != null) {
                    this.signatureKeyInfo = new SAML2SignatureKeyInfoImpl(jaxbKeyInfo);
                }
            }
        }
        catch (Exception e) {
            throw new SAML2Exception("SAML parsing failed.", e);
        }
        this.setMode(16);
    }

    protected abstract String marshalToXMLText() throws SAML2Exception;

    protected abstract Document marshalToDOM() throws SAML2Exception;

    protected abstract RequestAbstractType unmarshalFromDOM(Element var1) throws SAML2Exception;

    protected abstract RequestAbstractType unmarshalFromXMLText(String var1) throws SAML2Exception;

    @Override
    public void sign(PrivateKey key) throws SAML2Exception {
        this.sign(key, null);
    }

    @Override
    public void sign(PrivateKey key, Certificate cert) throws SAML2Exception {
        if (key == null) {
            LOCATION.debugT("Attempt to sign the request with null PrivateKey");
            throw new SAML2Exception("Signing cannot be proceeded without PrivateKey. key: " + key);
        }
        if (this.getMode() == 4 || this.getMode() == 16) {
            throw new SAML2Exception("Wrong mode. Signing does not make sense for parsed request.");
        }
        if (this.getMode() != 2) {
            throw new SAML2Exception("Wrong mode. Signing is not possible after request generation.");
        }
        this.signPrivateKey = key;
        this.signCert = cert;
        this.setSigningScheduled(true);
    }

    @Override
    public void validateData() throws SAML2Exception {
    }

    @Override
    public void validateSignature(Certificate senderCert) throws SAML2Exception {
        Element parent;
        if (this.getMode() != 16) {
            throw new SAML2Exception("Wrong mode. To validate the signature the token should be parsed first.");
        }
        if (!this.isSigned()) {
            throw new SAML2Exception("The request is not signed.");
        }
        try {
            parent = this.getDomForSecOperations();
        }
        catch (Exception e) {
            throw new SAML2Exception("Failed to check signature.", e);
        }
        XMLSignature verifier = XMLSignatureManager.getXMLSignatureInstance();
        if (!verifier.verify(parent, senderCert)) {
            if (LOCATION.beWarning()) {
                LOCATION.warningT("Signature verification for Request with id: " + this.getID() + " failed.");
            }
            throw new SAML2Exception("Signature not valid!");
        }
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Signature for Request with id: " + this.getID() + " verified successfuly.");
        }
    }

    protected Element getDomForSecOperations() throws SAML2Exception {
        Element result;
        if (this.domForSecOperations != null) {
            return this.domForSecOperations;
        }
        if (this.domElement != null) {
            result = this.domForSecOperations = this.domElement;
        } else if (this.xmlRequest != null) {
            Document doc = SAML2Utils.transformXMLtoDOM(this.xmlRequest);
            result = this.domForSecOperations = doc.getDocumentElement();
        } else {
            Document doc = this.marshalToDOM();
            result = this.domForSecOperations = doc.getDocumentElement();
        }
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(500);
        builder.append("SAML token mode: ").append(this.getMode()).append("\n");
        if (this.xmlRepresentationForTrace == null) {
            this.obtainXMLRepresenationForTrace();
        }
        if (this.xmlRepresentationForTrace != null) {
            builder.append("XML representation:\n").append(this.xmlRepresentationForTrace);
        } else {
            builder.append("The token is still not generated and does not have XML representation");
        }
        return builder.toString();
    }

    @Override
    public String getXMLRepresentation() {
        if (this.xmlRepresentationForTrace == null) {
            this.obtainXMLRepresenationForTrace();
        }
        return this.xmlRepresentationForTrace;
    }

    private void obtainXMLRepresenationForTrace() {
        if (this.xmlRequest != null) {
            this.xmlRepresentationForTrace = this.xmlRequest.replaceAll("\\>\\<", ">\n<");
        } else if (this.domElement != null) {
            this.xmlRepresentationForTrace = SAML2Utils.transformDOMForTrace(this.domElement);
        } else if (this.domForSecOperations != null) {
            this.xmlRepresentationForTrace = SAML2Utils.transformDOMForTrace(this.domForSecOperations);
        }
    }

    protected RequestAbstractType getJaxbRequest() {
        return this.jaxbRequest;
    }

    protected SignatureType createDummySignature() {
        SignatureType dummySignature = new ObjectFactory().createSignatureType();
        return dummySignature;
    }

    @Override
    public void setDigestAlgorithm(String digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
    }
}

