/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.lib.protocols;

import com.sap.security.saml2.lib.assertions.AnyTypeImpl;
import com.sap.security.saml2.lib.assertions.SAML2NameIDJxbImpl;
import com.sap.security.saml2.lib.assertions.SAML2SignatureKeyInfoImpl;
import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.common.SAML2Utils;
import com.sap.security.saml2.lib.interfaces.assertions.AnyType;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2NameID;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2SignatureKeyInfo;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2ResponseBase;
import com.sap.security.saml2.lib.jaxb.assertion.NameIDType;
import com.sap.security.saml2.lib.jaxb.protocol.ExtensionsType;
import com.sap.security.saml2.lib.jaxb.protocol.StatusCodeType;
import com.sap.security.saml2.lib.jaxb.protocol.StatusDetailType;
import com.sap.security.saml2.lib.jaxb.protocol.StatusResponseType;
import com.sap.security.saml2.lib.jaxb.protocol.StatusType;
import com.sap.security.saml2.lib.jaxb.xmldsig.KeyInfoType;
import com.sap.security.saml2.lib.jaxb.xmldsig.ObjectFactory;
import com.sap.security.saml2.lib.jaxb.xmldsig.SignatureType;
import com.sap.security.saml2.lib.protocols.SAML2ProtocolTokenBase;
import com.sap.security.saml2.lib.xmlsecurity.XMLSignature;
import com.sap.security.saml2.lib.xmlsecurity.XMLSignatureManager;
import com.sap.tc.logging.Location;
import java.io.StringWriter;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.datatype.XMLGregorianCalendar;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class SAML2ResponseBaseJxbImpl
extends SAML2ProtocolTokenBase
implements SAML2ResponseBase {
    private Element domElement;
    protected String xmlResponse;
    private PrivateKey signPrivateKey;
    private Certificate signCert;
    private boolean isSigned;
    private Element domForSecOperations;
    private String xmlRepresentationForTrace;
    private String signature;
    private SAML2SignatureKeyInfo signatureKeyInfo;
    private StatusResponseType jaxbResponse;
    private String digestAlgorithm;
    private static final Location LOCATION = Location.getLocation(SAML2ResponseBaseJxbImpl.class);

    @Override
    public void setDigestAlgorithm(String digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
    }

    protected SAML2ResponseBaseJxbImpl(StatusResponseType jaxbResponse, Element domForSecOperations) throws SAML2Exception {
        if (jaxbResponse == null) {
            throw new SAML2Exception("Invalid Response type jaxbResponse: " + jaxbResponse);
        }
        this.jaxbResponse = jaxbResponse;
        this.domForSecOperations = domForSecOperations;
        this.setMode(4);
    }

    protected SAML2ResponseBaseJxbImpl(Element responseElement, StatusResponseType jaxbResponse) throws SAML2Exception {
        if (responseElement == null) {
            throw new SAML2Exception("Invalid SAML response: " + responseElement);
        }
        if (jaxbResponse == null) {
            throw new SAML2Exception("Invalid Response type jaxbResponse: " + jaxbResponse);
        }
        this.jaxbResponse = jaxbResponse;
        this.domElement = responseElement;
        this.setMode(4);
    }

    protected SAML2ResponseBaseJxbImpl(String xmlResponse, StatusResponseType jaxbResponse) throws SAML2Exception {
        if (xmlResponse == null || xmlResponse.length() < 1) {
            throw new SAML2Exception("Invalid SAML response: " + xmlResponse);
        }
        if (jaxbResponse == null) {
            throw new SAML2Exception("Invalid Response type jaxbResponse: " + jaxbResponse);
        }
        this.jaxbResponse = jaxbResponse;
        this.xmlResponse = xmlResponse;
        this.setMode(4);
    }

    protected SAML2ResponseBaseJxbImpl(String id, String topLevelStatusCode, String samlVersion, Date issueInstant, StatusResponseType jaxbResponse) throws SAML2Exception {
        if (jaxbResponse == null) {
            throw new SAML2Exception("Invalid Response type jaxbResponse: " + jaxbResponse);
        }
        this.jaxbResponse = jaxbResponse;
        jaxbResponse.setID(id);
        com.sap.security.saml2.lib.jaxb.protocol.ObjectFactory factory = new com.sap.security.saml2.lib.jaxb.protocol.ObjectFactory();
        StatusCodeType statusCode = factory.createStatusCodeType();
        statusCode.setValue(topLevelStatusCode);
        StatusType status = factory.createStatusType();
        status.setStatusCode(statusCode);
        this.jaxbResponse.setStatus(status);
        if (samlVersion != null) {
            jaxbResponse.setVersion(samlVersion);
        } else {
            jaxbResponse.setVersion("2.0");
        }
        if (issueInstant != null) {
            XMLGregorianCalendar xmlCal = SAML2Utils.convertDateToXMLGregorianCalendar(issueInstant);
            jaxbResponse.setIssueInstant(xmlCal);
        }
        this.setMode(2);
    }

    @Override
    public String getConsent() {
        return this.jaxbResponse.getConsent();
    }

    @Override
    public String getDestination() {
        return this.jaxbResponse.getDestination();
    }

    @Override
    public List<AnyType> getExtensions() {
        ArrayList<AnyType> result = new ArrayList<AnyType>();
        ExtensionsType extensions = this.jaxbResponse.getExtensions();
        List<Object> any = extensions.getAny();
        if (any != null) {
            for (Object object : any) {
                AnyTypeImpl anyType = null;
                try {
                    if (object instanceof Element) {
                        anyType = new AnyTypeImpl((Element)object);
                    } else if (object instanceof JAXBElement) {
                        anyType = new AnyTypeImpl((JAXBElement)object);
                    } else {
                        LOCATION.debugT("Unexpected AnyType object has been found: " + object);
                    }
                }
                catch (Exception e) {
                    LOCATION.debugT("Failed to create AnyType from the object: " + object + ". Reason: " + e);
                }
                if (anyType == null) continue;
                result.add(anyType);
            }
        }
        return result;
    }

    @Override
    public String getID() {
        return this.jaxbResponse.getID();
    }

    @Override
    public String getInResponseTo() {
        return this.jaxbResponse.getInResponseTo();
    }

    @Override
    public Date getIssueInstant() {
        Date date = SAML2Utils.convertXMLGregorianCalendarToDate(this.jaxbResponse.getIssueInstant());
        return date;
    }

    @Override
    public SAML2NameID getIssuer() {
        NameIDType issuer = this.jaxbResponse.getIssuer();
        if (issuer != null) {
            return new SAML2NameIDJxbImpl(issuer);
        }
        return null;
    }

    @Override
    public String getSecondLevelStatusCode() {
        StatusCodeType secondLevelStatusCodeType;
        StatusCodeType topLevelStatusCode;
        StatusType status = this.jaxbResponse.getStatus();
        if (status != null && (topLevelStatusCode = status.getStatusCode()) != null && (secondLevelStatusCodeType = topLevelStatusCode.getStatusCode()) != null) {
            return secondLevelStatusCodeType.getValue();
        }
        return null;
    }

    @Override
    public String getSignature() {
        return this.signature;
    }

    @Override
    public List<AnyType> getStatusDetail() {
        List<Object> anyTypes;
        StatusDetailType details;
        ArrayList<AnyType> result = new ArrayList<AnyType>();
        StatusType status = this.jaxbResponse.getStatus();
        if (status != null && (details = status.getStatusDetail()) != null && (anyTypes = details.getAny()) != null) {
            for (Object object : anyTypes) {
                AnyTypeImpl anyType = null;
                try {
                    if (object instanceof Element) {
                        anyType = new AnyTypeImpl((Element)object);
                    } else if (object instanceof JAXBElement) {
                        anyType = new AnyTypeImpl((JAXBElement)object);
                    } else {
                        LOCATION.debugT("Unexpected AnyType object has been found: " + object);
                    }
                }
                catch (Exception e) {
                    LOCATION.debugT("Failed to create AnyType from the object: " + object + ". Reason: " + e);
                }
                if (anyType == null) continue;
                result.add(anyType);
            }
        }
        return result;
    }

    @Override
    public String getStatusMessage() {
        StatusType status = this.jaxbResponse.getStatus();
        if (status != null) {
            return status.getStatusMessage();
        }
        return null;
    }

    @Override
    public String getTopLevelStatusCode() {
        StatusCodeType topLevelStatusCode;
        StatusType status = this.jaxbResponse.getStatus();
        if (status != null && (topLevelStatusCode = status.getStatusCode()) != null) {
            return topLevelStatusCode.getValue();
        }
        return null;
    }

    @Override
    public String getVersion() {
        return this.jaxbResponse.getVersion();
    }

    @Override
    public void setConsent(String uri) {
        this.jaxbResponse.setConsent(uri);
    }

    @Override
    public void setDestination(String uri) {
        this.jaxbResponse.setDestination(uri);
    }

    @Override
    public void setExtensions(List<AnyType> extensions) {
        if (extensions == null) {
            return;
        }
        com.sap.security.saml2.lib.jaxb.protocol.ObjectFactory factory = new com.sap.security.saml2.lib.jaxb.protocol.ObjectFactory();
        ExtensionsType jaxbExtensions = factory.createExtensionsType();
        for (AnyType anyType : extensions) {
            jaxbExtensions.getAny().add(anyType.getContent());
        }
        this.jaxbResponse.setExtensions(jaxbExtensions);
    }

    @Override
    public void setInResponseTo(String inResponseTo) {
        this.jaxbResponse.setInResponseTo(inResponseTo);
    }

    @Override
    public void setIssuer(SAML2NameID issuer) {
        if (issuer != null) {
            NameIDType iss = issuer.convertToSAMLGenerator();
            this.jaxbResponse.setIssuer(iss);
        }
    }

    @Override
    public void setSecondLevelStatusCode(String code) {
        if (code == null) {
            return;
        }
        StatusCodeType secondLevel = new com.sap.security.saml2.lib.jaxb.protocol.ObjectFactory().createStatusCodeType();
        secondLevel.setValue(code);
        StatusCodeType topLevel = this.jaxbResponse.getStatus().getStatusCode();
        topLevel.setStatusCode(secondLevel);
    }

    @Override
    public void setStatusDetail(List<AnyType> statusDetail) {
        if (statusDetail == null) {
            return;
        }
        StatusDetailType statusDetailType = new com.sap.security.saml2.lib.jaxb.protocol.ObjectFactory().createStatusDetailType();
        for (AnyType anyType : statusDetail) {
            statusDetailType.getAny().add(anyType.getContent());
        }
        this.jaxbResponse.getStatus().setStatusDetail(statusDetailType);
    }

    @Override
    public void setStatusMessage(String statusMessage) {
        this.jaxbResponse.getStatus().setStatusMessage(statusMessage);
    }

    @Override
    public String generate() throws SAML2Exception {
        String result;
        if (this.getMode() == 8) {
            return this.xmlResponse;
        }
        if (this.getMode() != 2) {
            throw new SAML2Exception("Wrong mode. Generate can be executed only if you initialized this with constructor (String, String, String, Date)");
        }
        if (this.jaxbResponse.getIssueInstant() == null) {
            this.setIssueInstantToCurrentTime();
        }
        try {
            if (this.isSigningScheduled()) {
                SignatureType dummySignature = this.createDummySignature();
                this.jaxbResponse.setSignature(dummySignature);
                Element parent = this.marshalToDOM().getDocumentElement();
                result = this.sign(parent);
            } else {
                result = this.marshalToXMLText();
            }
        }
        catch (Exception e) {
            throw new SAML2Exception("SAML creation failed.", e);
        }
        this.xmlResponse = result;
        this.setMode(8);
        return result;
    }

    protected void setIssueInstantToCurrentTime() throws SAML2Exception {
        XMLGregorianCalendar xmlCal = SAML2Utils.currentXMLGregorianCalendar();
        this.jaxbResponse.setIssueInstant(xmlCal);
    }

    protected String sign(Element parent) throws SAML2Exception {
        XMLSignature signer = XMLSignatureManager.getXMLSignatureInstance();
        StringWriter signedXML = new StringWriter(2000);
        this.signature = signer.sign(parent, this.getID(), this.signPrivateKey, this.signCert, signedXML, this.digestAlgorithm);
        String result = signedXML.toString();
        this.isSigned = true;
        return result;
    }

    @Override
    public boolean isSigned() {
        return this.isSigned;
    }

    @Override
    public SAML2SignatureKeyInfo getSignatureKeyInfo() {
        return this.signatureKeyInfo;
    }

    @Override
    public void parse() throws SAML2Exception {
        if (this.getMode() == 16) {
            return;
        }
        if (this.getMode() != 4) {
            throw new SAML2Exception("Wrong mode. Parse can be executed only if you initialized this either with constructor(String) or constructor(Element)");
        }
        try {
            if (this.domElement != null) {
                this.jaxbResponse = this.unmarshalFromDOM(this.domElement);
            } else if (this.xmlResponse != null) {
                this.jaxbResponse = this.unmarshalFromXMLText(this.xmlResponse);
            }
            SignatureType jaxbSignature = this.jaxbResponse.getSignature();
            if (jaxbSignature != null) {
                this.isSigned = true;
                KeyInfoType jaxbKeyInfo = jaxbSignature.getKeyInfo();
                if (jaxbKeyInfo != null) {
                    this.signatureKeyInfo = new SAML2SignatureKeyInfoImpl(jaxbKeyInfo);
                }
            }
        }
        catch (Exception e) {
            throw new SAML2Exception("SAML parsing failed.", e);
        }
        this.setMode(16);
    }

    protected abstract String marshalToXMLText() throws SAML2Exception;

    protected abstract Document marshalToDOM() throws SAML2Exception;

    protected abstract StatusResponseType unmarshalFromDOM(Element var1) throws SAML2Exception;

    protected abstract StatusResponseType unmarshalFromXMLText(String var1) throws SAML2Exception;

    @Override
    public void sign(PrivateKey key) throws SAML2Exception {
        this.sign(key, null);
    }

    @Override
    public void sign(PrivateKey key, Certificate cert) throws SAML2Exception {
        if (key == null) {
            LOCATION.debugT("Attempt to sign the response with null PrivateKey");
            throw new SAML2Exception("Signing cannot be proceeded without PrivateKey. key: " + key);
        }
        if (this.getMode() == 4 || this.getMode() == 16) {
            throw new SAML2Exception("Wrong mode. Signing does not make sense for parsed response.");
        }
        if (this.getMode() != 2) {
            throw new SAML2Exception("Wrong mode. Signing is not possible after response generation.");
        }
        this.signPrivateKey = key;
        this.signCert = cert;
        this.setSigningScheduled(true);
    }

    @Override
    public void validateData() throws SAML2Exception {
    }

    @Override
    public void validateSignature(Certificate senderCert) throws SAML2Exception {
        Element parent;
        if (this.getMode() != 16) {
            throw new SAML2Exception("Wrong mode. To validate the signature the token should be parsed first.");
        }
        if (!this.isSigned()) {
            throw new SAML2Exception("The response is not signed.");
        }
        try {
            parent = this.getDomForSecOperations();
        }
        catch (Exception e) {
            throw new SAML2Exception("Failed to check signature.", e);
        }
        XMLSignature verifier = XMLSignatureManager.getXMLSignatureInstance();
        if (!verifier.verify(parent, senderCert)) {
            if (LOCATION.beWarning()) {
                LOCATION.warningT("Signature verification for Response with id: " + this.getID() + " failed.");
            }
            throw new SAML2Exception("Signature not valid!");
        }
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Signature for Response with id: " + this.getID() + " verified successfuly.");
        }
    }

    protected Element getDomForSecOperations() throws SAML2Exception {
        Element result;
        if (this.domForSecOperations != null) {
            return this.domForSecOperations;
        }
        if (this.domElement != null) {
            result = this.domForSecOperations = this.domElement;
        } else if (this.xmlResponse != null) {
            Document doc = SAML2Utils.transformXMLtoDOM(this.xmlResponse);
            result = this.domForSecOperations = doc.getDocumentElement();
        } else {
            Document doc = this.marshalToDOM();
            result = this.domForSecOperations = doc.getDocumentElement();
        }
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(500);
        builder.append("SAML token mode: ").append(this.getMode()).append("\n");
        if (this.xmlRepresentationForTrace == null) {
            this.obtainXMLRepresenationForTrace();
        }
        if (this.xmlRepresentationForTrace != null) {
            builder.append("XML representation:\n").append(this.xmlRepresentationForTrace);
        } else {
            builder.append("The token is still not generated and does not have XML representation");
        }
        return builder.toString();
    }

    @Override
    public String getXMLRepresentation() {
        if (this.xmlRepresentationForTrace == null) {
            this.obtainXMLRepresenationForTrace();
        }
        return this.xmlRepresentationForTrace;
    }

    private void obtainXMLRepresenationForTrace() {
        if (this.xmlResponse != null) {
            this.xmlRepresentationForTrace = this.xmlResponse.replaceAll("\\>\\<", ">\n<");
        } else if (this.domElement != null) {
            this.xmlRepresentationForTrace = SAML2Utils.transformDOMForTrace(this.domElement);
        } else if (this.domForSecOperations != null) {
            this.xmlRepresentationForTrace = SAML2Utils.transformDOMForTrace(this.domForSecOperations);
        }
    }

    protected StatusResponseType getJaxbResponseBase() {
        return this.jaxbResponse;
    }

    protected SignatureType createDummySignature() {
        SignatureType dummySignature = new ObjectFactory().createSignatureType();
        return dummySignature;
    }
}

