/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.lib.protocols;

import com.sap.security.saml2.lib.assertions.SAML2AssertionJxbImpl;
import com.sap.security.saml2.lib.assertions.SAML2EncryptedAssertionJxbImpl;
import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.common.SAML2JAXBUtils;
import com.sap.security.saml2.lib.common.SAML2Utils;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2Assertion;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2EncryptedAssertion;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2Response;
import com.sap.security.saml2.lib.jaxb.assertion.AssertionType;
import com.sap.security.saml2.lib.jaxb.assertion.EncryptedElementType;
import com.sap.security.saml2.lib.jaxb.protocol.ObjectFactory;
import com.sap.security.saml2.lib.jaxb.protocol.ResponseType;
import com.sap.security.saml2.lib.jaxb.protocol.StatusResponseType;
import com.sap.security.saml2.lib.jaxb.xmldsig.SignatureType;
import com.sap.security.saml2.lib.protocols.SAML2ResponseBaseJxbImpl;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SAML2ResponseJxbImpl
extends SAML2ResponseBaseJxbImpl
implements SAML2Response {
    private List<SAML2Assertion> assertions;
    private List<SAML2EncryptedAssertion> encryptedAssertions;
    private static final Location LOCATION = Location.getLocation(SAML2ResponseJxbImpl.class);

    public SAML2ResponseJxbImpl(ResponseType jaxbResponse, Element domForSecOperations) throws SAML2Exception {
        super(jaxbResponse, domForSecOperations);
    }

    public SAML2ResponseJxbImpl(Element responseElement) throws SAML2Exception {
        super(responseElement, (StatusResponseType)new ObjectFactory().createResponseType());
    }

    public SAML2ResponseJxbImpl(String xmlResponse) throws SAML2Exception {
        super(xmlResponse, (StatusResponseType)new ObjectFactory().createResponseType());
    }

    public SAML2ResponseJxbImpl(String id, String topLevelStatusCode, String samlVersion, Date issueInstant, List assertions) throws SAML2Exception {
        super(id, topLevelStatusCode, samlVersion, issueInstant, new ObjectFactory().createResponseType());
        if (assertions != null) {
            this.assertions = new ArrayList<SAML2Assertion>();
            this.encryptedAssertions = new ArrayList<SAML2EncryptedAssertion>();
            for (Object assertion : assertions) {
                if (assertion instanceof SAML2Assertion) {
                    this.assertions.add((SAML2Assertion)assertion);
                    AssertionType jaxbAssertion = ((SAML2AssertionJxbImpl)assertion).convertToSAMLGenerator();
                    if (jaxbAssertion == null) continue;
                    this.getJaxbResponse().getAssertionOrEncryptedAssertion().add(jaxbAssertion);
                    continue;
                }
                if (assertion instanceof SAML2EncryptedAssertion) {
                    this.encryptedAssertions.add((SAML2EncryptedAssertion)assertion);
                    EncryptedElementType jaxbEncryptedAssertion = ((SAML2EncryptedAssertionJxbImpl)assertion).convertToSAMLGenerator();
                    if (jaxbEncryptedAssertion == null) continue;
                    this.getJaxbResponse().getAssertionOrEncryptedAssertion().add(jaxbEncryptedAssertion);
                    continue;
                }
                throw new SAML2Exception("Invalid assertion found: " + assertion + "Must be either instance of SAML2Assertion or SAML2EncryptedAssertion types.");
            }
        }
    }

    @Override
    public String generate() throws SAML2Exception {
        String result;
        if (this.getMode() == 8) {
            return this.xmlResponse;
        }
        if (this.getMode() != 2) {
            throw new SAML2Exception("Wrong mode. Generate can be executed only if you initialized this with constructor (String, String, String, Date)");
        }
        if (this.getJaxbResponse().getIssueInstant() == null) {
            this.setIssueInstantToCurrentTime();
        }
        boolean someAssertionReplaced = false;
        Element responseElement = null;
        try {
            if (this.isSigningScheduled()) {
                SignatureType dummySignature = this.createDummySignature();
                this.getJaxbResponse().setSignature(dummySignature);
            }
            Document doc = this.marshalToDOM();
            responseElement = doc.getDocumentElement();
            if (this.assertions != null) {
                NodeList nl = responseElement.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "Assertion");
                int index = 0;
                for (SAML2Assertion assertion : this.assertions) {
                    if (assertion.isSigned()) {
                        Node oldElement = nl.item(index);
                        Node parent = oldElement.getParentNode();
                        Element newElement = ((SAML2AssertionJxbImpl)assertion).getSignedAssertion();
                        Node replacing = doc.importNode(newElement, true);
                        if (LOCATION.beDebug()) {
                            String oldElementAsString = SAML2Utils.transformDOMForTrace(oldElement);
                            String newElementAsString = SAML2Utils.transformDOMForTrace(replacing);
                            LOCATION.debugT("The assertion \"{0}\" will be replaced with signed assertion \"{1}\"", new Object[]{oldElementAsString, newElementAsString});
                        }
                        parent.replaceChild(replacing, oldElement);
                        someAssertionReplaced = true;
                    }
                    ++index;
                }
            }
        }
        catch (Exception e) {
            throw new SAML2Exception("Failed to replace the signed assertions", e);
        }
        try {
            if (this.isSigningScheduled()) {
                if (someAssertionReplaced) {
                    result = this.sign(responseElement);
                } else {
                    Element parent = this.marshalToDOM().getDocumentElement();
                    result = this.sign(parent);
                }
            } else {
                result = someAssertionReplaced ? SAML2Utils.transformDOMtoXML(responseElement) : this.marshalToXMLText();
            }
        }
        catch (Exception e) {
            throw new SAML2Exception("SAML creation failed.", e);
        }
        this.xmlResponse = result;
        this.setMode(8);
        return result;
    }

    @Override
    public void parse() throws SAML2Exception {
        super.parse();
        List<Object> jaxbAssertions = this.getJaxbResponse().getAssertionOrEncryptedAssertion();
        if (jaxbAssertions != null) {
            this.assertions = new ArrayList<SAML2Assertion>();
            this.encryptedAssertions = new ArrayList<SAML2EncryptedAssertion>();
            ArrayList<Element> assertionElements = new ArrayList<Element>();
            try {
                Element domForSecOperations = this.getDomForSecOperations();
                if (!"urn:oasis:names:tc:SAML:2.0:protocol".equals(domForSecOperations.getNamespaceURI()) || !"Response".equals(domForSecOperations.getLocalName())) {
                    throw new SAML2Exception("Element is not a SAML 2.0 Response: " + domForSecOperations);
                }
                NodeList nl = domForSecOperations.getChildNodes();
                int i = 0;
                while (i < nl.getLength()) {
                    Element element;
                    Node node = nl.item(i);
                    if (node instanceof Element && "urn:oasis:names:tc:SAML:2.0:assertion".equals((element = (Element)node).getNamespaceURI()) && "Assertion".equals(element.getLocalName())) {
                        assertionElements.add(element);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                throw new SAML2Exception("Failed to obtain the Assertion elements", e);
            }
            for (Element assertionElement : assertionElements) {
                this.assertions.add(new SAML2AssertionJxbImpl(assertionElement));
            }
            for (Object object : jaxbAssertions) {
                if (!(object instanceof EncryptedElementType)) continue;
                this.encryptedAssertions.add(new SAML2EncryptedAssertionJxbImpl((EncryptedElementType)object));
            }
        }
    }

    @Override
    protected Document marshalToDOM() throws SAML2Exception {
        JAXBElement<ResponseType> res = new ObjectFactory().createResponse(this.getJaxbResponse());
        Document doc = SAML2JAXBUtils.marshalProtocolTokenToDOM(res);
        return doc;
    }

    @Override
    protected String marshalToXMLText() throws SAML2Exception {
        JAXBElement<ResponseType> res = new ObjectFactory().createResponse(this.getJaxbResponse());
        String result = SAML2JAXBUtils.marshalProtocolTokenToText(res);
        return result;
    }

    @Override
    protected StatusResponseType unmarshalFromDOM(Element parent) throws SAML2Exception {
        JAXBElement jaxbElement = SAML2JAXBUtils.unmarshalProtocolTokenFromDOM(parent);
        Object jaxbValue = jaxbElement.getValue();
        if (jaxbValue instanceof ResponseType) {
            return (ResponseType)jaxbValue;
        }
        throw new SAML2Exception("Invalid protocol type. Must be \"Response\".");
    }

    @Override
    protected StatusResponseType unmarshalFromXMLText(String xml) throws SAML2Exception {
        JAXBElement jaxbElement = SAML2JAXBUtils.unmarshalProtocolTokenFromXMLText(xml);
        Object jaxbValue = jaxbElement.getValue();
        if (jaxbValue instanceof ResponseType) {
            return (ResponseType)jaxbValue;
        }
        throw new SAML2Exception("Invalid protocol type. Must be \"Response\".");
    }

    @Override
    public List<SAML2Assertion> getAssertions() {
        return this.assertions;
    }

    @Override
    public List<SAML2EncryptedAssertion> getEncryptedAssertions() {
        return this.encryptedAssertions;
    }

    protected ResponseType getJaxbResponse() {
        return (ResponseType)super.getJaxbResponseBase();
    }
}

