/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.lib.resources;

import com.sap.tc.logging.Location;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class SAML2ResourceBundle {
    private static final Location LOCATION = Location.getLocation(SAML2ResourceBundle.class);
    private static final SAML2ResourceBundle INSTANCE = new SAML2ResourceBundle();
    private static final Locale DEFAULT_LOCALE = Locale.getDefault();
    private static final ClassLoader LOADER = SAML2ResourceBundle.class.getClassLoader();
    private static final String SAML2_RESOURCES_PROPERTIES_BASE_NAME = "com.sap.security.saml2.lib.resources.SAML2Resources";
    public static final String KEY_POST_MSG = "POST_MSG";
    public static final String KEY_POST_MSG_NO_SCRIPT = "POST_MSG_NO_SCRIPT";
    public static final String KEY_POST_BUTTON_CONTINUE = "POST_BUTTON_CONTINUE";

    public static SAML2ResourceBundle getInstance() {
        return INSTANCE;
    }

    private SAML2ResourceBundle() {
    }

    public String getResource(String key) {
        return this.getResource(key, null);
    }

    public String getResource(String key, Locale locale) {
        ResourceBundle resourceBundle;
        if (locale == null) {
            locale = DEFAULT_LOCALE;
        }
        try {
            resourceBundle = ResourceBundle.getBundle(SAML2_RESOURCES_PROPERTIES_BASE_NAME, locale, LOADER);
        }
        catch (MissingResourceException e) {
            LOCATION.traceThrowableT(400, "SAML2 Resource bundle with base name: [{0}] not found", new Object[]{SAML2_RESOURCES_PROPERTIES_BASE_NAME}, (Throwable)e);
            return "";
        }
        try {
            return resourceBundle.getString(key);
        }
        catch (MissingResourceException e) {
            LOCATION.traceThrowableT(400, "Resource: [{0}] not found in SAML2 resources with base name: [{1}]", new Object[]{key, SAML2_RESOURCES_PROPERTIES_BASE_NAME}, (Throwable)e);
            return "";
        }
    }
}

