/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.lib.services;

import com.sap.security.saml2.lib.common.SAML2Utils;
import com.sap.security.saml2.lib.interfaces.services.CDCReadingService;
import com.sap.tc.logging.Location;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class CDCReadingServiceImpl
implements CDCReadingService {
    protected static final String ENCODING = "UTF-8";
    protected static final String CDC_DELIMITER = " ";
    private static final Location LOCATION = Location.getLocation(CDCReadingServiceImpl.class);

    @Override
    public List<String> extractVisitedProviders(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        return this.extractVisitedProviders(cookies);
    }

    @Override
    public List<String> extractVisitedProviders(Cookie[] cookies) {
        if (cookies == null || cookies.length < 1) {
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Could not extract visited Identity Providers, because there aren't any cookies to check");
            }
            return new ArrayList<String>();
        }
        Cookie cdc = null;
        Cookie[] cookieArray = cookies;
        int n = cookies.length;
        int n2 = 0;
        while (n2 < n) {
            Cookie cookie = cookieArray[n2];
            if ("_saml_idp".equals(cookie.getName())) {
                cdc = cookie;
                break;
            }
            ++n2;
        }
        if (cdc == null) {
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Could not extract visited IdentityProvider, because there isn't common domain cookie");
            }
            return new ArrayList<String>();
        }
        String cookieValue = cdc.getValue();
        return this.extractVisitedProviders(cookieValue);
    }

    @Override
    public List<String> extractVisitedProviders(String cookieValue) {
        ArrayList<String> result = new ArrayList<String>();
        List<String> cookieEntries = this.tokenizeCDCValue(cookieValue, null);
        ListIterator<String> iterator = cookieEntries.listIterator(cookieEntries.size());
        while (iterator.hasPrevious()) {
            String cookieEntry = iterator.previous();
            try {
                String decodedCookieEntry = SAML2Utils.decodeBase64AsString(cookieEntry);
                result.add(decodedCookieEntry);
            }
            catch (Exception e) {
                if (!LOCATION.beWarning()) continue;
                LOCATION.warningT("Could not Base64 decode the cookie entry: " + cookieEntry, e.toString());
            }
        }
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Visited provider list: " + result);
        }
        return result;
    }

    protected List<String> tokenizeCDCValue(String cookieValue, String omitElement) {
        ArrayList<String> result;
        block7: {
            result = new ArrayList<String>();
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Common domain cookie value: " + cookieValue);
            }
            if (cookieValue != null) {
                try {
                    String decodedValue = URLDecoder.decode(cookieValue, ENCODING);
                    StringTokenizer tokenizer = new StringTokenizer(decodedValue, CDC_DELIMITER);
                    while (tokenizer.hasMoreTokens()) {
                        String currentToken = tokenizer.nextToken();
                        if (currentToken == null || currentToken.length() <= 0) continue;
                        if (currentToken.equals(omitElement)) {
                            if (!LOCATION.beDebug()) continue;
                            LOCATION.debugT("Remove cookie domain entry: " + currentToken + ". It will be added to end of list");
                            continue;
                        }
                        result.add(currentToken);
                    }
                }
                catch (UnsupportedEncodingException e) {
                    if (!LOCATION.beWarning()) break block7;
                    LOCATION.warningT("Could not decode cookie value: " + cookieValue, e.toString());
                }
            }
        }
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Common domain cookie entries: " + result);
        }
        return result;
    }
}

