/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.lib.services;

import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.common.SAML2Utils;
import com.sap.security.saml2.lib.interfaces.services.CDCWritingService;
import com.sap.security.saml2.lib.services.CDCReadingServiceImpl;
import com.sap.tc.logging.Location;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CDCWritingServiceImpl
extends CDCReadingServiceImpl
implements CDCWritingService {
    private static final Location LOCATION = Location.getLocation(CDCWritingServiceImpl.class);
    private String idpName;
    private String idpNameBase64Encoded;
    private String configuredCookieDomain;
    private int maxAge = -1;
    private int domainRelaxLevel = 1;

    public CDCWritingServiceImpl(String idpName) throws SAML2Exception {
        if (idpName == null || idpName.length() < 1) {
            throw new SAML2Exception("Invalid IdP name: " + idpName);
        }
        this.idpName = idpName;
        this.idpNameBase64Encoded = SAML2Utils.encodeBase64AsString(idpName);
    }

    @Override
    public void addProvider(HttpServletRequest request, HttpServletResponse response) throws SAML2Exception {
        LOCATION.infoT("Trying to set common domain cookie for IdP introduction.");
        String domain = this.getSAML2CookieDomain(request);
        if (domain == null || domain.length() < 1) {
            if (LOCATION.beInfo()) {
                LOCATION.infoT("Cannot set domain for SAML2 cookie. Check configuration of domain and/or relax level.");
            }
        } else {
            List<String> providersBase64Encoded = new ArrayList<String>();
            Cookie[] cookies = request.getCookies();
            if (cookies != null) {
                Cookie[] cookieArray = cookies;
                int n = cookies.length;
                int n2 = 0;
                while (n2 < n) {
                    Cookie cookie = cookieArray[n2];
                    if ("_saml_idp".equals(cookie.getName())) {
                        String cookieValue = cookie.getValue();
                        providersBase64Encoded = this.tokenizeCDCValue(cookieValue, this.idpNameBase64Encoded);
                        break;
                    }
                    ++n2;
                }
            }
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Adding own IdP ID {0}.", new Object[]{this.idpNameBase64Encoded});
            }
            providersBase64Encoded.add(this.idpNameBase64Encoded);
            String newCookieValue = this.createCommonDomainCookieValue(providersBase64Encoded);
            if (LOCATION.beDebug()) {
                LOCATION.debugT("New cookie value: {0}", new Object[]{newCookieValue});
            }
            Cookie newCookie = new Cookie("_saml_idp", String.valueOf(newCookieValue) + "; HttpOnly");
            newCookie.setPath("/");
            newCookie.setSecure(true);
            newCookie.setMaxAge(this.maxAge);
            domain = "." + domain;
            if (LOCATION.beInfo()) {
                LOCATION.infoT("Using DNS domain {0} for common domain cookie.", new Object[]{domain});
            }
            newCookie.setDomain(domain);
            response.addCookie(newCookie);
            if (LOCATION.beInfo()) {
                LOCATION.infoT("Common domain cookie has been set to {0} for domain {1} with a lifetime of {2} seconds.", new Object[]{newCookieValue, domain, this.maxAge});
            }
        }
    }

    private String createCommonDomainCookieValue(List<String> providersBase64Encoded) throws SAML2Exception {
        StringBuilder builder = new StringBuilder(100);
        for (String provider : providersBase64Encoded) {
            builder.append(provider);
            builder.append(" ");
        }
        String value = builder.toString().trim();
        try {
            String urlEncoded = URLEncoder.encode(value, "UTF-8");
            return urlEncoded;
        }
        catch (UnsupportedEncodingException e) {
            throw new SAML2Exception("Could not encode the cookie value" + value, e);
        }
    }

    @Override
    public String getCommonDomainName() {
        return this.configuredCookieDomain;
    }

    @Override
    public int getDomainRelaxationLevel() {
        return this.domainRelaxLevel;
    }

    @Override
    public int getMaxAge() {
        return this.maxAge;
    }

    @Override
    public void setCommonDomainName(String domain) {
        if (domain != null && domain.length() > 0) {
            this.configuredCookieDomain = domain;
        } else if (LOCATION.beDebug()) {
            LOCATION.debugT("Common domain name is not changed because of not valid domain parameter: " + domain);
        }
    }

    @Override
    public void setDomainRelaxationLevel(int i) {
        if (i > 0) {
            this.domainRelaxLevel = i;
        } else if (LOCATION.beDebug()) {
            LOCATION.debugT("Domain relaxation level is not changed because of not valid parameter: " + i);
        }
    }

    @Override
    public void setMaxAge(int i) {
        this.maxAge = i;
    }

    private String getSAML2CookieDomain(HttpServletRequest httpRequest) throws SAML2Exception {
        String cookieDomain;
        LOCATION.infoT("Determining DNS domain for common domain cookie.");
        String requestHostname = httpRequest.getServerName();
        if (this.configuredCookieDomain == null || this.configuredCookieDomain.length() < 1) {
            if (LOCATION.beDebug()) {
                LOCATION.debugT("No cookie domain configured. Trying to use domain {0} from HTTP request. Configured domain relaxation level: {1}", new Object[]{requestHostname, this.domainRelaxLevel});
            }
            cookieDomain = this.extractDomainName(requestHostname);
        } else {
            if (LOCATION.beInfo()) {
                LOCATION.infoT("Using configured cookie domain {0}.", new Object[]{this.configuredCookieDomain});
            }
            cookieDomain = this.configuredCookieDomain;
            if (!requestHostname.endsWith(this.configuredCookieDomain) && LOCATION.beInfo()) {
                LOCATION.infoT("Note: The determinated domain {0} for the common domain cookie does not match the FQDN {1} from the HTTP request.", new Object[]{cookieDomain, requestHostname});
            }
        }
        return cookieDomain;
    }

    private String extractDomainName(String requestHostname) {
        if (requestHostname.charAt(0) == '.') {
            requestHostname = requestHostname.substring(1);
        }
        if (SAML2Utils.isIPAddress(requestHostname)) {
            LOCATION.infoT("Hostname from HTTP request is an IP address. Common domain cookie will not be set.");
            return null;
        }
        int firstDotPos = requestHostname.indexOf(46);
        if (firstDotPos < 0) {
            LOCATION.infoT("Hostname from HTTP request is a plain hostname without domain part (i.e. no FQDN). Common domain cookie will not be set.");
            return null;
        }
        ArrayList<Integer> requestHostnameDotPositions = new ArrayList<Integer>(5);
        int i = 0;
        while (i < requestHostname.length()) {
            if (requestHostname.charAt(i) == '.') {
                requestHostnameDotPositions.add(new Integer(i));
            }
            ++i;
        }
        if (requestHostnameDotPositions.size() < this.domainRelaxLevel) {
            if (LOCATION.beInfo()) {
                LOCATION.infoT("Configured domain relaxation level {0} is too high because it would remove more domain parts from the FQDN {1} than available ({2}). Common domain cookie will not be set.", new Object[]{this.domainRelaxLevel, requestHostname, requestHostnameDotPositions.size()});
            }
            return null;
        }
        int dotPosition = (Integer)requestHostnameDotPositions.get(this.domainRelaxLevel - 1);
        String cookieDomain = requestHostname.substring(dotPosition + 1);
        LOCATION.infoT("Cookie domain calculated based on HTTP request hostname and configured domain relaxation level: {0}", new Object[]{cookieDomain});
        return cookieDomain;
    }
}

