/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.lib.xmlsecurity;

import com.sap.security.saml2.lib.common.SAML2Configuration;
import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.common.SAML2ServicesManager;
import com.sap.tc.logging.Location;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;

public final class CertificateVerifier {
    private static final Location LOCATION = Location.getLocation(CertificateVerifier.class);
    private static final CertificateVerifier INSTANCE = new CertificateVerifier();

    public static final CertificateVerifier getInstance() {
        return INSTANCE;
    }

    private CertificateVerifier() {
    }

    public void verifyCertificate(Certificate cert) throws SAML2Exception {
        if (cert == null) {
            return;
        }
        if (cert instanceof X509Certificate) {
            X509Certificate x509Cert = (X509Certificate)cert;
            if (SAML2Configuration.getInstance().isCheckCertTimeValidity()) {
                try {
                    x509Cert.checkValidity();
                }
                catch (CertificateNotYetValidException e) {
                    throw new SAML2Exception("Certificate is not yet valid (Certificate NotBefore: " + x509Cert.getNotBefore() + ")", e);
                }
                catch (CertificateExpiredException e) {
                    throw new SAML2Exception("Certificate is expired (Certificate NotAfter: " + x509Cert.getNotAfter() + ")", e);
                }
            }
            if (SAML2Configuration.getInstance().isCheckCertRevocStatus()) {
                String profile = SAML2Configuration.getInstance().getCertRevocationProfile();
                if (!SAML2ServicesManager.getInstance().getCertificateRevocationCheckerInstance().isValid(profile, x509Cert)) {
                    throw new SAML2Exception("Certificate is revoked");
                }
            }
        } else if (LOCATION.beDebug()) {
            LOCATION.debugT("Unknown certificate type: {0}. To check time validity and revocation status the certificate should be: {1}", new Object[]{cert.getClass(), X509Certificate.class});
        }
    }
}

