/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.lib.xmlsecurity;

import com.sap.engine.lib.xml.signature.elements.KeyInfo;
import com.sap.engine.lib.xml.signature.encryption.EncryptedKey;
import com.sap.engine.lib.xml.signature.encryption.EncryptedKeyGenerator;
import com.sap.engine.lib.xml.signature.encryption.XMLDecryptor;
import com.sap.engine.lib.xml.signature.encryption.XMLEncryptor;
import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.common.SAML2Utils;
import com.sap.security.saml2.lib.xmlsecurity.XMLEncryption;
import com.sap.tc.logging.Location;
import java.security.Key;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLEncryptionDOM
implements XMLEncryption {
    private static final Location LOCATION = Location.getLocation(XMLEncryptionDOM.class);

    @Override
    public Node encrypt(Element element, Key recipientPublicKey, String xmlencAlgorithmURI) throws SAML2Exception {
        if (element == null) {
            throw new SAML2Exception("The element parameter to encrypt is null");
        }
        if (LOCATION.bePath()) {
            String elementAsString = SAML2Utils.transformDOMForTrace(element);
            LOCATION.entering("encrypt(Element, Key, String)", new Object[]{elementAsString, recipientPublicKey, xmlencAlgorithmURI});
        }
        if (recipientPublicKey == null) {
            throw new SAML2Exception("Invalid recipientPublicKey: " + recipientPublicKey);
        }
        String keyAlgorithm = recipientPublicKey.getAlgorithm();
        if (!("RSA".equals(keyAlgorithm) || "DESede".equals(keyAlgorithm) || "AES".equals(keyAlgorithm))) {
            throw new SAML2Exception("Unsupported \"recipientPublicKey\" algorithm: " + keyAlgorithm);
        }
        try {
            SecretKey symmetricKey = this.generateSymmetricKey(xmlencAlgorithmURI);
            XMLEncryptor encryptor = new XMLEncryptor();
            encryptor.setEncryptionKey((Key)symmetricKey);
            Node result = encryptor.encrypt(element, xmlencAlgorithmURI, false);
            EncryptedKeyGenerator encryptedKeyGenerator = new EncryptedKeyGenerator();
            encryptedKeyGenerator.setShowKeyInfo(false);
            KeyInfo encryptedDataKeyInfo = new KeyInfo(result);
            encryptedKeyGenerator.init(encryptedDataKeyInfo.getDomRepresentation());
            String keyTransportAlgorithmURI = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
            if ("RSA".equals(keyAlgorithm)) {
                keyTransportAlgorithmURI = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
            } else if ("DESede".equals(keyAlgorithm)) {
                keyTransportAlgorithmURI = "http://www.w3.org/2001/04/xmlenc#kw-tripledes";
            } else if ("AES".equals(keyAlgorithm)) {
                keyTransportAlgorithmURI = "http://www.w3.org/2001/04/xmlenc#kw-aes128";
            }
            encryptedKeyGenerator.getEncryptedKey(keyTransportAlgorithmURI, recipientPublicKey, (Key)symmetricKey);
            if (LOCATION.bePath()) {
                String resultAsString = SAML2Utils.transformDOMForTrace(result);
                LOCATION.exiting("encrypt(Element, Key, String)", (Object)resultAsString);
            }
            return result;
        }
        catch (Exception e) {
            throw new SAML2Exception("Failed to encrypt the element: " + element, e);
        }
    }

    @Override
    public Node decrypt(Element encryptedElement, Key recepientPrivateKey) throws SAML2Exception {
        Element encryptedData;
        if (encryptedElement == null) {
            throw new SAML2Exception("The element parameter to decrypt is null");
        }
        if (LOCATION.beDebug()) {
            String elementAsString = SAML2Utils.transformDOMForTrace(encryptedElement);
            LOCATION.debugT("XML to be decrypted:\n{0}", new Object[]{elementAsString});
        }
        if ((encryptedData = (Element)encryptedElement.getFirstChild()) == null) {
            throw new SAML2Exception("There isn't EncryptedData");
        }
        try {
            String secretAlgorithm = this.resolveEncryptionMethod(encryptedData);
            Element encryptedKeyDOM = this.findEncryptedKeyElement(encryptedElement);
            EncryptedKey encryptedKey = new EncryptedKey(encryptedKeyDOM, false);
            EncryptedKeyGenerator encryptedKeyGenerator = new EncryptedKeyGenerator();
            Key symmetricKey = encryptedKeyGenerator.extractKey(encryptedKey, recepientPrivateKey, secretAlgorithm);
            XMLDecryptor decryptor = new XMLDecryptor();
            decryptor.setEncryptionKey(symmetricKey);
            decryptor.restoreOriginalContent(encryptedData);
            Node decryptedNode = encryptedElement.getFirstChild();
            if (LOCATION.beInfo()) {
                String resultAsString = SAML2Utils.transformDOMForTrace(decryptedNode);
                LOCATION.infoT("Decrypted XML:\n{0}", new Object[]{resultAsString});
            }
            return decryptedNode;
        }
        catch (Exception e) {
            String elementAsString = SAML2Utils.transformDOMForTrace(encryptedElement);
            throw new SAML2Exception("Failed to decrypt the element: " + elementAsString, e);
        }
    }

    private Element findEncryptedKeyElement(Element encryptedElement) throws SAML2Exception {
        NodeList nodeList = encryptedElement.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedKey");
        if (nodeList == null || nodeList.getLength() < 1) {
            throw new SAML2Exception("There isn't EncryptedKey element. Encrypted element: " + encryptedElement);
        }
        return (Element)nodeList.item(0);
    }

    private String resolveEncryptionMethod(Element element) {
        NodeList nodeList = element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptionMethod");
        if (nodeList == null || nodeList.getLength() < 1) {
            return null;
        }
        NamedNodeMap nodeMap = nodeList.item(0).getAttributes();
        Node algorithm = nodeMap.getNamedItem("Algorithm");
        if (algorithm instanceof Attr) {
            String encryptionMethod = ((Attr)algorithm).getValue();
            return encryptionMethod;
        }
        return null;
    }

    private SecretKey generateSymmetricKey(String xmlencAlgorithmURI) throws SAML2Exception {
        String generatorAlgorithm;
        Integer keySize = null;
        if ("http://www.w3.org/2001/04/xmlenc#aes128-cbc".equals(xmlencAlgorithmURI)) {
            generatorAlgorithm = "AES";
            keySize = 128;
        } else if ("http://www.w3.org/2001/04/xmlenc#aes192-cbc".equals(xmlencAlgorithmURI)) {
            generatorAlgorithm = "AES";
            keySize = 192;
        } else if ("http://www.w3.org/2001/04/xmlenc#aes256-cbc".equals(xmlencAlgorithmURI)) {
            generatorAlgorithm = "AES";
            keySize = 256;
        } else if ("http://www.w3.org/2001/04/xmlenc#tripledes-cbc".endsWith(xmlencAlgorithmURI)) {
            generatorAlgorithm = "3DES";
        } else {
            throw new SAML2Exception("Not supported XML encryption algorithm: " + xmlencAlgorithmURI);
        }
        try {
            KeyGenerator keyGen = KeyGenerator.getInstance(generatorAlgorithm);
            if (keySize != null) {
                keyGen.init(keySize);
            }
            SecretKey symmetricKey = keyGen.generateKey();
            return symmetricKey;
        }
        catch (Exception e) {
            throw new SAML2Exception("Failed to generate symmetric key for the given XML encryption algorithm: " + xmlencAlgorithmURI, e);
        }
    }
}

