/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.lib.xmlsecurity;

import com.sap.engine.lib.xml.signature.elements.Reference;
import com.sap.engine.lib.xml.signature.generator.SignatureGenerator;
import com.sap.engine.lib.xml.signature.transform.Transformation;
import com.sap.engine.lib.xml.signature.transform.TransformationFactory;
import com.sap.engine.lib.xml.signature.verifier.SignatureVerifier;
import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.common.SAML2Utils;
import com.sap.security.saml2.lib.xmlsecurity.CertificateVerifier;
import com.sap.security.saml2.lib.xmlsecurity.XMLSignature;
import com.sap.tc.logging.Location;
import java.io.OutputStream;
import java.io.Writer;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.ArrayList;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XMLSignatureDOM
implements XMLSignature {
    private static final String DEFAULT_ID_ATTRIBUTE = "ID";
    private static final Location LOCATION = Location.getLocation(XMLSignatureDOM.class);

    @Override
    public String sign(Element parent, String refId, PrivateKey prKey, Certificate cert, Writer result) throws SAML2Exception {
        if (result == null) {
            throw new SAML2Exception("Invalid result Writer: " + result);
        }
        StreamResult stream = new StreamResult(result);
        return this.sign(parent, DEFAULT_ID_ATTRIBUTE, refId, prKey, cert, stream, null);
    }

    @Override
    public String sign(Element parent, String idAttributeName, String refId, PrivateKey prKey, Certificate cert, Writer result) throws SAML2Exception {
        if (result == null) {
            throw new SAML2Exception("Invalid result Writer: " + result);
        }
        StreamResult stream = new StreamResult(result);
        return this.sign(parent, idAttributeName, refId, prKey, cert, stream, null);
    }

    @Override
    public String sign(Element parent, String refId, PrivateKey prKey, Certificate cert, OutputStream result) throws SAML2Exception {
        if (result == null) {
            throw new SAML2Exception("Invalid result OutputStream: " + result);
        }
        StreamResult stream = new StreamResult(result);
        return this.sign(parent, DEFAULT_ID_ATTRIBUTE, refId, prKey, cert, stream, null);
    }

    @Override
    public String sign(Element parent, String idAttributeName, String refId, PrivateKey prKey, Certificate cert, OutputStream result) throws SAML2Exception {
        if (result == null) {
            throw new SAML2Exception("Invalid result OutputStream: " + result);
        }
        StreamResult stream = new StreamResult(result);
        return this.sign(parent, idAttributeName, refId, prKey, cert, stream, null);
    }

    @Override
    public String sign(Element parent, String refId, PrivateKey prKey, Certificate cert, Writer result, String signatureAlgorithm) throws SAML2Exception {
        if (result == null) {
            throw new SAML2Exception("Invalid result Writer: " + result);
        }
        StreamResult stream = new StreamResult(result);
        return this.sign(parent, DEFAULT_ID_ATTRIBUTE, refId, prKey, cert, stream, signatureAlgorithm);
    }

    @Override
    public String sign(Element parent, String idAttributeName, String refId, PrivateKey prKey, Certificate cert, Writer result, String signatureAlgorithm) throws SAML2Exception {
        if (result == null) {
            throw new SAML2Exception("Invalid result Writer: " + result);
        }
        StreamResult stream = new StreamResult(result);
        return this.sign(parent, idAttributeName, refId, prKey, cert, stream, signatureAlgorithm);
    }

    @Override
    public String sign(Element parent, String refId, PrivateKey prKey, Certificate cert, OutputStream result, String signatureAlgorithm) throws SAML2Exception {
        if (result == null) {
            throw new SAML2Exception("Invalid result OutputStream: " + result);
        }
        StreamResult stream = new StreamResult(result);
        return this.sign(parent, DEFAULT_ID_ATTRIBUTE, refId, prKey, cert, stream, signatureAlgorithm);
    }

    @Override
    public String sign(Element parent, String idAttributeName, String refId, PrivateKey prKey, Certificate cert, OutputStream result, String signatureAlgorithm) throws SAML2Exception {
        if (result == null) {
            throw new SAML2Exception("Invalid result OutputStream: " + result);
        }
        StreamResult stream = new StreamResult(result);
        return this.sign(parent, idAttributeName, refId, prKey, cert, stream, signatureAlgorithm);
    }

    @Override
    public boolean verify(Element parent, Certificate cert) throws SAML2Exception {
        return this.verify(parent, cert, null, null);
    }

    @Override
    public boolean verify(Element parent, Certificate cert, String idAttributeLocalName, String idAttributeNS) throws SAML2Exception {
        if (cert == null) {
            throw new SAML2Exception("Certificate used to validate the signature cannot be null");
        }
        if (parent == null) {
            throw new SAML2Exception("Null element cannot be validated");
        }
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Certificate used to validate the signature: " + cert);
        }
        CertificateVerifier.getInstance().verifyCertificate(cert);
        try {
            NodeList nl = parent.getChildNodes();
            ArrayList<Element> signatures = new ArrayList<Element>();
            int i = 0;
            while (i < nl.getLength()) {
                Element element;
                Node node = nl.item(i);
                if (node instanceof Element && "http://www.w3.org/2000/09/xmldsig#".equals((element = (Element)node).getNamespaceURI()) && "Signature".equals(element.getLocalName())) {
                    if (LOCATION.beDebug()) {
                        LOCATION.debugT("Found signature {0}:{1}", new Object[]{signatures.size(), SAML2Utils.transformDOMForTrace(element)});
                    }
                    signatures.add(element);
                }
                ++i;
            }
            if (signatures.size() != 1) {
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("There is no unique signature in element:{0}", new Object[]{SAML2Utils.transformDOMForTrace(parent)});
                }
                throw new SAML2Exception("There is no unique signature in element:" + parent.getLocalName());
            }
            SignatureVerifier verifier = new SignatureVerifier((Element)signatures.get(0));
            verifier.setCertificate(cert);
            verifier.setPublicKey(cert.getPublicKey());
            if (idAttributeLocalName == null) {
                idAttributeLocalName = DEFAULT_ID_ATTRIBUTE;
                idAttributeNS = null;
            }
            verifier.setIDAttribute(idAttributeLocalName, idAttributeNS);
            boolean result = verifier.verify();
            if (result) {
                Reference[] ref;
                Attr idAttribute = parent.getAttributeNodeNS(idAttributeNS, idAttributeLocalName);
                if (idAttribute == null) {
                    if (LOCATION.beDebug()) {
                        LOCATION.debugT("ID attribute cannot be null for element:{0}", new Object[]{SAML2Utils.transformDOMForTrace(parent)});
                    }
                    throw new SAML2Exception("ID attribute cannot be null for element:" + parent.getLocalName());
                }
                String id = idAttribute.getValue();
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("ID attribute of the verified element:{0}", new Object[]{id});
                }
                if ((ref = verifier.getReferenceValidationResults()) == null) {
                    throw new SAML2Exception("No signed references found");
                }
                Reference[] referenceArray = ref;
                int n = ref.length;
                int n2 = 0;
                while (n2 < n) {
                    Reference reference = referenceArray[n2];
                    if (reference != null) {
                        if (LOCATION.beDebug()) {
                            LOCATION.debugT("Reference uri to check:{0}", new Object[]{reference.getURI()});
                        }
                        if (("#" + id).equals(reference.getURI())) {
                            return result;
                        }
                    } else if (LOCATION.beDebug()) {
                        LOCATION.debugT("Reference is null");
                    }
                    ++n2;
                }
                if (LOCATION.beWarning()) {
                    LOCATION.warningT("No reference found for element id:{0}", new Object[]{id});
                }
            }
            return false;
        }
        catch (SAML2Exception saml2Exception) {
            throw saml2Exception;
        }
        catch (Exception e) {
            throw new SAML2Exception("Verification failed.", e);
        }
    }

    private String sign(Element parent, String idAttributeName, String refId, PrivateKey prKey, Certificate cert, StreamResult result, String digestAlgorithm) throws SAML2Exception {
        Node signature = null;
        try {
            SignatureGenerator signer = new SignatureGenerator();
            signer.setGenerateNewLine(false);
            signer.setPrivateKey(prKey);
            if (cert != null) {
                signer.setCertificate(cert);
            } else {
                signer.showKeyInfo = false;
            }
            if (digestAlgorithm == null) {
                digestAlgorithm = "http://www.w3.org/2000/09/xmldsig#sha1";
            }
            String signatureAlgorithm = XMLSignatureDOM.extractSignatureAlgorithm(prKey, digestAlgorithm);
            signer.setSignatureAlgorithmURI(signatureAlgorithm);
            signer.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
            Transformation tr1 = TransformationFactory.newInstance().getInstance("http://www.w3.org/2000/09/xmldsig#enveloped-signature", new Object[0]);
            Transformation tr2 = TransformationFactory.newInstance().getInstance("http://www.w3.org/2001/10/xml-exc-c14n#", new Object[0]);
            signer.addReference("http://www.w3.org/2001/10/xml-exc-c14n#", "#" + refId, new Transformation[]{tr1, tr2}, digestAlgorithm);
            signer.setIDAttribute(idAttributeName, null);
            NodeList nl = parent.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
            if (nl == null || nl.getLength() < 1) {
                throw new SAML2Exception("There is no Signature element.");
            }
            signature = signer.generateHere((Element)nl.item(0));
            SAML2Utils.transformDOMtoXML(parent, result, true, false);
        }
        catch (Exception e) {
            throw new SAML2Exception("Failed to sign parent element: " + parent, e);
        }
        if (signature != null) {
            String sigXML = SAML2Utils.transformDOMtoXML(signature);
            return sigXML;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String extractSignatureAlgorithm(PrivateKey prKey, String digestAlgorithm) throws SAML2Exception {
        String signatureAlgorithm = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
        String algorithm = prKey.getAlgorithm();
        if (algorithm.equalsIgnoreCase("RSA")) {
            if ("http://www.w3.org/2000/09/xmldsig#sha1".equals(digestAlgorithm)) {
                signatureAlgorithm = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
            } else if ("http://www.w3.org/2001/04/xmlenc#sha256".equals(digestAlgorithm)) {
                signatureAlgorithm = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
            } else {
                if (!"http://www.w3.org/2001/04/xmlenc#sha512".equals(digestAlgorithm)) throw new SAML2Exception("Unsupported digest algorithm:" + digestAlgorithm + " for key type RSA.");
                signatureAlgorithm = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512";
            }
        } else {
            if (!algorithm.equalsIgnoreCase("DSA")) throw new SAML2Exception("Unsuported private key algorithm: " + algorithm + ". The supported are RSA and DSA.");
            if ("http://www.w3.org/2000/09/xmldsig#sha1".equals(digestAlgorithm)) {
                signatureAlgorithm = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
            } else {
                if (!"http://www.w3.org/2001/04/xmlenc#sha256".equals(digestAlgorithm)) throw new SAML2Exception("Unsupported digest algorithm:" + digestAlgorithm + " for key type DSA.");
                signatureAlgorithm = "http://www.w3.org/2009/xmldsig11#dsa-sha256";
            }
        }
        LOCATION.debugT("Signature algorithm deducted:{0}", new Object[]{signatureAlgorithm});
        return signatureAlgorithm;
    }

    public static String extractDigestAlgorithm(String signatureAlgorithm) throws SAML2Exception {
        if ("http://www.w3.org/2000/09/xmldsig#rsa-sha1".equals(signatureAlgorithm)) {
            return "http://www.w3.org/2000/09/xmldsig#sha1";
        }
        if ("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256".equals(signatureAlgorithm)) {
            return "http://www.w3.org/2001/04/xmlenc#sha256";
        }
        if ("http://www.w3.org/2001/04/xmldsig-more#rsa-sha512".equals(signatureAlgorithm)) {
            return "http://www.w3.org/2001/04/xmlenc#sha512";
        }
        if ("http://www.w3.org/2000/09/xmldsig#dsa-sha1".equals(signatureAlgorithm)) {
            return "http://www.w3.org/2000/09/xmldsig#sha1";
        }
        if ("http://www.w3.org/2009/xmldsig11#dsa-sha256".equals(signatureAlgorithm)) {
            return "http://www.w3.org/2001/04/xmlenc#sha256";
        }
        throw new SAML2Exception("Unknown signature algorithm:" + signatureAlgorithm);
    }
}

