/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.js.csrf;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.catalina.filters.CsrfPreventionFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestCsrfPreventionFilter
extends CsrfPreventionFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestCsrfPreventionFilter.class);
    public static final String CSRF_REST_NONCE_HEADER_NAME = "X-CSRF-Token";
    public static final String CSRF_REST_NONCE_HEADER_FETCH_VALUE = "Fetch";
    public static final String CSRF_REST_NONCE_HEADER_REQUIRED_VALUE = "Required";
    public static final String CSRF_REST_NONCE_SESSION_ATTR_NAME = "org.apache.catalina.filters.CSRF_REST_NONCE";
    public static final String ERROR_MESSAGE = "CSRF token validation failed!";
    private static final Pattern NON_MODIFYING_METHODS_PATTERN = Pattern.compile("GET|OPTIONS|HEAD");
    private Set<String> pathsAcceptingParams = new HashSet<String>();
    private String pathsDelimiter = ",";

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            HttpServletRequest req = (HttpServletRequest)request;
            HttpServletResponse res = (HttpServletResponse)response;
            String reqCsrfToken = this.getCurrentRequestToken(req);
            String sessCsrfToken = this.getCurrentSessionToken(req);
            if (this.isStateChangingRestRequest(req)) {
                if (!this.isValidCsrfRestRequest(reqCsrfToken, sessCsrfToken)) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Validating modifying request with method [" + req.getMethod() + "] and URI [" + req.getRequestURI() + "].");
                    }
                    res.setHeader(CSRF_REST_NONCE_HEADER_NAME, CSRF_REST_NONCE_HEADER_REQUIRED_VALUE);
                    res.sendError(403, ERROR_MESSAGE);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Csrf token is invalid for request with method [" + req.getMethod() + "] and URI [" + req.getRequestURI() + "]. Request will be rejected.");
                    }
                    return;
                }
            } else if (this.isFetchRestRequest(reqCsrfToken)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Processing fetch request with method [" + req.getMethod() + "] and URI [" + req.getRequestURI() + "].");
                }
                if (sessCsrfToken == null) {
                    sessCsrfToken = this.generateNonce();
                    req.getSession(true).setAttribute(CSRF_REST_NONCE_SESSION_ATTR_NAME, (Object)sessCsrfToken);
                }
                res.setHeader(CSRF_REST_NONCE_HEADER_NAME, sessCsrfToken);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Request with method [" + req.getMethod() + "] and URI [" + req.getRequestURI() + "] will be permitted.");
            }
        }
        chain.doFilter(request, response);
    }

    protected boolean isConfigProblemFatal() {
        return true;
    }

    private String getCurrentSessionToken(HttpServletRequest request) {
        HttpSession requestedSession = request.getSession(false);
        if (requestedSession != null && requestedSession.getAttribute(CSRF_REST_NONCE_SESSION_ATTR_NAME) != null) {
            return (String)requestedSession.getAttribute(CSRF_REST_NONCE_SESSION_ATTR_NAME);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("No csrf token stored in session for request with method [" + request.getMethod() + "] and URI [" + request.getRequestURI() + "].");
        }
        return null;
    }

    private String getCurrentRequestToken(HttpServletRequest request) {
        String crsfHeaderValue = request.getHeader(CSRF_REST_NONCE_HEADER_NAME);
        if ((crsfHeaderValue == null || "".equals(crsfHeaderValue)) && !this.pathsAcceptingParams.isEmpty()) {
            String path = request.getServletPath();
            if (request.getPathInfo() != null) {
                path = String.valueOf(path) + request.getPathInfo();
            }
            if (this.pathsAcceptingParams.contains(path)) {
                return this.getCSRFTokenAsRequestParam(request);
            }
        }
        return crsfHeaderValue;
    }

    private String getCSRFTokenAsRequestParam(HttpServletRequest request) {
        String[] paramTokens = request.getParameterValues(CSRF_REST_NONCE_HEADER_NAME);
        if (paramTokens == null) {
            return null;
        }
        if (paramTokens.length == 1) {
            return CSRF_REST_NONCE_HEADER_FETCH_VALUE.equals(paramTokens[0]) ? null : paramTokens[0];
        }
        String[] stringArray = paramTokens;
        int n = paramTokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            if (!token.equals(paramTokens[0])) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error("Different CSRF prevention token values are sent as request paramaters, hence none of them will be used.");
                }
                return null;
            }
            ++n2;
        }
        return CSRF_REST_NONCE_HEADER_FETCH_VALUE.equals(paramTokens[0]) ? null : paramTokens[0];
    }

    private boolean isFetchRestRequest(String reqXsrfToken) {
        return CSRF_REST_NONCE_HEADER_FETCH_VALUE.equalsIgnoreCase(reqXsrfToken);
    }

    private boolean isValidCsrfRestRequest(String reqCsrfToken, String sessCsrfToken) {
        return reqCsrfToken != null && sessCsrfToken != null && reqCsrfToken.equals(sessCsrfToken);
    }

    private boolean isStateChangingRestRequest(HttpServletRequest request) {
        return !NON_MODIFYING_METHODS_PATTERN.matcher(request.getMethod()).matches();
    }

    public void setPathsAcceptingParams(String pathsAcceptingParams) {
        if (pathsAcceptingParams != null) {
            String[] stringArray = pathsAcceptingParams.split(this.pathsDelimiter);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                this.pathsAcceptingParams.add(s.trim());
                ++n2;
            }
        }
    }
}

