/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.um.service;

import com.sap.core.jpaas.security.um.service.UMAdminConfigurationDomainDbReader;
import com.sap.core.jpaas.security.um.service.UserManagementConfiguration;
import com.sap.core.jpaas.security.um.service.ddb.UMServiceConfigurationReader;
import com.sap.core.jpaas.security.utils.TenantRetriever;
import com.sap.core.jpaas.security.utils.cache.TenantCache;
import com.sap.core.jpaas.security.utils.cache.TenantCacheValueReader;
import com.sap.security.um.service.api.exception.ConfigurationRetrievingException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminUserManagementConfiguration
extends UserManagementConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(AdminUserManagementConfiguration.class);
    private static LinkedHashMap<String, String> accountTenantCache = new LinkedHashMap(1000, 0.75f, true);
    private static TenantCache<Map<String, String>> adminCfgCache;
    private String account;

    public AdminUserManagementConfiguration(String account) {
        this.account = account;
        if (adminCfgCache == null) {
            this.createConfigurationCache();
        }
    }

    private void createConfigurationCache() {
        UMAdminConfigurationDomainDbReader dbReader = new UMAdminConfigurationDomainDbReader();
        adminCfgCache = new TenantCache((TenantCacheValueReader)new UMServiceConfigurationReader(dbReader), 120000L, 600000L);
    }

    @Override
    protected String getTenantId() {
        String tenantId = accountTenantCache.get(this.account);
        if (tenantId == null) {
            LOG.debug("Tenant ID for account: [{}] was not found in the cache. A retrieving request to Domain DB will be performed.", (Object)this.account);
            tenantId = this.retrieveTenantFromDomainDb();
            LOG.debug("Tenant ID: [{}] was successfully retrieved.", (Object)tenantId);
            accountTenantCache.put(this.account, tenantId);
        }
        return tenantId;
    }

    @Override
    public String get(Object key) {
        return this.getTenantConfiguration().get(key);
    }

    private Map<String, String> getTenantConfiguration() {
        Map cacheValue = (Map)adminCfgCache.getTenantCacheEntry(this.getTenantId()).getValue();
        return cacheValue != null ? cacheValue : new HashMap();
    }

    private String retrieveTenantFromDomainDb() {
        try {
            return new TenantRetriever().fetchDefaultTenantNameForAccount(this.account);
        }
        catch (Exception exception) {
            LOG.error("Could not retrieve tenant form DomainDB.", (Throwable)exception);
            throw new ConfigurationRetrievingException("Could not retrieve tenant form DomainDB.", exception);
        }
    }
}

