/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.um.service;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.sap.core.jpaas.security.um.service.DomainDBConfigurationData;
import com.sap.core.jpaas.security.um.service.UMConfigurationException;
import com.sap.core.jpaas.security.utils.connection.ConnectionException;
import com.sap.core.jpaas.security.utils.connection.Request;
import com.sap.core.jpaas.security.utils.connection.Response;
import com.sap.core.jpaas.security.utils.connection.impl.DomainDBConnection;
import com.sap.core.jpaas.security.utils.connection.impl.RequestBuilderFactory;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UMConfigurationDomainDbReader {
    private static final String UTF_8 = "UTF-8";
    protected static final String TENANT_CONFIGURATION_ROOT = "rest/configuration/tenant/";
    private static final String USER_MANAGEMENT_CONFIGURATION_RELATIVE_PATH = "/um/um_cfg.props";
    private static final Logger LOG = LoggerFactory.getLogger(UMConfigurationDomainDbReader.class);

    public Map<String, String> getConfiguration(String tenantId) throws UMConfigurationException {
        String cfgUrl = this.getTenantConfigurationPath(tenantId);
        Response response = this.fetchConfiguration(cfgUrl);
        if (response.isOK()) {
            try {
                HashMap<String, String> result = new HashMap<String, String>();
                Properties configurationProperties = this.toConfigurationProperties(response.asString());
                Set<String> keys = configurationProperties.stringPropertyNames();
                for (String key : keys) {
                    result.put(key, this.trim(configurationProperties.getProperty(key)));
                }
                LOG.debug("Obtained user management configuration from Domain DB:\n {}", result);
                return result;
            }
            catch (JsonSyntaxException e) {
                throw new UMConfigurationException("Content stored as user management configuration in Domain DB under path: " + cfgUrl + " is not a valid JSON. Content: " + response, e);
            }
            catch (UnsupportedEncodingException e1) {
                throw new UMConfigurationException("Could not obtain user management configuration from Domain DB.", e1);
            }
            catch (IOException e) {
                throw new UMConfigurationException("Could not load user management configuration for tenantId: " + tenantId + " read from Domain DB", e);
            }
        }
        if (response.is(404) || response.is(401)) {
            LOG.debug("User management configuration is not found in the Domain DB under path:{}", (Object)cfgUrl);
            return null;
        }
        throw new UMConfigurationException("Could not obtain user management configuration from Domain DB. Received response:\n" + response);
    }

    private Response fetchConfiguration(String url) throws UMConfigurationException {
        try {
            Request request = (Request)RequestBuilderFactory.createGETRequest().withPath(url).build();
            DomainDBConnection dbConnection = this.createDomainDBConnection();
            LOG.debug("Reading user management configuration from Domain DB under path: {}", (Object)url);
            Response response = dbConnection.execute(request);
            LOG.debug("Received response from the domain db: {}", (Object)response);
            return response;
        }
        catch (ConnectionException e) {
            throw new UMConfigurationException("Could not obtain user management configuration from Domain DB", e);
        }
    }

    DomainDBConnection createDomainDBConnection() {
        return new DomainDBConnection();
    }

    Properties toConfigurationProperties(String responseBody) throws IOException {
        DomainDBConfigurationData cfgData = (DomainDBConfigurationData)new Gson().fromJson(responseBody, DomainDBConfigurationData.class);
        String configurationData = new String(cfgData.getContent(), UTF_8);
        Properties configurationProperties = new Properties();
        configurationProperties.load(new StringReader(configurationData));
        return configurationProperties;
    }

    protected String getTenantConfigurationPath(String tenantId) {
        StringBuilder builder = new StringBuilder(100);
        builder.append(TENANT_CONFIGURATION_ROOT);
        builder.append(tenantId);
        builder.append(USER_MANAGEMENT_CONFIGURATION_RELATIVE_PATH);
        return builder.toString();
    }

    private String trim(String value) {
        return value == null ? null : value.trim();
    }
}

