/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.um.service;

import com.sap.core.jpaas.security.um.service.UMConfigurationException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UMConfigurationFileReader {
    private static final Logger LOG = LoggerFactory.getLogger(UMConfigurationFileReader.class);
    private static final String CHARSET_UTF_8 = "UTF-8";
    private static final UMConfigurationFileReader INSTANCE = new UMConfigurationFileReader();

    private UMConfigurationFileReader() {
    }

    public static UMConfigurationFileReader getInstance() {
        return INSTANCE;
    }

    public Map<String, String> getConfiguration() throws UMConfigurationException {
        String configurationFilePath = this.constructConfigurationFilePath();
        File cfgFile = new File(configurationFilePath);
        HashMap<String, String> result = null;
        if (cfgFile.exists() && cfgFile.isFile()) {
            String configurationData = this.readFile(cfgFile);
            result = new HashMap<String, String>();
            try {
                Properties configurationProperties = new Properties();
                configurationProperties.load(new StringReader(configurationData));
                Set<String> keys = configurationProperties.stringPropertyNames();
                for (String key : keys) {
                    result.put(key, this.trim(configurationProperties.getProperty(key)));
                }
            }
            catch (IOException e) {
                throw new UMConfigurationException("Could not load user management configuration read from the file system", e);
            }
            LOG.debug("Obtained user management configuration from file system:\n{}", result);
        } else {
            LOG.debug("User management file configuration is not found under path: {}", (Object)configurationFilePath);
        }
        return result;
    }

    private String constructConfigurationFilePath() {
        return String.valueOf(System.getProperty("server.config.home", ".")) + File.separator + "config_master" + File.separator + "com.sap.core.jpaas.security.um.service" + File.separator + "um_cfg.props";
    }

    private String readFile(File file) throws UMConfigurationException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[4056];
            int readBytesCount = -1;
            while ((readBytesCount = fis.read(buffer)) != -1) {
                out.write(buffer, 0, readBytesCount);
            }
            String string = out.toString(CHARSET_UTF_8);
            return string;
        }
        catch (Exception e) {
            throw new UMConfigurationException("Could not read configuration file: " + file, e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e) {
                    LOG.warn("Failed to close file: " + file, (Throwable)e);
                }
            }
        }
    }

    private String trim(String value) {
        if (value != null) {
            value = value.trim();
        }
        return value;
    }
}

