/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.um.service;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UMConfigurationVMPropertiesReader {
    private static final String UM_CONFIGURATION_PROPERTY_NAMESPACE = "com.sap.cloud.security.um.";
    private static final String UM_CONFIGURATION_PROPERTY_USER_PROVIDER_NAME = "com.sap.cloud.security.um.user_provider_name";
    private static final Logger LOG = LoggerFactory.getLogger(UMConfigurationVMPropertiesReader.class);
    private static final UMConfigurationVMPropertiesReader INSTANCE = new UMConfigurationVMPropertiesReader();

    private UMConfigurationVMPropertiesReader() {
    }

    public static UMConfigurationVMPropertiesReader getInstance() {
        return INSTANCE;
    }

    public Map<String, String> getConfiguration() {
        HashMap<String, String> result = null;
        if (System.getProperty(UM_CONFIGURATION_PROPERTY_USER_PROVIDER_NAME) != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("User management configuration is provided as system properties");
            }
            result = new HashMap<String, String>();
            Properties systemProperties = System.getProperties();
            Enumeration<?> propertyNames = systemProperties.propertyNames();
            while (propertyNames.hasMoreElements()) {
                String propertyName;
                Object key = propertyNames.nextElement();
                if (!(key instanceof String) || !(propertyName = (String)key).startsWith(UM_CONFIGURATION_PROPERTY_NAMESPACE)) continue;
                String umPropertyName = propertyName.substring(UM_CONFIGURATION_PROPERTY_NAMESPACE.length());
                result.put(umPropertyName, systemProperties.getProperty(propertyName));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("User management configuration properties: " + result);
            }
        }
        return result;
    }
}

