/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.um.service;

import com.sap.core.jpaas.security.um.service.UMConfigurationException;
import com.sap.core.jpaas.security.um.service.UMConfigurationFileReader;
import com.sap.core.jpaas.security.um.service.ddb.UMServiceConfigurationReader;
import com.sap.core.jpaas.security.utils.RuntimeUtils;
import com.sap.core.jpaas.security.utils.cache.TenantCache;
import com.sap.core.jpaas.security.utils.cache.TenantCacheValueReader;
import com.sap.core.tenant.api.Tenant;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserManagementConfiguration
implements Map<String, String> {
    private static final String CACHE_VALIDITY_PERIOD_PROPERTY = "configuration_cache_validity_period";
    private static final String CACHE_LAST_ACCESS_TIMEOUT_PROPERTY = "configuration_cache_last_access_timeout";
    private static final Logger LOG = LoggerFactory.getLogger(UserManagementConfiguration.class);
    private static final UserManagementConfiguration INSTANCE = new UserManagementConfiguration();
    static Map<String, String> cacheProperties = new HashMap<String, String>();
    private static final int DEFAULTCACHEVALIDITYPERIODINSECONDS = 120;
    private static final int DEFAULTCACHELASTACCESSTIMEOUTINSECONDS = 600;
    protected static final int DEFAULT_CACHE_VALIDITY_PERIOD_MILISECONDS = 120000;
    protected static final int DEFAULT_CACHE_LAST_ACCESS_TIMEOUT_MILISECONDS = 600000;
    static TenantCache<Map<String, String>> cache;

    public UserManagementConfiguration() {
        if (cache == null) {
            this.createConfigurationCache();
            if (RuntimeUtils.isRunningInNonOsgi()) {
                this.updateCacheProperties(this.readConfigurationPropertiesFromFileSystem());
            }
        }
    }

    private void createConfigurationCache() {
        cache = new TenantCache((TenantCacheValueReader)new UMServiceConfigurationReader(), 120000L, 600000L);
    }

    private Map<String, String> readConfigurationPropertiesFromFileSystem() {
        try {
            return UMConfigurationFileReader.getInstance().getConfiguration();
        }
        catch (UMConfigurationException exception) {
            LOG.error("Failed to read configuration from file system.", (Throwable)((Object)exception));
            return new HashMap<String, String>();
        }
    }

    public static synchronized UserManagementConfiguration getInstance() {
        return INSTANCE;
    }

    public synchronized void updateCacheProperties(Map<String, String> properties) {
        LOG.debug("Update properties {}", properties);
        if (properties != null) {
            cacheProperties = properties;
            this.updateCacheValidityPeriod(properties);
            this.updateCacheLastAccessTimeout(properties);
        }
    }

    private void updateCacheLastAccessTimeout(Map<String, String> properties) {
        Integer cacheLastAccessTimeoutInSeconds = this.getIntegerValueof(properties, CACHE_LAST_ACCESS_TIMEOUT_PROPERTY);
        if (cacheLastAccessTimeoutInSeconds == null) {
            return;
        }
        cache.setLastAccessTimeout((long)(cacheLastAccessTimeoutInSeconds * 1000));
    }

    private void updateCacheValidityPeriod(Map<String, String> properties) {
        Integer cacheValidityPeriodInSeconds = this.getIntegerValueof(properties, CACHE_VALIDITY_PERIOD_PROPERTY);
        if (cacheValidityPeriodInSeconds == null) {
            return;
        }
        cache.setValueTimeout((long)(cacheValidityPeriodInSeconds * 1000));
    }

    private Integer getIntegerValueof(Map<String, String> properties, String propertyName) {
        String propertyValue = properties.get(propertyName);
        if (propertyValue != null && propertyValue.trim().length() > 0) {
            try {
                return Integer.parseInt(propertyValue.trim());
            }
            catch (NumberFormatException numberFormatException) {
                LOG.warn("Configured \"{}\" property is not an integer: {}", (Object)propertyName, (Object)propertyValue);
            }
        }
        return null;
    }

    public String getUserProviderName() {
        return this.get("user_provider_name");
    }

    @Override
    public String get(Object key) {
        return this.getTenantConfiguration().get(key);
    }

    @Override
    public int size() {
        return this.getTenantConfiguration().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getTenantConfiguration().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getTenantConfiguration().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.getTenantConfiguration().containsValue(value);
    }

    @Override
    public String put(String key, String value) {
        throw new IllegalStateException("User management configuration is immutable");
    }

    @Override
    public String remove(Object key) {
        throw new IllegalStateException("User management configuration is immutable");
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        throw new IllegalStateException("User management configuration is immutable");
    }

    @Override
    public void clear() {
        throw new IllegalStateException("User management configuration is immutable");
    }

    @Override
    public Set<String> keySet() {
        return this.getTenantConfiguration().keySet();
    }

    @Override
    public Collection<String> values() {
        return this.getTenantConfiguration().values();
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.getTenantConfiguration().entrySet();
    }

    private Map<String, String> getTenantConfiguration() {
        Map cacheValue = (Map)cache.getTenantCacheEntry(this.getTenantId()).getValue();
        return cacheValue != null ? cacheValue : new HashMap();
    }

    protected String getTenantId() {
        String tenantId = Tenant.getId();
        if (this.getCacheProperties().containsKey("tenant_mapping_source")) {
            String tenantMappingSource = this.getCacheProperties().get("tenant_mapping_source");
            String tenantMappingTarget = this.getCacheProperties().get("tenant_mapping_target");
            if (tenantMappingSource != null && tenantMappingTarget != null && tenantMappingSource.equalsIgnoreCase(tenantId)) {
                tenantId = tenantMappingTarget;
            }
        }
        return tenantId;
    }

    public Map<String, String> getCacheProperties() {
        return cacheProperties;
    }
}

