/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.um.service;

import com.sap.core.jpaas.security.um.service.UserManagementConfiguration;
import com.sap.core.jpaas.security.um.service.osgi.UserProviderAccessorDSComponent;
import com.sap.core.jpaas.security.utils.RuntimeUtils;
import com.sap.security.um.user.PersistenceException;
import com.sap.security.um.user.UserProvider;
import com.sap.security.um.user.ext.UserProviderEx;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserProviderAccessor {
    private static final String DEFAULT_LOCAL_USER_PROVIDER_NAME = "local";
    private static final String DEFAULT_LOCAL_USER_PROVIDER_CLASS = "com.sap.security.um.provider.neo.local.UserProviderImpl";
    private static final Logger logger = LoggerFactory.getLogger(UserProviderAccessor.class);
    protected static UserProvider provider = null;

    public static UserProvider getUserProvider() throws PersistenceException {
        return UserProviderAccessor.getUserProvider(new UserManagementConfiguration().getUserProviderName());
    }

    public static UserProvider getUserProvider(String preferredUserProviderName) throws PersistenceException {
        if (preferredUserProviderName == null || "".equals(preferredUserProviderName)) {
            String msg = "Cannot determine preferred UserProvider name.";
            logger.error(msg);
            throw new PersistenceException(msg);
        }
        if (RuntimeUtils.isRunningInOsgi()) {
            logger.debug("Getting user provider as osgi service");
            return UserProviderAccessorDSComponent.getUserProvider(preferredUserProviderName);
        }
        logger.debug("Getting user provider as java service");
        UserProviderAccessor.loadProvider(preferredUserProviderName);
        if (provider == null) {
            logger.error("User provider not available");
            throw new PersistenceException("User provider not available");
        }
        return provider;
    }

    protected static void loadProvider(String preferredUserProviderName) throws PersistenceException {
        ServiceLoader<UserProvider> loader = ServiceLoader.load(UserProvider.class, UserProviderAccessor.class.getClassLoader());
        Iterator<UserProvider> iterator = loader.iterator();
        if (preferredUserProviderName != null) {
            while (iterator.hasNext()) {
                UserProvider current = iterator.next();
                if (current instanceof UserProviderEx) {
                    UserProviderEx userProvider = (UserProviderEx)current;
                    if (!preferredUserProviderName.equals(userProvider.getRegistrationId())) continue;
                    provider = userProvider;
                    break;
                }
                if (!DEFAULT_LOCAL_USER_PROVIDER_NAME.equals(preferredUserProviderName) || !DEFAULT_LOCAL_USER_PROVIDER_CLASS.equals(current.getClass().getName())) continue;
                provider = current;
                break;
            }
            if (provider == null) {
                logger.error("Configured User Management Provider with name: '" + preferredUserProviderName + "' is not found.");
                throw new PersistenceException("Configured User Management Provider with name: '" + preferredUserProviderName + "' is not found.");
            }
        } else if (iterator.hasNext()) {
            provider = iterator.next();
            return;
        }
    }
}

