/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.um.service.ddb;

import com.sap.core.jpaas.security.um.service.UMAdminConfigurationDomainDbReader;
import com.sap.core.jpaas.security.um.service.UMConfigurationDomainDbReader;
import com.sap.core.jpaas.security.um.service.UMConfigurationException;
import com.sap.core.jpaas.security.um.service.UMConfigurationFileReader;
import com.sap.core.jpaas.security.um.service.UMConfigurationVMPropertiesReader;
import com.sap.core.jpaas.security.um.service.UserManagementConfiguration;
import com.sap.core.jpaas.security.utils.cache.TenantCacheValueReader;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UMServiceConfigurationReader
implements TenantCacheValueReader<Map<String, String>> {
    private static final Logger LOG = LoggerFactory.getLogger(UMServiceConfigurationReader.class);
    private UMConfigurationDomainDbReader configurationReader;

    public UMServiceConfigurationReader() {
        this.configurationReader = new UMConfigurationDomainDbReader();
    }

    public UMServiceConfigurationReader(UMAdminConfigurationDomainDbReader dbReader) {
        this.configurationReader = dbReader;
    }

    public Map<String, String> readValue(String tenant, Map<String, String> currentValue) {
        Map<String, String> configurationProperties = null;
        if (this.isCloudCase()) {
            try {
                String configuredUserProvider;
                LOG.debug("Reading User Management configuration from Domain DB for the current tenant: {}", (Object)tenant);
                configurationProperties = this.configurationReader.getConfiguration(tenant);
                if (configurationProperties != null && this.isBlank(configuredUserProvider = configurationProperties.get("user_provider_name"))) {
                    LOG.error("Wrong user management configuration for tenant with id: {}. It does not contain property '{}' or its value is empty.", (Object)tenant, (Object)"user_provider_name");
                    return null;
                }
            }
            catch (Exception e) {
                LOG.error("An error occured while reading UM service configuration from DomainDB for tenant:{} ", (Object)tenant, (Object)e);
                LOG.debug("Cached UM service configuration will be returned for tenant: {}", (Object)tenant, (Object)e);
                return currentValue;
            }
        }
        if (configurationProperties == null && (configurationProperties = this.getConfigurationFromSystemProperties()) == null) {
            configurationProperties = this.getConfigurationFromFileSystem();
        }
        return configurationProperties;
    }

    private boolean isBlank(String configuredUserProvider) {
        return configuredUserProvider == null || configuredUserProvider.trim().length() == 0;
    }

    private Map<String, String> getConfigurationFromSystemProperties() {
        return UMConfigurationVMPropertiesReader.getInstance().getConfiguration();
    }

    private synchronized Map<String, String> getConfigurationFromFileSystem() {
        Map<String, String> defaultProperties;
        block5: {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Reading User Management configuration from the file system.");
            }
            if ((defaultProperties = new UserManagementConfiguration().getCacheProperties()).isEmpty()) {
                try {
                    Map<String, String> fileSystemProperties = UMConfigurationFileReader.getInstance().getConfiguration();
                    if (fileSystemProperties != null) {
                        defaultProperties.putAll(fileSystemProperties);
                    }
                }
                catch (UMConfigurationException e) {
                    if (!LOG.isDebugEnabled()) break block5;
                    LOG.debug("Could not read user management configuration from the file system", (Throwable)((Object)e));
                }
            }
        }
        return defaultProperties;
    }

    private boolean isCloudCase() {
        return System.getenv("HC_LANDSCAPE") != null || this.isSystemApplication();
    }

    private boolean isSystemApplication() {
        return System.getProperty("com.sap.cloud.security.um.db.read") != null;
    }
}

