/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.um.service.osgi;

import com.sap.security.um.user.PersistenceException;
import com.sap.security.um.user.UserProvider;
import com.sap.security.um.user.ext.UserProviderEx;
import org.osgi.service.component.ComponentContext;

public class UserProviderAccessorDSComponent {
    private static final String DEFAULT_LOCAL_USER_PROVIDER_NAME = "local";
    private static final String DEFAULT_LOCAL_USER_PROVIDER_CLASS = "com.sap.security.um.provider.neo.local.UserProviderImpl";
    private static ComponentContext context;

    public void activate(ComponentContext ctx) {
        context = ctx;
    }

    public void deactivate() {
        context = null;
    }

    public static UserProvider getUserProvider(String preferredUserProviderName) throws PersistenceException {
        if (context == null) {
            throw new PersistenceException("User Management is not initialized.");
        }
        UserProvider result = null;
        if (preferredUserProviderName != null) {
            Object[] userProviders;
            Object[] objectArray = userProviders = context.locateServices("UserProvider");
            int n = userProviders.length;
            int n2 = 0;
            while (n2 < n) {
                Object provider = objectArray[n2];
                if (provider instanceof UserProviderEx) {
                    UserProviderEx userProvider = (UserProviderEx)provider;
                    if (preferredUserProviderName.equals(userProvider.getRegistrationId())) {
                        result = userProvider;
                        break;
                    }
                } else if (DEFAULT_LOCAL_USER_PROVIDER_NAME.equals(preferredUserProviderName) && DEFAULT_LOCAL_USER_PROVIDER_CLASS.equals(provider.getClass().getName())) {
                    result = (UserProvider)provider;
                    break;
                }
                ++n2;
            }
            if (result == null) {
                throw new PersistenceException("Configured User Management Provider with name: '" + preferredUserProviderName + "' is not found.");
            }
        } else if (context != null) {
            UserProvider provider;
            result = provider = (UserProvider)context.locateService("UserProvider");
        } else {
            throw new PersistenceException("User Management is not initialized.");
        }
        return result;
    }
}

