/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.um.service.api;

import com.sap.core.jpaas.security.um.service.UserManagementConfiguration;
import com.sap.core.jpaas.security.utils.RuntimeUtils;
import com.sap.security.um.service.api.osgi.ModifiableUserProviderAccessorDSComponent;
import com.sap.security.um.user.PersistenceException;
import com.sap.security.um.user.ext.UserProviderEx;
import com.sap.security.um.user.modify.ModifiableUserProvider;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModifiableUserProviderAccessor {
    private static final String DEFAULT_LOCAL_USER_PROVIDER_CLASS = "com.sap.security.um.provider.neo.local.UserProviderImpl";
    private static final String DEFAULT_LOCAL_USER_PROVIDER_NAME = "local";
    private static final Logger LOG = LoggerFactory.getLogger(ModifiableUserProviderAccessor.class);
    protected static ModifiableUserProvider provider = null;

    public static ModifiableUserProvider getModifiableUserProvider() throws PersistenceException {
        String preferredUserProviderName;
        try {
            preferredUserProviderName = new UserManagementConfiguration().getUserProviderName();
        }
        catch (Exception e) {
            LOG.error("Could not obtain the configured user provider name", (Throwable)e);
            throw new PersistenceException("Could not obtain the configured user provider name", (Throwable)e);
        }
        if (RuntimeUtils.isRunningInOsgi()) {
            LOG.debug("Getting modifiable user provider as osgi service");
            return ModifiableUserProviderAccessorDSComponent.getModifiableUserProvider(preferredUserProviderName);
        }
        LOG.debug("Getting modifiable user provider as java service");
        ModifiableUserProviderAccessor.loadProvider(preferredUserProviderName);
        if (provider == null) {
            LOG.error("Modifiable User Management is not initialized!");
            throw new PersistenceException("Modifiable User Management is not initialized!");
        }
        return provider;
    }

    protected static void loadProvider(String preferredUserProviderName) throws PersistenceException {
        ServiceLoader<ModifiableUserProvider> loader = ServiceLoader.load(ModifiableUserProvider.class, ModifiableUserProviderAccessor.class.getClassLoader());
        Iterator<ModifiableUserProvider> iterator = loader.iterator();
        if (preferredUserProviderName != null) {
            while (iterator.hasNext()) {
                ModifiableUserProvider current = iterator.next();
                if (current instanceof UserProviderEx) {
                    UserProviderEx userProvider = (UserProviderEx)((Object)current);
                    if (!preferredUserProviderName.equals(userProvider.getRegistrationId())) continue;
                    provider = current;
                    break;
                }
                if (!DEFAULT_LOCAL_USER_PROVIDER_NAME.equals(preferredUserProviderName) || !DEFAULT_LOCAL_USER_PROVIDER_CLASS.equals(current.getClass().getName())) continue;
                provider = current;
                break;
            }
            if (provider == null) {
                throw new PersistenceException("Configured User Management Provider with name: '" + preferredUserProviderName + "' is not found.");
            }
        } else {
            if (iterator.hasNext()) {
                provider = iterator.next();
                return;
            }
            throw new PersistenceException("User Management is not initialized.");
        }
    }
}

