/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.um.service.api;

import com.sap.security.um.role.RoleProvider;
import com.sap.security.um.service.rolemanagement.RoleProviderService;
import com.sap.security.um.service.rolemanagement.RoleProviderServiceFactory;
import com.sap.security.um.user.PersistenceException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoleManagementAccessor {
    private static final Logger LOG = LoggerFactory.getLogger(RoleManagementAccessor.class);
    private static RoleManagementAccessor instance;
    private RoleProviderService roleProviderService;

    public RoleManagementAccessor() {
        this(new RoleProviderServiceFactory());
    }

    RoleManagementAccessor(RoleProviderServiceFactory serviceFactory) {
        this.roleProviderService = serviceFactory.create();
    }

    public static RoleManagementAccessor getInstance() {
        if (instance == null) {
            instance = new RoleManagementAccessor();
        }
        return instance;
    }

    public RoleProvider getRoleProvider() throws PersistenceException {
        RoleProvider roleProvider = this.roleProviderService.getRoleProvider();
        if (roleProvider == null) {
            LOG.error("Role Management is not initialized.");
            throw new PersistenceException("Role Management is not initialized.");
        }
        return roleProvider;
    }

    public Map<String, String> getRoleProviderConfiguration() throws PersistenceException {
        return this.roleProviderService.getRoleProviderConfiguration();
    }
}

