/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.um.service.api;

import com.sap.core.jpaas.security.utils.umhelper.SimpleUser;
import com.sap.security.um.user.User;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class UserSessionAccessor {
    static final String SESSION_KEY_USER = "com.sap.security.auth.login.User.";
    private static ThreadLocal<UserSessionAccessor> THREAD = new InheritableThreadLocal<UserSessionAccessor>(){

        @Override
        protected UserSessionAccessor childValue(UserSessionAccessor initial) {
            if (initial != null) {
                if (initial.request != null) {
                    return new UserSessionAccessor(initial.request.getSession(false), initial.request.getRemoteUser());
                }
                return new UserSessionAccessor(initial.session, initial.remoteUser);
            }
            return null;
        }
    };
    private static final Logger LOG = Logger.getLogger(UserSessionAccessor.class.getName());
    HttpServletRequest request = null;
    HttpSession session = null;
    String remoteUser = null;
    private User user;

    private UserSessionAccessor(HttpServletRequest request) {
        this.request = request;
    }

    UserSessionAccessor(HttpSession session, String remoteUser) {
        this.session = session;
        this.remoteUser = remoteUser;
    }

    private UserSessionAccessor(String remoteUser) {
        this(null, remoteUser);
        this.user = new SimpleUser(remoteUser);
    }

    private UserSessionAccessor(User user) {
        this.user = user;
    }

    public static void initializeAccessor(HttpServletRequest request) {
        THREAD.set(new UserSessionAccessor(request));
    }

    public static void initializeAccessor(String remoteUser) {
        THREAD.set(new UserSessionAccessor(remoteUser));
    }

    public static void initializeAccessor(User user) {
        THREAD.set(new UserSessionAccessor(user));
    }

    public static UserSessionAccessor getSessionAccessor() {
        UserSessionAccessor sessionAccessor = THREAD.get();
        if (sessionAccessor == null) {
            sessionAccessor = new UserSessionAccessor(null);
            THREAD.set(sessionAccessor);
        }
        return sessionAccessor;
    }

    public static void removeSessionAccessor() {
        THREAD.remove();
    }

    public User getUser(String name) {
        User toReturn = this.getUserFromSesssion(name);
        if (toReturn == null) {
            toReturn = this.user;
        }
        return toReturn;
    }

    private User getUserFromSesssion(String name) {
        HttpSession session;
        User user = null;
        HttpSession httpSession = session = this.request != null ? this.request.getSession(false) : this.session;
        if (session != null) {
            if (name != null && name.length() > 0) {
                try {
                    user = (User)session.getAttribute(SESSION_KEY_USER + this.normalizeUserName(name));
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.FINE, "User '" + name + "' returned from the current HTTP session.");
                    }
                }
                catch (IllegalStateException e) {
                    LOG.log(Level.FINE, "Cannot get user with name [" + name + "] from session. It is most likely invalid. The following exception is thrown.", e);
                }
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Cannot get user from session with name: '" + name + "'");
            }
        }
        return user;
    }

    public User getCurrentUser() {
        return this.getUser(this.getRequestRemoteUser());
    }

    public String getRequestRemoteUser() {
        if (this.request != null && this.request.getRemoteUser() != null) {
            return this.request.getRemoteUser();
        }
        return this.remoteUser;
    }

    public void putUser(User user) {
        HttpSession session;
        HttpSession httpSession = session = this.request != null ? this.request.getSession() : this.session;
        if (session != null && user != null) {
            String name = user.getName();
            if (name != null && name.length() > 0) {
                session.setAttribute(SESSION_KEY_USER + this.normalizeUserName(user.getName()), (Object)user);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "User " + user.getName() + " stored in the current HTTP session.");
                }
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Cannot store user in session with name: '" + name + "'");
            }
        } else {
            LOG.log(Level.FINE, "Cannot store user in session.");
        }
    }

    public void deleteUser(String name) {
        HttpSession session;
        HttpSession httpSession = session = this.request != null ? this.request.getSession(false) : this.session;
        if (session != null) {
            if (name != null && name.length() > 0) {
                session.setAttribute(SESSION_KEY_USER + this.normalizeUserName(name), null);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "User " + name + " removed from the current HTTP session.");
                }
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Cannot remove user from session with name: '" + name + "'");
            }
        }
    }

    String normalizeUserName(String userName) {
        String userNameLowerCase = userName.toLowerCase(Locale.ENGLISH);
        return userNameLowerCase;
    }
}

