/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.um.service.api.custom.roleprovider;

import com.google.gson.Gson;
import com.sap.core.jpaas.security.utils.ContentData;
import com.sap.core.jpaas.security.utils.cache.TenantCacheValueReader;
import com.sap.core.jpaas.security.utils.connection.Connection;
import com.sap.core.jpaas.security.utils.connection.ConnectionException;
import com.sap.core.jpaas.security.utils.connection.Request;
import com.sap.core.jpaas.security.utils.connection.Response;
import com.sap.core.jpaas.security.utils.connection.impl.DomainDBConnection;
import com.sap.core.jpaas.security.utils.connection.impl.URLRequest;
import com.sap.security.um.service.api.custom.roleprovider.CustomRoleProviderConfig;
import java.net.HttpURLConnection;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoleProviderConfigurationReader
implements TenantCacheValueReader<CustomRoleProviderConfig> {
    private static final Logger logger = LoggerFactory.getLogger(RoleProviderConfigurationReader.class);
    private static final String HC_ACCOUNT = "HC_ACCOUNT";
    private static final String HC_APPLICATION = "HC_APPLICATION";
    private static final String ROLE_PROVIDER_PATH_TEMPLATE = "/rest/configuration/account/%s/application/%s/tenant/%s/roleprovider/provider.json";

    public CustomRoleProviderConfig readValue(String tenant, CustomRoleProviderConfig currentValue) {
        Response response = null;
        try {
            Connection<HttpURLConnection> connection = this.createConnection();
            response = connection.execute(this.createRequest(tenant));
            if (response.isNotOK()) {
                logger.warn("Failed to read configuration for tenant: [{}], null will be returned. Response status code: [{}]", (Object)tenant, (Object)response.getStatus());
                return null;
            }
            String responseBody = this.extractConfigurationFrom(response.asString());
            logger.debug("Role provider configuration for tenant: [{}] was successfully read. Response body: [{}]", (Object)tenant, (Object)responseBody);
            CustomRoleProviderConfig customRoleProviderConfig = CustomRoleProviderConfig.fromJson(responseBody);
            return customRoleProviderConfig;
        }
        catch (ConnectionException exception) {
            if (this.isCloudCase()) {
                logger.error("Failed to read role provider configuration. Previously fetched configuration will be returned.", (Throwable)exception);
            } else {
                logger.debug("Failed to read role provider configuration. Previously fetched configuration will be returned.", (Throwable)exception);
            }
            CustomRoleProviderConfig customRoleProviderConfig = currentValue;
            return customRoleProviderConfig;
        }
        finally {
            if (response != null) {
                response.consume();
            }
        }
    }

    private boolean isCloudCase() {
        return this.getAccountName() != null && this.getApplicationName() != null;
    }

    Connection<HttpURLConnection> createConnection() {
        return new DomainDBConnection();
    }

    private Request<HttpURLConnection> createRequest(String tenant) {
        return (Request)new URLRequest.Builder().withPath(this.constructPath(tenant)).withGETMethod().build();
    }

    private String constructPath(String tenant) {
        return String.format(ROLE_PROVIDER_PATH_TEMPLATE, this.getAccountName(), this.getApplicationName(), tenant);
    }

    private String getApplicationName() {
        return System.getenv(HC_APPLICATION);
    }

    private String getAccountName() {
        return System.getenv(HC_ACCOUNT);
    }

    private String extractConfigurationFrom(String responseBody) {
        logger.debug("Trying to parse response body: [{}] to [{}]", (Object)responseBody, ContentData.class);
        ContentData contentData = (ContentData)new Gson().fromJson(responseBody, ContentData.class);
        if (contentData == null) {
            return null;
        }
        return new String(contentData.getContent(), StandardCharsets.UTF_8);
    }
}

