/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.um.service.api.osgi;

import com.sap.security.um.user.PersistenceException;
import com.sap.security.um.user.modify.ModifiableUserProvider;
import java.util.Collection;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModifiableUserProviderAccessorDSComponent {
    private static final Logger LOG = LoggerFactory.getLogger(ModifiableUserProviderAccessorDSComponent.class);
    private static ComponentContext context = null;
    private static ModifiableUserProvider provider = null;

    public void activate(ComponentContext ctx) {
        context = ctx;
    }

    public void deactivate() {
        context = null;
    }

    public static ModifiableUserProvider getModifiableUserProvider(String preferredUserProviderName) throws PersistenceException {
        if (context == null) {
            LOG.error("Modifiable User Management is not initialized.");
            throw new PersistenceException("Modifiable User Management is not initialized.");
        }
        ModifiableUserProvider result = null;
        if (preferredUserProviderName != null) {
            Collection serviceReferences = null;
            try {
                serviceReferences = context.getBundleContext().getServiceReferences(ModifiableUserProvider.class, "(user_provider_name=" + preferredUserProviderName + ")");
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                LOG.error("Configured User Management Provider with name: '" + preferredUserProviderName + "' is not found.");
                throw new PersistenceException("Configured User Management Provider with name: '" + preferredUserProviderName + "' is not found.");
            }
            if (serviceReferences != null && !serviceReferences.isEmpty()) {
                ServiceReference reference = serviceReferences.toArray(new ServiceReference[0])[0];
                result = (ModifiableUserProvider)context.getBundleContext().getService(reference);
            }
            if (result == null) {
                LOG.error("Configured Modifiable User Management Provider with name: '" + preferredUserProviderName + "' is not found.");
                throw new PersistenceException("Configured Modifiable User Management Provider with name: '" + preferredUserProviderName + "' is not found.");
            }
        } else {
            ModifiableUserProvider modifiableUserProvider = (ModifiableUserProvider)context.locateService("ModifiableUserProvider");
            if (modifiableUserProvider != null) {
                result = modifiableUserProvider;
            } else {
                LOG.error("Modifiable User Management is not initialized!");
                throw new PersistenceException("Modifiable User Management is not initialized!");
            }
        }
        return result;
    }
}

