/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.um.service.rolemanagement;

import com.sap.security.um.role.RoleProvider;
import com.sap.security.um.service.rolemanagement.RoleProviderRegistry;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiRoleProviderRegistry
implements RoleProviderRegistry {
    private static final Logger logger = LoggerFactory.getLogger(OsgiRoleProviderRegistry.class);
    private static Map<String, RoleProvider> implementations = new HashMap<String, RoleProvider>();

    @Override
    public RoleProvider getRoleProviderImplementation(String roleProviderId) {
        logger.debug("Role providers registerd [{}]", implementations);
        return implementations.get(roleProviderId);
    }

    public void bindRoleProvider(RoleProvider provider) {
        logger.debug("Binding role provider: {}", (Object)provider.getIdentifier());
        implementations.put(provider.getIdentifier(), provider);
    }

    public void unbindRoleProvider(RoleProvider provider) {
        logger.debug("Unbinding role provider: {}", (Object)provider.getIdentifier());
        implementations.remove(provider.getIdentifier());
    }
}

