/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.um.service.rolemanagement;

import com.sap.core.tenant.api.Tenant;
import com.sap.security.um.role.RoleProvider;
import com.sap.security.um.service.api.custom.roleprovider.CachedRoleProviderConfigurationReader;
import com.sap.security.um.service.api.custom.roleprovider.CustomRoleProviderConfig;
import com.sap.security.um.service.rolemanagement.RoleProviderRegistry;
import com.sap.security.um.service.rolemanagement.SystemPropertyUtil;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoleProviderService {
    private static final Logger logger = LoggerFactory.getLogger(RoleProviderService.class);
    RoleProviderRegistry roleProviderRegistry;
    private CachedRoleProviderConfigurationReader configReader;

    public RoleProviderService(RoleProviderRegistry registry) {
        this(registry, new CachedRoleProviderConfigurationReader());
    }

    public RoleProviderService(RoleProviderRegistry roleProviderRegistry, CachedRoleProviderConfigurationReader configReader) {
        this.roleProviderRegistry = roleProviderRegistry;
        this.configReader = configReader;
    }

    public Map<String, String> getRoleProviderConfiguration() {
        CustomRoleProviderConfig providerConfig = this.configReader.getProviderConfig(this.getTenantId());
        return providerConfig != null ? providerConfig.getConfigMap() : Collections.emptyMap();
    }

    public RoleProvider getRoleProvider() {
        String providerId = this.getRoleProviderId();
        logger.debug("Role provider ID that will be used [{}].", (Object)providerId);
        return this.roleProviderRegistry.getRoleProviderImplementation(providerId);
    }

    private String getRoleProviderId() {
        String id = this.fetchProviderId();
        if (id != null) {
            return id;
        }
        if (SystemPropertyUtil.isCRPSystemPropertySet()) {
            return SystemPropertyUtil.getSystemRoleProviderId();
        }
        return this.isCloudCase() ? "CLOUD" : "LOCAL";
    }

    private String fetchProviderId() {
        CustomRoleProviderConfig config = this.configReader.getProviderConfig(this.getTenantId());
        if (config == null) {
            return null;
        }
        logger.debug("Found domain db configuration for provider with id: {}.", (Object)config.getId());
        return config.getId();
    }

    String getTenantId() {
        return Tenant.getId();
    }

    private boolean isCloudCase() {
        return this.isPlatformApplication() || this.isSystemApplication();
    }

    private boolean isPlatformApplication() {
        return System.getenv("HC_LANDSCAPE") != null;
    }

    private boolean isSystemApplication() {
        return System.getProperty("com.sap.cloud.security.um.db.read") != null;
    }
}

