/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.um.service.rolemanagement;

import com.sap.security.um.role.RoleProvider;
import com.sap.security.um.service.rolemanagement.RoleProviderRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TomcatRoleProviderRegistry
implements RoleProviderRegistry {
    private static final Logger logger = LoggerFactory.getLogger(TomcatRoleProviderRegistry.class);
    private static Map<String, RoleProvider> implementations;

    @Override
    public RoleProvider getRoleProviderImplementation(String roleProviderId) {
        if (implementations == null) {
            this.loadRoleProviders();
        }
        logger.debug("Role providers registerd [{}]", implementations);
        return implementations.get(roleProviderId);
    }

    private void loadRoleProviders() {
        implementations = new HashMap<String, RoleProvider>();
        ServiceLoader<RoleProvider> providers = ServiceLoader.load(RoleProvider.class, this.getClass().getClassLoader());
        for (RoleProvider provider : providers) {
            implementations.put(provider.getIdentifier(), provider);
        }
    }
}

