/*
 * Decompiled with CFR 0.152.
 */
package com.sap.js.statistics.api;

import com.sap.js.statistics.api.DSRIRecord;
import com.sap.js.statistics.api.FilterCriteria;
import com.sap.js.statistics.api.reader.DSRIRecordBuffer;
import com.sap.js.statistics.api.reader.DSRRecordBuffer;
import com.sap.js.statistics.api.reader.DSRRecordBufferReversed;
import com.sap.js.statistics.api.reader.DsrJavaComponentFileNameFilter;
import com.sap.js.statistics.api.reader.DsrReaderException;
import com.sap.js.statistics.api.reader.DsrStatFileNameFilter;
import com.sap.js.statistics.api.reader.Utils;
import java.io.File;
import java.util.Arrays;

public class DsrDataReader {
    private DSRIRecordBuffer recBuffer = null;

    public DsrDataReader(String dsrRoot, String compName, long startTime, long endTime, FilterCriteria fc, boolean reverseRead) throws DsrReaderException {
        StringBuffer r = new StringBuffer();
        r.append(dsrRoot);
        if (!dsrRoot.endsWith(File.separator)) {
            r.append(File.separatorChar);
        }
        r.append(compName);
        r.append("_java");
        String[] files = this.getStatFileCandidateList(r.toString(), compName, startTime, endTime, reverseRead);
        if (files != null) {
            this.recBuffer = reverseRead ? new DSRRecordBufferReversed(startTime, endTime, fc, files) : new DSRRecordBuffer(startTime, endTime, fc, files);
        }
    }

    public DSRIRecord getNextRecord() throws DsrReaderException {
        if (this.recBuffer == null) {
            return null;
        }
        return this.recBuffer.getNextRecord();
    }

    public void close() {
    }

    public static String[] getAllAvailableComponents(String root) throws DsrReaderException {
        String[] componentList;
        File dsrRootDir;
        try {
            dsrRootDir = new File(root);
        }
        catch (Exception e) {
            throw new DsrReaderException("new File(" + root + ") failed with: " + e.getMessage(), e);
        }
        try {
            componentList = dsrRootDir.list(new DsrJavaComponentFileNameFilter());
        }
        catch (Exception e) {
            throw new DsrReaderException("dsrRootDir.list(" + dsrRootDir + ") failed with: " + e.getMessage(), e);
        }
        if (componentList == null) {
            throw new DsrReaderException("Probably " + dsrRootDir + " does not exist.");
        }
        if (componentList.length == 0) {
            throw new DsrReaderException("No available components in " + dsrRootDir);
        }
        int l = componentList.length;
        int l1 = "_java".length();
        String[] returnedComponentList = new String[l];
        int i = 0;
        while (i < l) {
            int l2 = componentList[i].length() - l1;
            returnedComponentList[i] = new String(componentList[i].substring(0, l2));
            ++i;
        }
        return returnedComponentList;
    }

    private String[] getStatFileCandidateList(String dsrRoot, String compName, long startTime, long endTime, boolean reverseRead) {
        try {
            DsrStatFileNameFilter filter = new DsrStatFileNameFilter(compName, dsrRoot, startTime, endTime, reverseRead);
            File f = new File(dsrRoot);
            String[] r1 = f.list(filter);
            if (r1 != null) {
                Arrays.sort(r1, filter);
                int l1 = r1.length;
                String[] r2 = new String[l1];
                StringBuffer sb = new StringBuffer();
                sb.append(dsrRoot);
                sb.append(File.separator);
                int l2 = sb.length();
                int i = 0;
                while (i < l1) {
                    int l3 = sb.length();
                    if (l3 > l2) {
                        sb.delete(l2, l3);
                    }
                    sb.append(r1[i]);
                    r2[i] = sb.toString();
                    ++i;
                }
                return r2;
            }
        }
        catch (Exception e) {
            Utils.trace("DsrDataReader.getStatFileCandidateList(): caught exception: " + e.getClass().getName() + " " + e.getMessage());
        }
        return null;
    }
}

