/*
 * Decompiled with CFR 0.152.
 */
package com.sap.js.statistics.api;

import com.sap.jdsr.writer.DsrIPassport;
import com.sap.js.statistics.api.DSRIExternalRecord;
import com.sap.js.statistics.api.DSRIHttpRecord;
import com.sap.js.statistics.api.DSRIMainRecord;
import com.sap.js.statistics.api.DSRIRecord;
import com.sap.js.statistics.api.writer.ConvertHelper;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class FilterCriteria {
    private Set<String> transIds = null;
    private String transId = null;
    private String rootId = null;
    private String connId = null;
    private int connCounter = -1;
    private String action = null;
    private int actionType = -1;
    private int serviceType = -1;
    private String user = null;
    private long respTimeMin = -1L;
    private long respTimeMax = -1L;
    private long cpuTimeMin = -1L;
    private long cpuTimeMax = -1L;
    private int dbTimeMin = -1;
    private int dbTimeMax = -1;
    private long extTimeMin = -1L;
    private long extTimeMax = -1L;
    private long extCallTimeMin = -1L;
    private long extCallTimeMax = -1L;
    private String extType = null;
    private String extSystem = null;
    private String sessionId = null;

    public boolean isOK(DSRIRecord rec) {
        int i;
        DSRIMainRecord main = rec.getMainRecord();
        DsrIPassport pass = rec.getPassportRecord();
        DSRIExternalRecord[] extRecs = rec.getExternalRecords();
        if (this.transId != null && !this.transId.equalsIgnoreCase(main.getTransId())) {
            return false;
        }
        if (this.transIds != null && !this.transIds.contains(main.getTransId().toLowerCase(Locale.ENGLISH))) {
            return false;
        }
        if (this.rootId != null) {
            if (pass == null) {
                return false;
            }
            if (!this.rootId.equalsIgnoreCase(pass.getRootContextIdHex())) {
                return false;
            }
        }
        if (this.connId != null) {
            if (pass == null) {
                return false;
            }
            if (!this.connId.equalsIgnoreCase(pass.getConnectionIdHex())) {
                return false;
            }
        }
        if (this.connCounter != -1) {
            if (pass == null) {
                return false;
            }
            if (this.connCounter != pass.getConnectionCounter()) {
                return false;
            }
        }
        if (this.sessionId != null) {
            DSRIHttpRecord httpRec = rec.getHttpRecord();
            if (httpRec == null) {
                return false;
            }
            if (!this.sessionId.equalsIgnoreCase(httpRec.getHttpRequestId())) {
                return false;
            }
        }
        if (this.action != null) {
            String tmp = main.getAction();
            if (tmp == null) {
                return false;
            }
            if (tmp.toLowerCase(Locale.ENGLISH).indexOf(this.action.toLowerCase(Locale.ENGLISH)) == -1) {
                return false;
            }
        }
        if (this.user != null && !this.searchPatternInString(this.user, main.getUserId())) {
            return false;
        }
        if (this.actionType != -1 && this.actionType != main.getActionType()) {
            return false;
        }
        if (this.serviceType != -1 && this.serviceType != main.getServiceType()) {
            return false;
        }
        if (this.respTimeMin != -1L && this.respTimeMin > main.getRespTime()) {
            return false;
        }
        if (this.respTimeMax != -1L && this.respTimeMax < main.getRespTime()) {
            return false;
        }
        if (this.cpuTimeMin != -1L && this.cpuTimeMin > main.getCpuTime()) {
            return false;
        }
        if (this.cpuTimeMax != -1L && this.cpuTimeMax < main.getCpuTime()) {
            return false;
        }
        if (this.extTimeMin != -1L && this.extTimeMin > main.getExternalTime()) {
            return false;
        }
        if (this.extTimeMax != -1L && this.extTimeMax < main.getExternalTime()) {
            return false;
        }
        if (this.dbTimeMin != -1 && (long)this.dbTimeMin > main.getDbTime()) {
            return false;
        }
        if (this.dbTimeMax != -1 && (long)this.dbTimeMax < main.getDbTime()) {
            return false;
        }
        if (this.extCallTimeMin != -1L) {
            if (extRecs == null) {
                return false;
            }
            boolean found = false;
            i = 0;
            while (i < extRecs.length) {
                if (this.extCallTimeMin <= extRecs[i].getCallTime()) {
                    found = true;
                    break;
                }
                ++i;
            }
            if (!found) {
                return false;
            }
        }
        if (this.extCallTimeMax != -1L) {
            if (extRecs == null) {
                return false;
            }
            boolean found = false;
            i = 0;
            while (i < extRecs.length) {
                if (this.extCallTimeMax >= extRecs[i].getCallTime()) {
                    found = true;
                    break;
                }
                ++i;
            }
            if (!found) {
                return false;
            }
        }
        if (this.extType != null) {
            if (extRecs == null) {
                return false;
            }
            boolean found = false;
            i = 0;
            while (i < extRecs.length) {
                if (this.extType.equalsIgnoreCase(extRecs[i].getTypeString())) {
                    found = true;
                    break;
                }
                ++i;
            }
            if (!found) {
                return false;
            }
        }
        if (this.extSystem != null) {
            if (extRecs == null) {
                return false;
            }
            boolean found = false;
            i = 0;
            while (i < extRecs.length) {
                if (this.extSystem.equalsIgnoreCase(extRecs[i].getSystemId())) {
                    found = true;
                    break;
                }
                ++i;
            }
            if (!found) {
                return false;
            }
        }
        return true;
    }

    public void addTransId(String transId) {
        if (this.transIds == null) {
            this.transIds = new HashSet<String>(10);
        }
        this.transIds.add(transId.toLowerCase(Locale.ENGLISH));
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setActionType(int actionType) {
        this.actionType = actionType;
    }

    public void setConnCounter(int connCounter) {
        this.connCounter = connCounter;
    }

    public void setConnId(String connId) {
        this.connId = connId;
    }

    public void setCpuTimeMax(long cpuTimeMax) {
        this.cpuTimeMax = cpuTimeMax;
    }

    public void setCpuTimeMin(long cpuTimeMin) {
        this.cpuTimeMin = cpuTimeMin;
    }

    public void setDbTimeMax(int dbTimeMax) {
        this.dbTimeMax = dbTimeMax;
    }

    public void setDbTimeMin(int dbTimeMin) {
        this.dbTimeMin = dbTimeMin;
    }

    public void setExtCalTimeMax(long extCalTimeMax) {
        this.extCallTimeMax = extCalTimeMax;
    }

    public void setExtCalTimeMin(long extCalTimeMin) {
        this.extCallTimeMin = extCalTimeMin;
    }

    public void setExtSystem(String extSystem) {
        this.extSystem = extSystem;
    }

    public void setExtTimeMax(long extTimeMax) {
        this.extTimeMax = extTimeMax;
    }

    public void setExtTimeMin(long extTimeMin) {
        this.extTimeMin = extTimeMin;
    }

    public void setExtType(String extType) {
        this.extType = extType;
    }

    public void setRespTimeMax(long respTimeMax) {
        this.respTimeMax = respTimeMax;
    }

    public void setRespTimeMin(long respTimeMin) {
        this.respTimeMin = respTimeMin;
    }

    public void setRootId(String rootId) {
        this.rootId = ConvertHelper.formatTraceGuid(rootId);
    }

    public void setServiceType(int serviceType) {
        this.serviceType = serviceType;
    }

    public void setTransId(String transId) {
        this.transId = transId;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    private boolean searchPatternInString(String pattern, String subject) {
        if (pattern == null || subject == null) {
            return false;
        }
        String _pattern = pattern.toLowerCase(Locale.ENGLISH);
        String _subject = subject.toLowerCase(Locale.ENGLISH);
        boolean start = _pattern.startsWith("*");
        boolean end = _pattern.endsWith("*");
        if (start && end) {
            if (_pattern.length() < 2) {
                return true;
            }
            return _subject.indexOf(_pattern.substring(1, _pattern.length() - 1)) != -1;
        }
        if (start) {
            return _subject.endsWith(_pattern.substring(1));
        }
        if (end) {
            return _subject.startsWith(_pattern.substring(0, _pattern.length() - 1));
        }
        return _subject.indexOf(_pattern) != -1;
    }
}

