/*
 * Decompiled with CFR 0.152.
 */
package com.sap.js.statistics.api.reader;

import com.sap.js.statistics.api.DSRIRecord;
import com.sap.js.statistics.api.FilterCriteria;
import com.sap.js.statistics.api.reader.DSRIRecordBuffer;
import com.sap.js.statistics.api.reader.DSRRecordsReader;
import com.sap.js.statistics.api.reader.DsrIndexReader;
import com.sap.js.statistics.api.reader.DsrReaderException;
import com.sap.js.statistics.api.writer.DSRRecord;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.log4j.Logger;

public class DSRRecordBuffer
implements DSRIRecordBuffer {
    private static final int RECORDS_BUFFER = 100;
    private static final Logger logger = Logger.getLogger(DSRRecordBuffer.class);
    private DSRIRecord[] recordsBuffer = null;
    private int recordsInBuffer = 0;
    private int currentRecord = 0;
    private int currentFileNumber = 0;
    private long currentFileReadPosition = 0L;
    private long startTime;
    private long endTime;
    private String[] dsrFiles;
    private FilterCriteria filter;
    private BufferedInputStream bufferedInputStream = null;
    private DSRRecordsReader recordReader = null;
    private FileInputStream fileInputStream = null;

    public DSRRecordBuffer(long startTime, long endTime, FilterCriteria fc, String[] files) throws DsrReaderException {
        this.startTime = startTime;
        this.endTime = endTime;
        if (files != null) {
            this.dsrFiles = new String[files.length];
            int i = 0;
            while (i < files.length) {
                this.dsrFiles[i] = files[i];
                ++i;
            }
        }
        this.filter = fc;
        if (this.dsrFiles == null || this.dsrFiles.length == 0) {
            return;
        }
        this.recordsBuffer = new DSRRecord[100];
        DsrIndexReader sixReader = new DsrIndexReader(this.dsrFiles, startTime);
        long pos = sixReader.getReadPositionFromIndex();
        if (pos == -1L) {
            ++this.currentFileNumber;
            if (this.currentFileNumber > this.dsrFiles.length) {
                return;
            }
        }
        if (pos > 0L) {
            this.currentFileReadPosition = pos;
        }
        this.initInputStream();
        if (this.bufferedInputStream == null) {
            return;
        }
        try {
            this.recordReader = new DSRRecordsReader(this.bufferedInputStream, this.currentFileReadPosition, endTime);
            this.resetRecordsBuffer();
        }
        catch (IOException e) {
            throw new DsrReaderException("DSRRecordBuffer() IOException: " + e.getMessage(), e);
        }
    }

    @Override
    public DSRIRecord getNextRecord() throws DsrReaderException {
        if (this.currentRecord < this.recordsInBuffer) {
            return this.recordsBuffer[this.currentRecord++];
        }
        if (this.currentRecord == this.recordsInBuffer && this.recordsInBuffer == 100) {
            try {
                this.resetRecordsBuffer();
            }
            catch (IOException e) {
                throw new DsrReaderException("DSRRecordBuffer.getNextRecord IOException: " + e.getMessage(), e);
            }
            if (this.recordsInBuffer > 0) {
                return this.recordsBuffer[this.currentRecord++];
            }
        }
        return null;
    }

    private void resetRecordsBuffer() throws DsrReaderException, IOException {
        this.currentRecord = 0;
        this.recordsInBuffer = 0;
        while (this.recordsInBuffer < 100) {
            DSRRecord rec = this.recordReader.readNextRecord();
            this.currentFileReadPosition = this.recordReader.getCurrentFileReadPosition();
            if (rec == null) {
                this.initInputStream();
                if (this.bufferedInputStream == null) break;
                this.recordReader = new DSRRecordsReader(this.bufferedInputStream, this.currentFileReadPosition, this.endTime);
                rec = this.recordReader.readNextRecord();
                this.currentFileReadPosition = this.recordReader.getCurrentFileReadPosition();
                if (rec == null) break;
            }
            if (rec.getMainRecord().getStartTime() < this.startTime || this.filter != null && !this.filter.isOK(rec)) continue;
            this.recordsBuffer[this.recordsInBuffer] = rec;
            ++this.recordsInBuffer;
        }
    }

    private void initInputStream() {
        if (this.bufferedInputStream == null) {
            this.openStream();
        }
        try {
            this.bufferedInputStream.mark(10);
            if (-1 == this.bufferedInputStream.read()) {
                this.incrInputStreamCount();
                return;
            }
            this.bufferedInputStream.reset();
        }
        catch (Exception exception) {
            this.incrInputStreamCount();
        }
    }

    private void incrInputStreamCount() {
        this.closeStream();
        ++this.currentFileNumber;
        this.currentFileReadPosition = 0L;
        if (this.currentFileNumber >= this.dsrFiles.length) {
            return;
        }
        this.openStream();
    }

    private void openStream() {
        try {
            long skipped;
            this.fileInputStream = new FileInputStream(this.dsrFiles[this.currentFileNumber]);
            this.bufferedInputStream = new BufferedInputStream(this.fileInputStream);
            if (0L < this.currentFileReadPosition && (skipped = this.bufferedInputStream.skip(this.currentFileReadPosition)) != this.currentFileReadPosition) {
                logger.warn((Object)("Cannot skip [" + this.currentFileReadPosition + "] bytes; skipped [" + skipped + "] instead"));
            }
            return;
        }
        catch (IOException iOException) {
            this.closeStream();
            try {
                long skipped;
                this.fileInputStream = new FileInputStream(this.dsrFiles[this.currentFileNumber]);
                this.bufferedInputStream = new BufferedInputStream(this.fileInputStream);
                if (0L < this.currentFileReadPosition && (skipped = this.bufferedInputStream.skip(this.currentFileReadPosition)) != this.currentFileReadPosition) {
                    logger.warn((Object)("Cannot skip [" + this.currentFileReadPosition + "] bytes; skipped [" + skipped + "] instead"));
                }
            }
            catch (IOException e) {
                logger.error((Object)"Cannot open DSR file", (Throwable)e);
            }
            return;
        }
    }

    private void closeStream() {
        if (this.bufferedInputStream != null) {
            try {
                this.bufferedInputStream.close();
            }
            catch (IOException iOException) {}
            this.bufferedInputStream = null;
        }
        if (this.fileInputStream != null) {
            try {
                this.fileInputStream.close();
            }
            catch (IOException iOException) {}
            this.fileInputStream = null;
        }
    }
}

