/*
 * Decompiled with CFR 0.152.
 */
package com.sap.js.statistics.api.reader;

import com.sap.js.statistics.api.DSRIRecord;
import com.sap.js.statistics.api.FilterCriteria;
import com.sap.js.statistics.api.reader.DSRIRecordBuffer;
import com.sap.js.statistics.api.reader.DSRRecordsReader;
import com.sap.js.statistics.api.reader.DsrReaderException;
import com.sap.js.statistics.api.reader.ListItem;
import com.sap.js.statistics.api.writer.DSRRecord;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.log4j.Logger;

public class DSRRecordBufferReversed
implements DSRIRecordBuffer {
    private static final int RECORDS_BUFFER = 100;
    private static final Logger logger = Logger.getLogger(DSRRecordBufferReversed.class);
    private ListItem firstItem = null;
    private ListItem lastItem = null;
    private ListItem currentItem = null;
    private int recordsInQueue;
    private int currentFileNumber = 0;
    private long currentFileReadPosition;
    private long startTime;
    private long endTime;
    private String[] dsrFiles;
    private FilterCriteria filter;
    private long lastFilePos = -1L;
    private BufferedInputStream bufferedInputStream = null;
    private DSRRecordsReader recordReader = null;
    private FileInputStream fileInputStream = null;

    public DSRRecordBufferReversed(long startTime, long endTime, FilterCriteria fc, String[] files) throws DsrReaderException {
        this.startTime = startTime;
        this.endTime = endTime;
        this.dsrFiles = files;
        this.filter = fc;
        if (this.dsrFiles == null || this.dsrFiles.length == 0) {
            return;
        }
        try {
            this.resetRecordsBuffer();
        }
        catch (IOException e) {
            throw new DsrReaderException("DSRRecordBufferReversed() IOException: " + e.getMessage(), e);
        }
    }

    @Override
    public DSRIRecord getNextRecord() throws DsrReaderException {
        ListItem item = this.getNextItemFromQuue();
        if (item != null) {
            return item.getRecord();
        }
        try {
            this.resetRecordsBuffer();
        }
        catch (IOException e) {
            throw new DsrReaderException("DSRRecordBufferReversed.getNextRecord IOException: " + e.getMessage(), e);
        }
        item = this.getNextItemFromQuue();
        if (item != null) {
            return item.getRecord();
        }
        return null;
    }

    private void resetRecordsBuffer() throws DsrReaderException, IOException {
        this.firstItem = null;
        this.lastItem = null;
        this.currentItem = null;
        this.currentFileReadPosition = 0L;
        this.recordsInQueue = 0;
        this.closeStream();
        if (this.lastFilePos == 0L) {
            ++this.currentFileNumber;
            this.lastFilePos = -1L;
        }
        this.openStream();
        if (this.bufferedInputStream == null) {
            return;
        }
        this.recordReader = new DSRRecordsReader(this.bufferedInputStream, 0L, this.endTime);
        while (this.lastFilePos != this.currentFileReadPosition) {
            long recPos = this.recordReader.getCurrentFileReadPosition();
            DSRRecord rec = this.recordReader.readNextRecord();
            this.currentFileReadPosition = this.recordReader.getCurrentFileReadPosition();
            if (rec == null) break;
            if (rec.getMainRecord().getStartTime() < this.startTime || this.filter != null && !this.filter.isOK(rec)) continue;
            ListItem item = new ListItem(rec, recPos);
            this.addItemToQueue(item);
        }
        this.lastFilePos = this.lastItem != null ? this.lastItem.getPosition() : 0L;
    }

    private void addItemToQueue(ListItem item) {
        if (this.firstItem != null) {
            item.setNext(this.firstItem);
            this.firstItem.setPrev(item);
            this.firstItem = item;
            ++this.recordsInQueue;
            if (this.recordsInQueue > 100) {
                this.lastItem.getPrev().setNext(null);
                this.lastItem = this.lastItem.getPrev();
                --this.recordsInQueue;
            }
        } else {
            this.firstItem = item;
            this.lastItem = item;
            ++this.recordsInQueue;
        }
        this.currentItem = this.firstItem;
    }

    private ListItem getNextItemFromQuue() {
        if (this.currentItem != null) {
            ListItem returnItem = this.currentItem;
            this.currentItem = this.currentItem == this.lastItem ? null : this.currentItem.getNext();
            return returnItem;
        }
        return null;
    }

    private void openStream() {
        try {
            this.fileInputStream = new FileInputStream(this.dsrFiles[this.currentFileNumber]);
            this.bufferedInputStream = new BufferedInputStream(this.fileInputStream);
            return;
        }
        catch (IOException e) {
            logger.error((Object)"Cannot open DSR file", (Throwable)e);
            return;
        }
    }

    private void closeStream() {
        if (this.bufferedInputStream != null) {
            try {
                this.bufferedInputStream.close();
            }
            catch (IOException iOException) {}
            this.bufferedInputStream = null;
        }
        if (this.fileInputStream != null) {
            try {
                this.fileInputStream.close();
            }
            catch (IOException iOException) {}
            this.fileInputStream = null;
        }
    }
}

